/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.hsltorgb;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.impl.ColorManager;
import org.gvsig.raster.lib.legend.impl.RasterLegendManagerServices;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;

public class HSLToRGBOperation
extends AbstractColoredOperation {
    public HSLToRGBOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        try {
            if (!this.getInputColorInterpretation().isHSL()) {
                throw new UnsupportedOperationException("The color interpretation of input getInputBuffer() isn't HSL");
            }
            int[] inputBandTypes = this.getInputBuffer().getBandTypes();
            if (inputBandTypes[this.getInputColorInterpretation().getBand("Hue")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Saturation")] != 0 || inputBandTypes[this.getInputColorInterpretation().getBand("Lightness")] != 0) {
                throw new UnsupportedOperationException("The type of bands isn't BYTE");
            }
            int sourceBands = this.getInputBuffer().getBandCount();
            NoData[] sourceNoDatas = this.getInputBuffer().getBandNoData();
            int[] sourceTypes = this.getInputBuffer().getBandTypes();
            ArrayList<String> colorInterpretations = new ArrayList<String>();
            ArrayList<NoData> noDatas = new ArrayList<NoData>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            colorInterpretations.add("Red");
            colorInterpretations.add("Green");
            colorInterpretations.add("Blue");
            types.add(0);
            types.add(0);
            types.add(0);
            noDatas.add(null);
            noDatas.add(null);
            noDatas.add(null);
            if (this.getInputColorInterpretation().hasAlphaBand()) {
                int alphaBand = this.getInputColorInterpretation().getAlphaBand();
                if (sourceTypes[alphaBand] != 0) {
                    throw new UnsupportedOperationException("The type of ALPHA band isn't BYTE");
                }
                colorInterpretations.add("Alpha");
                types.add(sourceTypes[alphaBand]);
                noDatas.add(sourceNoDatas[alphaBand]);
            }
            if (this.mustCopyUnprocessedBands()) {
                for (int band = 0; band < sourceBands; ++band) {
                    if (this.isProcessableBand(band) || this.getInputColorInterpretation().isAlphaInterpretation(band)) continue;
                    colorInterpretations.add(this.getInputColorInterpretation().get(band));
                    noDatas.add(sourceNoDatas[band]);
                    types.add(this.getInputBuffer().getBandTypes()[band]);
                }
            }
            this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
            this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    public void process() throws ProcessingOperationException {
        super.process();
        try {
            if (this.mustCopyUnprocessedBands()) {
                int bands = this.getInputBuffer().getBandCount();
                int outBand = this.getInputColorInterpretation().hasAlphaBand() ? 4 : 3;
                for (int band = 0; band < bands; ++band) {
                    if (this.getInputColorInterpretation().isAlphaInterpretation(band)) {
                        this.getOutputBuffer().getBand(this.getOutputColorInterpretation().getAlphaBand()).copyFrom(this.getInputBuffer().getBand(band));
                        continue;
                    }
                    if (this.isProcessableBand(band)) continue;
                    this.getOutputBuffer().getBand(outBand).copyFrom(this.getInputBuffer().getBand(band));
                    ++outBand;
                }
            }
            Object[] rowBandsBuffer = new Object[3];
            for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                Band outputBufferBand;
                int band;
                Band bufferBandHue = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Hue"));
                rowBandsBuffer[0] = bufferBandHue.createRowBuffer();
                bufferBandHue.fetchRow(row, rowBandsBuffer[0]);
                Band bufferBandSaturation = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Saturation"));
                rowBandsBuffer[1] = bufferBandSaturation.createRowBuffer();
                bufferBandSaturation.fetchRow(row, rowBandsBuffer[1]);
                Band bufferBandLightness = this.getInputBuffer().getBand(this.getInputColorInterpretation().getBand("Lightness"));
                rowBandsBuffer[2] = bufferBandLightness.createRowBuffer();
                bufferBandLightness.fetchRow(row, rowBandsBuffer[2]);
                ArrayList<Object> outputRowBuffers = new ArrayList<Object>();
                for (band = 0; band < 3; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputRowBuffers.add(outputRowBuffer);
                }
                this.processRow(rowBandsBuffer, outputRowBuffers);
                for (band = 0; band < 3; ++band) {
                    outputBufferBand = this.getOutputBuffer().getBand(band);
                    outputBufferBand.putRow(row, outputRowBuffers.get(band));
                }
            }
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private void processRow(Object[] inputRows, List outputRows) {
        int i;
        ColorManager colorManager = ((RasterLegendManagerServices)RasterLegendLocator.getRasterLegendManager()).getColorManager();
        byte[][] inputByteRows = new byte[inputRows.length][((byte[])inputRows[0]).length];
        for (i = 0; i < inputRows.length; ++i) {
            inputByteRows[i] = (byte[])inputRows[i];
        }
        for (i = 0; i < inputByteRows[0].length; ++i) {
            int[] convertedValues = colorManager.HSLtoRGB(0xFF & inputByteRows[0][i], 0xFF & inputByteRows[1][i], 0xFF & inputByteRows[2][i]);
            for (int band = 0; band < outputRows.size(); ++band) {
                ((byte[])outputRows.get((int)band))[i] = Integer.valueOf(convertedValues[band]).byteValue();
            }
        }
    }

    protected boolean isProcessableBand(int band) {
        return this.isHSLBand(band) && this.getInputBuffer().getBandTypes()[band] == 0;
    }

    private boolean isHSLBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Hue") || bandColorInterpretation.equals("Saturation") || bandColorInterpretation.equals("Lightness");
    }
}

