/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.app.osmclient;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.osm.app.osmclient.layer.FLyrOSM;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.gvsig.raster.osm.io.OSMProvider;
import org.gvsig.raster.osm.swing.AddOSMLayerPanel;
import org.gvsig.raster.osm.swing.OSMSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOSMLayerWizard
extends WizardPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final String TAB_NAME = "OSM";
    private static Logger logger = LoggerFactory.getLogger((String)AddOSMLayerWizard.class.getName());
    private AddOSMLayerPanel apiUI = null;
    private WizardListenerSupport listenerSupport = null;

    private void initialize() {
        this.setTabName(PluginServices.getText((Object)this, (String)TAB_NAME));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        boolean showCrsWarning = false;
        IProjection osmProjection = CRSFactory.getCRS((String)"EPSG:3857");
        if (this.getMapCtrl() != null && !this.getMapCtrl().getProjection().equals(osmProjection)) {
            showCrsWarning = true;
        }
        this.apiUI = OSMSwingLocator.getSwingManager().createAddOSMLayerPanel(new File(Launcher.getAppHomeDir()), showCrsWarning);
        if (!new File(this.apiUI.getPropertiesFilePath()).exists()) {
            File pluginFolder = PluginsLocator.getManager().getPluginsFolder();
            File f = new File(pluginFolder.getAbsolutePath() + File.separator + "org.gvsig.raster.osm.app.osmclient" + File.separator + this.apiUI.getPropertiesFileName());
            FileUtils utils = RasterLocator.getManager().getFileUtils();
            try {
                utils.copyFile(f.getAbsolutePath(), Launcher.getAppHomeDir() + File.separator);
                this.apiUI = OSMSwingLocator.getSwingManager().createAddOSMLayerPanel(new File(Launcher.getAppHomeDir()), showCrsWarning);
            }
            catch (FileNotFoundException e) {
                logger.info("File not found copying osmservers.properties", (Throwable)e);
            }
            catch (IOException e) {
                logger.info("Error copying osmservers.properties", (Throwable)e);
            }
        }
        this.apiUI.addMouseListener((MouseListener)this);
        JPanel mainPanel = (JPanel)this.apiUI.getComponent();
        this.add(mainPanel, gridBagConstraints);
    }

    private WizardListenerSupport getWizardListenerSupport() {
        if (this.listenerSupport == null) {
            this.listenerSupport = new WizardListenerSupport();
        }
        return this.listenerSupport;
    }

    public boolean areSettingsValid() {
        return this.apiUI.areSettingsValid();
    }

    public void addWizardListener(WizardListener listener) {
        this.getWizardListenerSupport().addWizardListener(listener);
        this.getWizardListenerSupport().callStateChanged(false);
    }

    public void removeWizardListener(WizardListener listener) {
        this.getWizardListenerSupport().removeWizardListener(listener);
    }

    public void close() {
    }

    public void execute() {
        if (!this.apiUI.areSettingsValid()) {
            this.messageBoxInfo("server_not_selected", PluginServices.getMDIManager().getActiveWindow(), null);
            return;
        }
        try {
            TileDataParameters tileParams = this.createDataParameters();
            MapContext mapContext = this.getMapContext();
            if (mapContext == null) {
                mapContext = this.createViewWindow();
            }
            FLyrOSM layer = this.buildLayer(tileParams);
            this.addLayerToMapContext(mapContext, layer);
        }
        catch (InitializeException e) {
            this.messageBoxInfo("error_creating_parameters", PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            this.messageBoxInfo("error_creating_parameters", PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
        catch (LoadLayerException e) {
            this.messageBoxInfo("error_creating_the_view", PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
    }

    private TileDataParameters createDataParameters() throws InitializeException, ProviderNotRegisteredException {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        OSMDataParameters parameters = (OSMDataParameters)dataman.createStoreParameters(OSMProvider.NAME);
        URL selectedURL = null;
        try {
            selectedURL = this.apiUI.getSelectedURL();
        }
        catch (MalformedURLException e) {
            throw new InitializeException((Throwable)e);
        }
        try {
            parameters.setURI(selectedURL.toURI());
        }
        catch (URISyntaxException e1) {
            logger.warn("Can't convert URI from " + selectedURL.toString(), (Throwable)e1);
            throw new InitializeException((Throwable)e1);
        }
        parameters.setTileSuffix(this.apiUI.getSelectedFormat());
        parameters.setOSMLayerName(this.apiUI.getSelectedName());
        try {
            parameters.setNumberOfLevels(new Integer(this.apiUI.getSelectedLevel()).intValue());
        }
        catch (NumberFormatException e1) {
            // empty catch block
        }
        TileDataParameters tileParams = (TileDataParameters)dataman.createStoreParameters("Tile Store");
        tileParams.setDataParameters((DataParameters)parameters);
        return tileParams;
    }

    private void addLayerToMapContext(MapContext mapContext, FLyrOSM layer) {
        mapContext.beginAtomicEvent();
        layer.setVisible(true);
        mapContext.getLayers().addLayer((FLayer)layer);
        mapContext.callLegendChanged();
        mapContext.endAtomicEvent();
    }

    private FLyrOSM buildLayer(TileDataParameters tileParams) {
        FLyrOSM layer = new FLyrOSM();
        layer.deleteCache(false);
        try {
            layer.setParameters((DataStoreParameters)tileParams);
            layer.setName(this.apiUI.getSelectedName());
        }
        catch (InitializeException e) {
            this.messageBoxInfo("error_initializing_layer", PluginServices.getMDIManager().getActiveWindow(), (Exception)((Object)e));
        }
        return layer;
    }

    public MapContext getMapContext() {
        IWindow window = PluginServices.getMDIManager().getFocusWindow();
        if (window instanceof AbstractViewPanel) {
            return ((AbstractViewPanel)window).getMapControl().getMapContext();
        }
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            return ((AbstractViewPanel)w[i]).getMapControl().getMapContext();
        }
        return null;
    }

    private void messageBoxInfo(String msg, Object parentWindow, Exception exception) {
        LoggerFactory.getLogger(this.getClass()).debug(msg, (Throwable)exception);
        String string = PluginServices.getText((Object)parentWindow, (String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)parentWindow, "<html>" + PluginServices.getText((Object)parentWindow, (String)msg).replaceAll("\n", "<br>") + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 1, null, options, string);
    }

    private MapContext createViewWindow() throws LoadLayerException {
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManagers(ViewManager.TYPENAME);
        ViewDocument view = (ViewDocument)viewManager.createDocument();
        view.setName("OpenStreetMap View");
        projectManager.getCurrentProject().add((Document)view);
        IView viewWindow = (IView)viewManager.getMainWindow((Document)view);
        application.getUIManager().addWindow((IWindow)viewWindow, 10);
        try {
            application.getUIManager().setMaximum((IWindow)viewWindow, true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (viewWindow != null) {
            IProjection proj = CRSFactory.getCRS((String)"EPSG:3857");
            if (proj != null) {
                viewWindow.getMapControl().setProjection(proj);
            }
            return viewWindow.getMapControl().getMapContext();
        }
        return null;
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void initWizard() {
        this.initialize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getWizardListenerSupport().callStateChanged(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

