/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.osm.app.osmclient;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.osm.app.osmclient.AddOSMLayerWizard;
import org.gvsig.raster.osm.app.osmclient.layer.FLyrOSM;
import org.gvsig.raster.osm.io.OSMDataParameters;
import org.gvsig.tools.util.Factory;

public class OSMClientExtension
extends Extension {
    private String fileCheck = System.getProperty("user.home") + File.separator + "gvSIG" + File.separator + "osm_epsg_error";
    private String epsgCode = "3857";

    public void initialize() {
        IconThemeHelper.registerIcon(null, (String)"icon-layer-osm", (Object)((Object)this));
    }

    public void postInitialize() {
        FLyrOSM.registerPersistent();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        mapContextManager.registerLayer((Factory)new OSMLayerFactory());
        AddLayer.addWizard(AddOSMLayerWizard.class);
    }

    public void messageErrorEpsg(String msg, File f) {
        String string1 = Messages.getText((String)"dont_remind_me_anymore");
        String string2 = Messages.getText((String)"ok");
        Object[] options = new Object[]{string1, string2};
        int n = JOptionPane.showOptionDialog(null, "<html>" + Messages.getText((String)msg).replaceAll("\n", "<br>") + "</html>", Messages.getText((String)"confirmacion"), 0, 3, null, options, string1);
        if (n == 0) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private static class OSMLayerFactory
    implements Factory<FLayer> {
        private OSMLayerFactory() {
        }

        public String getName() {
            return FLyrOSM.class.getName();
        }

        public FLayer create(Object ... os) {
            try {
                DataParameters p;
                DataStoreParameters parameters = (DataStoreParameters)os[0];
                if (parameters instanceof OSMDataParameters) {
                    FLyrOSM layer = new FLyrOSM();
                    layer.setParameters(parameters);
                    return layer;
                }
                if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof OSMDataParameters) {
                    FLyrOSM layer = new FLyrOSM();
                    layer.setParameters(parameters);
                    return layer;
                }
            }
            catch (InitializeException ex) {
                logger.warn("Can't initialize OSMLayer", (Throwable)ex);
            }
            return null;
        }
    }
}

