/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.StyleMap;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.fit.cssbox.css.HTMLNorm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMAnalyzer {
    private static Logger log = LoggerFactory.getLogger(DOMAnalyzer.class);
    private static final String DEFAULT_MEDIA = "screen";
    private Document doc;
    private URL baseUrl;
    private MediaSpec media;
    private String encoding;
    private Vector<StyleSheet> styles;
    private Analyzer analyzer;
    private StyleMap stylemap;
    private StyleMap istylemap;

    public DOMAnalyzer(Document doc) {
        this.doc = doc;
        this.media = new MediaSpec(DEFAULT_MEDIA);
        this.baseUrl = null;
        this.encoding = null;
        this.styles = new Vector();
        this.stylemap = null;
        this.istylemap = null;
    }

    public DOMAnalyzer(Document doc, URL baseUrl) {
        this(doc, baseUrl, true);
    }

    public DOMAnalyzer(Document doc, URL baseUrl, boolean detectBase) {
        String docbase;
        this.doc = doc;
        this.encoding = null;
        this.media = new MediaSpec(DEFAULT_MEDIA);
        this.styles = new Vector();
        this.baseUrl = baseUrl;
        if (detectBase && (docbase = this.getDocumentBase()) != null) {
            try {
                this.baseUrl = new URL(baseUrl, docbase);
                log.info("Using specified document base " + this.baseUrl);
            }
            catch (MalformedURLException e) {
                log.warn("Malformed base URL " + docbase);
            }
        }
        this.stylemap = null;
        this.istylemap = null;
    }

    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setDefaultEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMedia() {
        return this.media.getType();
    }

    public void setMedia(String media) {
        this.media = new MediaSpec(media);
    }

    public MediaSpec getMediaSpec() {
        return this.media;
    }

    public void setMediaSpec(MediaSpec media) {
        this.media = media;
    }

    public Element getRoot() {
        return this.doc.getDocumentElement();
    }

    public Element getHead() {
        return (Element)this.doc.getElementsByTagName("head").item(0);
    }

    public Element getBody() {
        return (Element)this.doc.getElementsByTagName("body").item(0);
    }

    public String getDocumentBase() {
        Element head = this.getHead();
        if (head != null) {
            NodeList bases = head.getElementsByTagName("base");
            if (bases != null && bases.getLength() > 0) {
                Element base = (Element)bases.item(0);
                if (base.hasAttribute("href")) {
                    return base.getAttribute("href");
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public String getCharacterEncoding() {
        Element head = this.getHead();
        if (head != null) {
            NodeList metas = head.getElementsByTagName("meta");
            if (metas != null) {
                for (int i = 0; i < metas.getLength(); ++i) {
                    Element meta = (Element)metas.item(i);
                    if (meta.hasAttribute("http-equiv") && meta.getAttribute("http-equiv").equalsIgnoreCase("content-type") && meta.hasAttribute("content")) {
                        String ctype = meta.getAttribute("content").toLowerCase();
                        int cpos = ctype.indexOf("charset=");
                        if (cpos == -1) continue;
                        return ctype.substring(cpos + 8);
                    }
                    if (!meta.hasAttribute("charset")) continue;
                    return meta.getAttribute("charset");
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void printTagTree(PrintStream out) {
        this.recursivePrintTags(this.doc, 0, out);
    }

    public void stylesToDom() {
        this.recursiveStylesToDom(this.getBody());
    }

    public void stylesToDomInherited() {
        this.recursiveStylesToDomInherited(this.getBody());
    }

    public void attributesToStyles() {
        HTMLNorm.normalizeHTMLTree(this.doc);
        HTMLNorm.attributesToStyles(this.getBody(), "");
    }

    public void localizeStyles() {
        Vector<Element> elems = new Vector<Element>();
        this.recursiveFindStyleElements(this.getRoot(), elems);
        for (Element e : elems) {
            e.getParentNode().removeChild(e);
        }
        Element style = this.doc.createElement("style");
        style.setAttribute("type", "text/css");
        this.getHead().appendChild(style);
        StringBuilder sb = new StringBuilder();
        for (StyleSheet sheet : this.styles) {
            for (Object o : sheet.asList()) {
                Selector.SelectorPart start;
                if (!(o instanceof RuleSet) || (start = (Selector.SelectorPart)((Selector)((CombinedSelector)((RuleSet)o).getSelectors().get(0)).get(0)).get(0)) instanceof Selector.ElementDOM) continue;
                sb.append(o.toString());
            }
        }
        Text styletext = this.doc.createTextNode(sb.toString());
        style.appendChild(styletext);
    }

    public void getStyleSheets(String media) {
        this.media = new MediaSpec(media);
        StyleSheet newsheet = CSSFactory.getUsedStyles((Document)this.doc, (String)this.encoding, (URL)this.baseUrl, (MediaSpec)this.media);
        this.styles.add(newsheet);
    }

    public void getStyleSheets(MediaSpec media) {
        this.media = media;
        StyleSheet newsheet = CSSFactory.getUsedStyles((Document)this.doc, (String)this.encoding, (URL)this.baseUrl, (MediaSpec)this.media);
        this.styles.add(newsheet);
    }

    public void getStyleSheets() {
        this.getStyleSheets(this.media);
    }

    public void loadStyleSheet(URL base, String href, String encoding) {
        this.loadStyleSheet(base, href, encoding, Origin.AUTHOR);
    }

    public void loadStyleSheet(URL base, String href, String encoding, Origin origin) {
        try {
            StyleSheet newsheet = CSSFactory.parse((URL)new URL(base, href), (String)encoding);
            newsheet.setOrigin(this.translateOrigin(origin));
            this.styles.add(newsheet);
        }
        catch (IOException e) {
            log.error("I/O Error: " + e.getMessage());
        }
        catch (CSSException e) {
            log.error("CSS Error: " + e.getMessage());
        }
    }

    public void addStyleSheet(URL base, String cssdata) {
        this.addStyleSheet(base, cssdata, Origin.AUTHOR);
    }

    public void addStyleSheet(URL base, String cssdata, Origin origin) {
        try {
            StyleSheet newsheet = CSSFactory.parse((String)cssdata);
            newsheet.setOrigin(this.translateOrigin(origin));
            this.styles.add(newsheet);
        }
        catch (IOException e) {
            log.error("I/O Error: " + e.getMessage());
        }
        catch (CSSException e) {
            log.error("DOMAnalyzer: CSS Error: " + e.getMessage());
        }
    }

    public void recomputeStyles() {
        this.analyzer = null;
        this.stylemap = null;
        this.istylemap = null;
    }

    public NodeData getElementStyle(Element el) {
        if (this.analyzer == null) {
            this.analyzer = new Analyzer(this.styles);
        }
        if (this.stylemap == null) {
            this.stylemap = this.analyzer.evaluateDOM(this.doc, this.media, false);
        }
        return (NodeData)this.stylemap.get((Object)el);
    }

    private void checkStylesInherited() {
        if (this.analyzer == null) {
            this.analyzer = new Analyzer(this.styles);
        }
        if (this.istylemap == null) {
            this.istylemap = this.analyzer.evaluateDOM(this.doc, this.media, true);
        }
    }

    public NodeData getElementStyleInherited(Element el) {
        this.checkStylesInherited();
        return (NodeData)this.istylemap.get((Object)el);
    }

    public NodeData getElementStyleInherited(Element el, Selector.PseudoDeclaration pseudo) {
        this.checkStylesInherited();
        return (NodeData)this.istylemap.get((Object)el, (Object)pseudo);
    }

    public boolean hasPseudoDef(Element el, Selector.PseudoDeclaration pseudo) {
        this.checkStylesInherited();
        return this.istylemap.hasPseudo((Object)el, (Object)pseudo);
    }

    public void useStyle(Element el, Selector.PseudoDeclaration pseudo, NodeData style) {
        this.checkStylesInherited();
        this.istylemap.put((Object)el, (Object)pseudo, (Object)style);
    }

    private void recursiveStylesToDom(Node n) {
        Element el;
        NodeData decl;
        if (n.getNodeType() == 1 && (decl = this.getElementStyle(el = (Element)n)) != null) {
            String decls = decl.toString().replace("\n", "");
            el.setAttribute("style", this.quote(decls));
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveStylesToDom(child.item(i));
        }
    }

    private void recursiveStylesToDomInherited(Node n) {
        Element el;
        NodeData decl;
        if (n.getNodeType() == 1 && (decl = this.getElementStyleInherited(el = (Element)n)) != null) {
            String decls = decl.toString().replace("\n", "");
            el.setAttribute("style", this.quote(decls));
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveStylesToDomInherited(child.item(i));
        }
    }

    private void recursiveFindStyleElements(Element e, Vector<Element> elems) {
        if ("style".equalsIgnoreCase(e.getNodeName()) || "link".equalsIgnoreCase(e.getNodeName()) && "stylesheet".equalsIgnoreCase(e.getAttribute("rel"))) {
            elems.add(e);
        } else {
            NodeList list = e.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                this.recursiveFindStyleElements((Element)list.item(i), elems);
            }
        }
    }

    private String quote(String s) {
        return s.replace('\"', '\'');
    }

    private void recursivePrintTags(Node n, int level, PrintStream p) {
        String mat = "";
        if (n.getNodeType() == 1) {
            NodeData decl = this.getElementStyle((Element)n);
            if (decl != null) {
                mat = "style:\"" + decl.toString() + "\"";
            }
        } else if (n.getNodeType() == 3) {
            mat = n.getNodeValue();
        }
        String ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = ind + ' ';
        }
        p.println(ind + n.getNodeName() + " " + mat);
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursivePrintTags(child.item(i), level + 1, p);
        }
    }

    private StyleSheet.Origin translateOrigin(Origin origin) {
        if (origin == Origin.AUTHOR) {
            return StyleSheet.Origin.AUTHOR;
        }
        if (origin == Origin.AGENT) {
            return StyleSheet.Origin.AGENT;
        }
        return StyleSheet.Origin.USER;
    }

    public static enum Origin {
        AUTHOR,
        AGENT,
        USER;

    }
}

