/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.css.NormalOutput;
import org.fit.cssbox.css.Output;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.w3c.dom.Document;

public class ComputeStyles {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ComputeStyles <url> <output_file>");
            System.exit(0);
        }
        try {
            DefaultDocumentSource docSource = new DefaultDocumentSource(args[0]);
            DefaultDOMSource parser = new DefaultDOMSource(docSource);
            Document doc = ((DOMSource)parser).parse();
            DOMAnalyzer da = new DOMAnalyzer(doc, ((DocumentSource)docSource).getURL());
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            System.err.println("Computing style...");
            da.stylesToDomInherited();
            FileOutputStream os = new FileOutputStream(args[1]);
            NormalOutput out = new NormalOutput(doc);
            ((Output)out).dumpTo(os);
            ((OutputStream)os).close();
            ((DocumentSource)docSource).close();
            System.err.println("Done.");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

