/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ContentImage;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Viewport;

public class BackgroundImage
extends ContentImage {
    private CSSProperty.BackgroundPosition position;
    private CSSProperty.BackgroundRepeat repeat;
    private CSSProperty.BackgroundAttachment attachment;
    private TermList positionValues;
    private int imgx;
    private int imgy;
    private boolean repeatx;
    private boolean repeaty;

    public BackgroundImage(ElementBox owner, URL url, CSSProperty.BackgroundPosition position, TermList positionValues, CSSProperty.BackgroundRepeat repeat, CSSProperty.BackgroundAttachment attachment) {
        super(owner);
        this.loadImages = owner.getViewport().getConfig().getLoadBackgroundImages();
        this.url = url;
        this.position = position;
        this.positionValues = positionValues;
        this.repeat = repeat;
        this.attachment = attachment;
        if (this.loadImages) {
            this.image = this.loadImage(this.caching);
        }
        this.repeatx = repeat == CSSProperty.BackgroundRepeat.REPEAT || repeat == CSSProperty.BackgroundRepeat.REPEAT_X;
        this.repeaty = repeat == CSSProperty.BackgroundRepeat.REPEAT || repeat == CSSProperty.BackgroundRepeat.REPEAT_Y;
    }

    public CSSProperty.BackgroundPosition getPosition() {
        return this.position;
    }

    public CSSProperty.BackgroundRepeat getRepeat() {
        return this.repeat;
    }

    public CSSProperty.BackgroundAttachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void draw(Graphics2D g, int width, int height) {
        Rectangle bounds = this.getOwner().getAbsoluteBackgroundBounds();
        this.computeCoordinates(bounds);
        g.drawImage(this.image, bounds.x + this.imgx, bounds.y + this.imgy, this.observer);
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.image == null || this.abort) {
            return null;
        }
        this.image = this.loadImage(this.caching);
        if (this.container == null) {
            this.waitForLoad();
        }
        Rectangle bounds = this.getOwner().getAbsoluteBackgroundBounds();
        if (this.getOwner() instanceof Viewport) {
            bounds = this.getOwner().getClippedBounds();
        }
        if (bounds.width > 0 && bounds.height > 0) {
            this.computeCoordinates(bounds);
            BufferedImage img = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D g = img.createGraphics();
            if (this.repeatx && this.repeaty) {
                this.drawRepeatBoth(g, this.imgx, this.imgy, bounds.width, bounds.height);
            } else if (this.repeatx) {
                this.drawRepeatX(g, this.imgx, this.imgy, bounds.width);
            } else if (this.repeaty) {
                this.drawRepeatY(g, this.imgx, this.imgy, bounds.height);
            } else {
                g.drawImage(this.image, this.imgx, this.imgy, this.observer);
            }
            g.dispose();
            return img;
        }
        return null;
    }

    private void drawRepeatX(Graphics2D g, int sx, int sy, int limit) {
        int x;
        int width = this.getIntrinsicWidth();
        if (width == 0) {
            width = 1;
        }
        for (x = sx; x < limit; x += width) {
            g.drawImage(this.image, x, sy, this.observer);
        }
        x = sx - width;
        while (x + width - 1 >= 0) {
            g.drawImage(this.image, x, sy, this.observer);
            x -= width;
        }
    }

    private void drawRepeatY(Graphics2D g, int sx, int sy, int limit) {
        int y;
        int height = this.getIntrinsicHeight();
        if (height == 0) {
            height = 1;
        }
        for (y = sy; y < limit; y += height) {
            g.drawImage(this.image, sx, y, this.observer);
        }
        y = sy - height;
        while (y + height - 1 >= 0) {
            g.drawImage(this.image, sx, y, this.observer);
            y -= height;
        }
    }

    private void drawRepeatBoth(Graphics2D g, int sx, int sy, int limitx, int limity) {
        int y;
        int height = this.getIntrinsicHeight();
        if (height == 0) {
            height = 1;
        }
        for (y = sy; y < limity; y += height) {
            this.drawRepeatX(g, sx, y, limitx);
        }
        y = sy - height;
        while (y + height - 1 >= 0) {
            this.drawRepeatX(g, sx, y, limitx);
            y -= height;
        }
    }

    public boolean isRepeatX() {
        return this.repeatx;
    }

    public boolean isRepeatY() {
        return this.repeaty;
    }

    public int getImgX() {
        return this.imgx;
    }

    public int getImgY() {
        return this.imgy;
    }

    public void computeCoordinates() {
        this.computeCoordinates(this.getOwner().getAbsoluteBackgroundBounds());
    }

    protected void computeCoordinates(Rectangle bounds) {
        CSSDecoder dec = new CSSDecoder(this.getOwner().getVisualContext());
        this.imgx = this.position == CSSProperty.BackgroundPosition.LEFT ? 0 : (this.position == CSSProperty.BackgroundPosition.RIGHT ? bounds.width - this.getIntrinsicWidth() : (this.position == CSSProperty.BackgroundPosition.CENTER ? (bounds.width - this.getIntrinsicWidth()) / 2 : (this.position == CSSProperty.BackgroundPosition.list_values ? dec.getLength((TermLengthOrPercent)this.positionValues.get(0), false, 0, 0, bounds.width - this.getIntrinsicWidth()) : 0)));
        if (this.position == CSSProperty.BackgroundPosition.TOP) {
            this.imgy = 0;
        } else if (this.position == CSSProperty.BackgroundPosition.BOTTOM) {
            this.imgy = bounds.height - this.getIntrinsicHeight();
        } else if (this.position == CSSProperty.BackgroundPosition.CENTER) {
            this.imgy = (bounds.height - this.getIntrinsicHeight()) / 2;
        } else if (this.position == CSSProperty.BackgroundPosition.list_values) {
            int i = this.positionValues.size() > 1 ? 1 : 0;
            this.imgy = dec.getLength((TermLengthOrPercent)this.positionValues.get(i), false, 0, 0, bounds.height - this.getIntrinsicHeight());
        } else {
            this.imgy = 0;
        }
    }
}

