/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentImage
extends ReplacedContent
implements ImageObserver {
    private static Logger log = LoggerFactory.getLogger(ContentImage.class);
    protected final int DEFAULT_IMAGE_WIDTH = 0;
    protected final int DEFAULT_IMAGE_HEIGHT = 0;
    protected int loadTimeout;
    protected boolean loadImages = true;
    protected boolean caching = true;
    protected URL url;
    protected Image image;
    protected int width = -1;
    protected int height = -1;
    protected ImageObserver observer = this;
    protected Container container = null;
    protected Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected boolean abort = false;
    protected boolean complete = false;

    public ContentImage(ElementBox owner) {
        super(owner);
        this.loadTimeout = owner.getViewport().getConfig().getImageLoadTimeout();
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    protected void repaint(int t) {
        if (this.container != null) {
            Rectangle bounds = this.owner.getAbsoluteBounds();
            this.container.repaint(t, bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    protected Image loadImage(boolean cache) {
        if (this.url != null) {
            Image img = cache ? this.toolkit.getImage(this.url) : this.toolkit.createImage(this.url);
            this.complete = this.toolkit.prepareImage(img, -1, -1, this.observer);
            return img;
        }
        return null;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean val) {
        this.caching = val;
    }

    public URL getUrl() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null || this.abort) {
            return null;
        }
        if (this.container == null) {
            this.waitForLoad();
        }
        BufferedImage img = new BufferedImage(this.getIntrinsicWidth(), this.getIntrinsicHeight(), 1);
        Graphics2D g = img.createGraphics();
        g.drawImage(this.image, null, null);
        g.dispose();
        return img;
    }

    public void setImageObserver(ImageObserver observer) {
        this.observer = observer;
    }

    public ImageObserver getImageObserver() {
        return this.observer;
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.height > -1) {
            return this.height;
        }
        if (this.loadImages) {
            if (this.image == null) {
                this.image = this.loadImage(this.caching);
            }
            this.height = this.obtainImageHeight();
            return this.height;
        }
        return 0;
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.width > -1) {
            return this.width;
        }
        if (this.loadImages) {
            if (this.image == null) {
                this.image = this.loadImage(this.caching);
            }
            this.width = this.obtainImageWidth();
            return this.width;
        }
        return 0;
    }

    private int obtainImageWidth() {
        int width = -1;
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && (width = this.image.getWidth(this.observer)) == -1) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("Image loading aborted for timeout: " + this.url + " " + loadtime);
                }
                Thread.sleep(25L);
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("Image loading aborted: " + e.getMessage());
            }
        }
        if (width == -1) {
            width = 0;
        }
        return width;
    }

    private int obtainImageHeight() {
        int height = -1;
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && (height = this.image.getHeight(this.observer)) == -1) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("Image loading aborted for timeout: " + this.url);
                } else {
                    Thread.sleep(25L);
                }
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("Image loading aborted: " + e.getMessage());
            }
        }
        if (height == -1) {
            height = 0;
        }
        return height;
    }

    @Override
    public float getIntrinsicRatio() {
        return (float)this.getIntrinsicWidth() / (float)this.getIntrinsicHeight();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    public void reset() {
        this.abort = false;
        this.complete = false;
        this.width = -1;
        this.height = -1;
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
    }

    public synchronized void abort() {
        this.abort = true;
        this.image = null;
    }

    public boolean waitForLoad() {
        this.abort = false;
        int loadtime = 0;
        while (!this.abort && this.image != null && !this.complete) {
            try {
                if (loadtime > this.loadTimeout) {
                    this.image = null;
                    this.abort = true;
                    log.warn("Image loading aborted for timeout: " + this.url + " " + loadtime);
                }
                Thread.sleep(25L);
                loadtime += 25;
            }
            catch (Exception e) {
                this.image = null;
                this.abort = true;
                log.warn("Image loading aborted: " + e.getMessage());
            }
        }
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
        if ((flags & 0xC0) != 0) {
            ContentImage contentImage = this;
            synchronized (contentImage) {
                if (this.image == img) {
                    this.abort();
                }
            }
            this.repaint(0);
            return false;
        }
        if ((flags & 0x30) != 0) {
            this.repaint(0);
        }
        if ((flags & 0x20) != 0) {
            this.complete = true;
        }
        return (flags & 0x20) == 0;
    }
}

