/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.simplify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SimplifyEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selection;
    private final EditingServiceParameter tolerance;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;

    public SimplifyEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selection = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.tolerance = new DefaultEditingServiceParameter("tolerance", "tolerance", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.tolerance) == null) {
            return this.tolerance;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.tolerance);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        Double toleranceValue;
        if (parameter == this.selection) {
            FeatureSelection featureSelection = (FeatureSelection)value;
            if (featureSelection.getSelectedCount() > 0L) {
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        GeometryType geometryType = geometry.getGeometryType();
                        if (!(geometryType.isTypeOf(9) || geometryType.isTypeOf(3) || geometryType.isTypeOf(2) || geometryType.isTypeOf(8))) {
                            throw new InvalidEntryException(null);
                        }
                    });
                    this.values.put(this.selection, value);
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        } else if (parameter == this.tolerance && value instanceof Double && (toleranceValue = (Double)value) >= 0.0) {
            this.values.put(this.tolerance, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            FeatureSelection featureSelection = (FeatureSelection)this.values.get(this.selection);
            ToolsLocator.getDisposableManager().bind((Disposable)featureSelection);
            Double toleranceValue = (Double)this.values.get(this.tolerance);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                featureSelection.accept(obj -> {
                    Feature feature = (Feature)obj;
                    Geometry geometry = feature.getDefaultGeometry();
                    GeometryType geoType = geometry.getGeometryType();
                    if (geoType.isTypeOf(2) || geoType.isTypeOf(3)) {
                        if (geoType.isTypeOf(2)) {
                            Curve curveToSimplify = (Curve)geometry;
                            curveToSimplify = this.simplifyLine(curveToSimplify, toleranceValue);
                            geometry = curveToSimplify;
                        } else {
                            Surface surfaceToSimplify = (Surface)geometry;
                            surfaceToSimplify = this.simplifySurface(surfaceToSimplify, toleranceValue);
                            geometry = surfaceToSimplify;
                        }
                        EditableFeature eFeature = feature.getEditable();
                        eFeature.setDefaultGeometry(geometry);
                        editingProviderServices.updateFeatureInFeatureStore((Feature)eFeature, this.featureStore);
                    } else if (geoType.isTypeOf(8) || geoType.isTypeOf(9)) {
                        if (geoType.isTypeOf(8)) {
                            MultiCurve multiCurveToSimplify = (MultiCurve)geometry;
                            MultiCurve multiCurveSimplified = GeometryLocator.getGeometryManager().createMultiCurve(subtype);
                            for (int i = 0; i < multiCurveToSimplify.getPrimitivesNumber(); ++i) {
                                Curve curveToSimplify = (Curve)multiCurveToSimplify.getPrimitiveAt(i);
                                curveToSimplify = this.simplifyLine(curveToSimplify, toleranceValue);
                                multiCurveSimplified.addCurve(curveToSimplify);
                                geometry = multiCurveSimplified;
                            }
                        } else {
                            MultiSurface multiSurfaceToSimplify = (MultiSurface)geometry;
                            MultiSurface multiSurfaceSimplified = GeometryLocator.getGeometryManager().createMultiSurface(subtype);
                            for (int i = 0; i < multiSurfaceToSimplify.getPrimitivesNumber(); ++i) {
                                Surface surfaceToSimplify = (Surface)multiSurfaceToSimplify.getPrimitiveAt(i);
                                surfaceToSimplify = this.simplifySurface(surfaceToSimplify, toleranceValue);
                                multiSurfaceSimplified.addSurface(surfaceToSimplify);
                                geometry = multiSurfaceSimplified;
                            }
                        }
                        EditableFeature eFeature = feature.getEditable();
                        eFeature.setDefaultGeometry(geometry);
                        editingProviderServices.updateFeatureInFeatureStore((Feature)eFeature, this.featureStore);
                    }
                });
                this.featureStore.getFeatureSelection().deselectAll();
                featureSelection.dispose();
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private Surface simplifySurface(Surface surfaceToSimplify, Double toleranceValue) throws GeometryException, DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        Line lineToSimplify = GeometryLocator.getGeometryManager().createLine(subtype);
        for (int i = 0; i < surfaceToSimplify.getNumVertices(); ++i) {
            lineToSimplify.addVertex(surfaceToSimplify.getVertex(i));
        }
        Line simplifiedLine = this.simplifyLine((Curve)lineToSimplify, toleranceValue);
        Polygon simplifiedPolygon = GeometryLocator.getGeometryManager().createPolygon(subtype);
        for (int i = 0; i < simplifiedLine.getNumVertices(); ++i) {
            simplifiedPolygon.addVertex(simplifiedLine.getVertex(i));
        }
        simplifiedPolygon.addVertex(simplifiedLine.getVertex(0));
        return simplifiedPolygon;
    }

    private Line simplifyLine(Curve curveToSimplify, Double toleranceValue) throws DataException, CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        Line simplifiedLine = GeometryLocator.getGeometryManager().createLine(subtype);
        simplifiedLine.addVertex(curveToSimplify.getVertex(0));
        for (int i = 0; i < curveToSimplify.getNumVertices() - 2; ++i) {
            Point vertex = curveToSimplify.getVertex(i);
            Point nextVertex = curveToSimplify.getVertex(i + 1);
            Point nextNextVertex = curveToSimplify.getVertex(i + 2);
            Line tmpLine = editingProviderServices.createLine(vertex, nextNextVertex, subtype);
            if (tmpLine.distance((Geometry)nextVertex) > toleranceValue) {
                simplifiedLine.addVertex(nextVertex);
                continue;
            }
            ++i;
        }
        simplifiedLine.addVertex(curveToSimplify.getVertex(curveToSimplify.getNumVertices() - 1));
        return simplifiedLine;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-simplify";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

