/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public final class VFSUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private static FileSystemManager fileSystemManager;
    private static FileSystemOptions opts;
    private static final String OS_NAME;
    private static final String PROTO_PREFIX = "://";
    private static final String FILE_PREFIX;
    private static final int FILE_PREFIX_LEN;
    private static ReadWriteLock aLock;
    private static final String kiloByteString;
    private static final String megaByteString;
    private static final String gigaByteString;

    private VFSUtils() {
        throw new AssertionError((Object)"Trying to create a VFSUtils object");
    }

    public static void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        aLock.writeLock().lock();
        try {
            opts = fileSystemOptions;
        }
        finally {
            aLock.writeLock().unlock();
        }
    }

    public static FileSystemManager getFileSystemManager() {
        aLock.readLock().lock();
        try {
            if (fileSystemManager == null) {
                try {
                    StandardFileSystemManager fm = new StandardFileSystemManager();
                    fm.setCacheStrategy(CacheStrategy.MANUAL);
                    fm.init();
                    fileSystemManager = fm;
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
            FileSystemManager fileSystemManager = VFSUtils.fileSystemManager;
            return fileSystemManager;
        }
        finally {
            aLock.readLock().unlock();
        }
    }

    public static void setFileSystemManager(FileSystemManager aFileSystemManager) {
        aLock.writeLock().lock();
        try {
            fileSystemManager = aFileSystemManager;
        }
        finally {
            aLock.writeLock().unlock();
        }
    }

    public static String byteCountToDisplaySize(long size) {
        if (size / 0x40000000L > 0L) {
            return MessageFormat.format(gigaByteString, String.valueOf(size / 0x40000000L));
        }
        if (size / 0x100000L > 0L) {
            return MessageFormat.format(megaByteString, String.valueOf(size / 0x100000L));
        }
        if (size / 1024L > 0L) {
            return MessageFormat.format(kiloByteString, String.valueOf(size / 1024L));
        }
        return String.valueOf(size);
    }

    public static InputStream getInputStream(FileObject fileObject) throws FileSystemException {
        return new BufferedInputStream(fileObject.getContent().getInputStream());
    }

    public static OutputStream getOutputStream(FileObject fileObject) throws FileSystemException {
        return new BufferedOutputStream(fileObject.getContent().getOutputStream());
    }

    public static boolean canWrite(FileObject fileObject) {
        try {
            return fileObject.isWriteable();
        }
        catch (FileSystemException ex) {
            return false;
        }
    }

    public static FileObject createFileObject(String filePath) {
        try {
            return VFSUtils.getFileSystemManager().resolveFile(filePath, opts);
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static final String getFriendlyName(String fileName) {
        return VFSUtils.getFriendlyName(fileName, true);
    }

    public static final String getFriendlyName(String fileName, boolean excludeLocalFilePrefix) {
        StringBuilder filePath = new StringBuilder();
        int pos = fileName.lastIndexOf(64);
        if (pos == -1) {
            filePath.append(fileName);
        } else {
            int pos2 = fileName.indexOf(PROTO_PREFIX);
            if (pos2 == -1) {
                filePath.append(fileName);
            } else {
                String protocol = fileName.substring(0, pos2);
                filePath.append(protocol).append(PROTO_PREFIX).append(fileName.substring(pos + 1, fileName.length()));
            }
        }
        String returnedString = filePath.toString();
        if (excludeLocalFilePrefix && returnedString.startsWith(FILE_PREFIX)) {
            return filePath.substring(FILE_PREFIX_LEN);
        }
        return returnedString;
    }

    public static FileObject createFileSystemRoot(FileObject fileObject) {
        try {
            return fileObject.getFileSystem().getRoot();
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static FileObject[] getFiles(FileObject folder) {
        try {
            return folder.getChildren();
        }
        catch (FileSystemException ex) {
            return new FileObject[0];
        }
    }

    public static FileObject[] getFiles(FileObject folder, boolean useFileHiding) {
        FileObject[] fileList = VFSUtils.getFiles(folder);
        if (useFileHiding) {
            return fileList;
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>(fileList.length);
        for (FileObject file : fileList) {
            if (VFSUtils.isHiddenFile(file)) continue;
            files.add(file);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static FileObject getRootFileSystem(FileObject fileObject) {
        try {
            if (fileObject == null || !fileObject.exists()) {
                return null;
            }
            return fileObject.getFileSystem().getRoot();
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static boolean isHiddenFile(FileObject fileObject) {
        try {
            return fileObject.getName().getBaseName().charAt(0) == '.';
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isRoot(FileObject fileObject) {
        try {
            return fileObject.getParent() == null;
        }
        catch (FileSystemException ex) {
            return false;
        }
    }

    public static FileObject toFileObject(File file) {
        try {
            return VFSUtils.getFileSystemManager().toFileObject(file);
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static FileObject getParentDirectory(FileObject fileObject) {
        if (fileObject == null) {
            return fileObject;
        }
        try {
            return fileObject.getParent();
        }
        catch (FileSystemException ex) {
            return fileObject;
        }
    }

    public static FileObject resolveFileObject(String filePath) {
        try {
            if (filePath.startsWith("sftp://")) {
                SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
            }
            return VFSUtils.getFileSystemManager().resolveFile(filePath, opts);
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static FileObject resolveFileObject(String filePath, FileSystemOptions options) {
        try {
            return VFSUtils.getFileSystemManager().resolveFile(filePath, options);
        }
        catch (FileSystemException fse) {
            return null;
        }
    }

    public static FileObject resolveFileObject(FileObject folder, String filename) {
        try {
            return folder.resolveFile(filename);
        }
        catch (FileSystemException ex) {
            return null;
        }
    }

    public static boolean exists(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        try {
            return fileObject.exists();
        }
        catch (FileSystemException ex) {
            return false;
        }
    }

    public static boolean isDirectory(FileObject fileObject) {
        try {
            return fileObject.getType().equals((Object)FileType.FOLDER);
        }
        catch (FileSystemException ex) {
            return false;
        }
    }

    public static boolean isFileSystemRoot(FileObject folder) {
        return VFSUtils.isRoot(folder);
    }

    public static boolean isParent(FileObject folder, FileObject file) {
        try {
            FileObject parent = file.getParent();
            if (parent == null) {
                return false;
            }
            return parent.equals(folder);
        }
        catch (FileSystemException ex) {
            return false;
        }
    }

    static {
        opts = new FileSystemOptions();
        OS_NAME = System.getProperty("os.name").toLowerCase();
        FILE_PREFIX = OS_NAME.startsWith("windows") ? "file:///" : "file://";
        FILE_PREFIX_LEN = FILE_PREFIX.length();
        aLock = new ReentrantReadWriteLock(true);
        kiloByteString = VFSResources.getMessage("VFSJFileChooser.fileSizeKiloBytes");
        megaByteString = VFSResources.getMessage("VFSJFileChooser.fileSizeMegaBytes");
        gigaByteString = VFSResources.getMessage("VFSJFileChooser.fileSizeGigaBytes");
    }
}

