/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.LoadException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.dgn.DGNOpenStoreParameters;
import org.gvsig.fmap.dal.store.dgn.LegendBuilder;
import org.gvsig.fmap.dal.store.dgn.PostProcessFeatures;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemArc;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemComplexHeader;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemCore;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemMultiPoint;
import org.gvsig.fmap.dal.store.dgn.lib.DGNElemText;
import org.gvsig.fmap.dal.store.dgn.lib.DGNLink;
import org.gvsig.fmap.dal.store.dgn.lib.DGNPoint;
import org.gvsig.fmap.dal.store.dgn.lib.DGNReader;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.IGeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DGNStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DGNStoreProvider.class);
    public static final String NAME = "DGN";
    public static final String DESCRIPTION = "DGN file";
    public static final String METADATA_DEFINITION_NAME = "DGN";
    public static final String METADATA_DEFINITION_DESCRIPTION = "DGN File Store";
    public static final int LOAD_MODE_PLAIN = 0;
    public static final int LOAD_MODE_GROUP1 = 1;
    public static final int CROP_OPERATION_NONE = 0;
    public static final int CROP_OPERATION_CONTAINS = 1;
    public static final int CROP_OPERATION_COVERS = 2;
    public static final int CROP_OPERATION_COVEREDBY = 3;
    public static final int CROP_OPERATION_CROSSES = 4;
    public static final int CROP_OPERATION_DISJOINT = 5;
    public static final int CROP_OPERATION_INTERSECT = 6;
    public static final int CROP_OPERATION_OVERLAPS = 7;
    public static final int CROP_OPERATION_TOUCHES = 8;
    public static final int CROP_OPERATION_WITHIN = 9;
    public static final int GROUP_GEOMETRIES_NONE = 0;
    public static final int GROUP_GEOMETRIES_CONVEXHULL = 1;
    public static final int GROUP_GEOMETRIES_UNION = 2;
    public static final int GROUP_GEOMETRIES_INTERSECTION = 3;
    public static final int GROUP_GEOMETRIES_TOPOINTS = 4;
    public static final int GROUP_GEOMETRIES_TOLINES = 5;
    public static final int GROUP_GEOMETRIES_TOPOLYGONS = 6;
    public static final int GROUP_GEOMETRIES_TOPOLYGONS_FIX = 7;
    public static final String NAME_FIELD_ID = "ID";
    public static final String NAME_FIELD_GEOMETRY = "Geometry";
    public static final String NAME_FIELD_TYPE = "Type";
    public static final String NAME_FIELD_STYPE = "SType";
    public static final String NAME_FIELD_ENTITY = "Entity";
    public static final String NAME_FIELD_LEVEL = "Layer";
    public static final String NAME_FIELD_COLOR = "Color";
    public static final String NAME_FIELD_FILLCOLOR = "FillColor";
    public static final String NAME_FIELD_ELEVATION = "Elevation";
    public static final String NAME_FIELD_WEIGHT = "Weight";
    public static final String NAME_FIELD_TEXT = "Text";
    public static final String NAME_FIELD_HEIGHTTEXT = "HeightText";
    public static final String NAME_FIELD_HEIGHTTEXTRAW = "HeightTextRaw";
    public static final String NAME_FIELD_ROTATIONTEXT = "Rotation";
    public static final String NAME_FIELD_STYLE = "Style";
    public static final String NAME_FIELD_GROUP = "Group";
    public static final String NAME_FIELD_ISSHAPE = "IsShape";
    public static final String NAME_FIELD_ISCOMPLEXSHAPEHEADER = "IsComplexShapeHeader";
    public static final String NAME_FIELD_ISHOLE = "IsHole";
    public static final String NAME_FIELD_ISCOMPLEX = "IsComplex";
    public static final String NAME_FIELD_PARENTID = "ParentId";
    public static final String NAME_FIELD_SCALE = "Scale";
    public static final String NAME_FIELD_LINKS_COUNT = "LinksCount";
    public static final String NAME_FIELD_LINK_INDEX = "LinkIndex";
    public static final String NAME_FIELD_LINK_TYPE = "LinkType";
    public static final String NAME_FIELD_LINK_ENTITY = "LinkEntity";
    public static final String NAME_FIELD_LINK_MS = "LinkMS";
    public static final String NAME_FIELD_LINK_LENGTH = "LinkLength";
    public static final String NAME_FIELD_LINK_DATA = "LinkData";
    public static final String NAME_FIELD_DATA = "Data";
    private int ID_FIELD_ID;
    private int ID_FIELD_TYPE;
    private int ID_FIELD_STYPE;
    private int ID_FIELD_ENTITY;
    private int ID_FIELD_LEVEL;
    private int ID_FIELD_COLOR;
    private int ID_FIELD_FILLCOLOR;
    private int ID_FIELD_ELEVATION;
    private int ID_FIELD_WEIGHT;
    private int ID_FIELD_TEXT;
    private int ID_FIELD_HEIGHTTEXT;
    private int ID_FIELD_HEIGHTTEXTRAW;
    private int ID_FIELD_ROTATIONTEXT;
    private int ID_FIELD_STYLE;
    private int ID_FIELD_GROUP;
    private int ID_FIELD_LAYER;
    private int ID_FIELD_ISCOMPLEXSHAPEHEADER;
    private int ID_FIELD_ISSHAPE;
    private int ID_FIELD_ISHOLE;
    private int ID_FIELD_ISCOMPLEX;
    private int ID_FIELD_PARENT;
    private int ID_FIELD_SCALE;
    private int ID_FIELD_LINKS_COUNT;
    private int ID_FIELD_LINK_INDEX;
    private int ID_FIELD_LINK_TYPE;
    private int ID_FIELD_LINK_ENTITY;
    private int ID_FIELD_LINK_MS;
    private int ID_FIELD_LINK_LENGTH;
    private int ID_FIELD_LINK_DATA;
    private int ID_FIELD_DATA;
    private int ID_FIELD_GEOMETRY;
    private int MAX_FIELD_ID;
    private IProjection projection;
    private ResourceProvider resource;
    private LegendBuilder legendBuilder;
    private long counterNewsOIDs = 0L;
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private int groupByFieldIndex = -2;
    private Map<Object, FeatureProvider> groupedFeatures = null;
    DGNData dgndata = null;

    public DGNStoreProvider(DGNOpenStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"DGN"));
        File file = this.getDGNParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.projection = this.getDGNParameters().getCRS();
        try {
            this.legendBuilder = (LegendBuilder)this.invokeDynMethod("getLegendBuilder", null);
        }
        catch (DynMethodException e) {
            this.legendBuilder = null;
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
        this.initializeFeatureTypes();
    }

    private DGNOpenStoreParameters getDGNParameters() {
        return (DGNOpenStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "DGN";
    }

    public boolean allowWrite() {
        return false;
    }

    public Object getLegend() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLegend();
    }

    public Object getLabeling() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLabeling();
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    TimeCounter tc = new TimeCounter();
                    tc.start();
                    FeatureStoreProviderServices storeProviderServices = DGNStoreProvider.this.getStoreServices();
                    if (DGNStoreProvider.this.dgndata == null && !DGNStoreProvider.this.getDGNParameters().useReload()) {
                        if (DGNStoreProvider.this.resource.getData() != null) {
                            DGNStoreProvider.this.dgndata = (DGNData)((Map)DGNStoreProvider.this.resource.getData()).get(DGNStoreProvider.this.projection.getAbrev());
                        } else {
                            DGNStoreProvider.this.resource.setData(new HashMap());
                        }
                    }
                    tc.restart("Retrive data from resource (data=" + DGNStoreProvider.this.dgndata + ")");
                    if (DGNStoreProvider.this.dgndata == null) {
                        DGNStoreProvider.this.dgndata = new DGNData();
                        DGNStoreProvider.this.dgndata.data = new ArrayList<FeatureProvider>();
                        DGNStoreProvider.this.data = DGNStoreProvider.this.dgndata.data;
                        DGNStoreProvider.this.counterNewsOIDs = 0L;
                        Reader reader = new Reader().initialice(DGNStoreProvider.this.getMemoryProvider(), (File)DGNStoreProvider.this.resource.get(), DGNStoreProvider.this.projection, DGNStoreProvider.this.legendBuilder);
                        reader.begin(storeProviderServices);
                        DGNStoreProvider.this.dgndata.defaultFType = reader.getDefaultType().getNotEditableCopy();
                        ArrayList<FeatureType> types = new ArrayList<FeatureType>();
                        for (EditableFeatureType fType : reader.getTypes()) {
                            if (fType.getId().equals(DGNStoreProvider.this.dgndata.defaultFType.getId())) {
                                types.add(DGNStoreProvider.this.dgndata.defaultFType);
                                continue;
                            }
                            types.add(fType.getNotEditableCopy());
                        }
                        DGNStoreProvider.this.dgndata.fTypes = types;
                        DGNStoreProvider.this.resource.notifyOpen();
                        storeProviderServices.setFeatureTypes(DGNStoreProvider.this.dgndata.fTypes, DGNStoreProvider.this.dgndata.defaultFType);
                        reader.load();
                        DGNStoreProvider.this.dgndata.envelope = reader.getEnvelope();
                        DGNStoreProvider.this.dgndata.legendBuilder = DGNStoreProvider.this.legendBuilder;
                        DGNStoreProvider.this.dgndata.projection = DGNStoreProvider.this.projection;
                        reader.end();
                        if (DGNStoreProvider.this.resource.getData() == null) {
                            DGNStoreProvider.this.resource.setData(new HashMap());
                        }
                        ((Map)DGNStoreProvider.this.resource.getData()).put(DGNStoreProvider.this.projection.getAbrev(), DGNStoreProvider.this.dgndata);
                        tc.restart("Loaded data from file (data=" + DGNStoreProvider.this.dgndata + ")");
                        DGNStoreProvider.this.resource.notifyClose();
                    }
                    List featureTypes = DGNStoreProvider.this.getFeatureTypes(storeProviderServices);
                    tc.restart("Created featuretype (featureTypes=" + featureTypes + ")");
                    PostProcessFeatures postProcess = new PostProcessFeatures(DGNStoreProvider.this.getDGNParameters(), (FeatureType)featureTypes.get(0));
                    if (postProcess.hasOperations()) {
                        DGNStoreProvider.this.data = postProcess.apply(DGNStoreProvider.this.dgndata.data);
                        DGNStoreProvider.this.setDynValue("Envelope", postProcess.getEnvelope());
                    } else {
                        DGNStoreProvider.this.data = DGNStoreProvider.this.dgndata.data;
                        DGNStoreProvider.this.setDynValue("Envelope", DGNStoreProvider.this.dgndata.getEnvelopeCopy());
                    }
                    tc.restart("PostProcessFeatures");
                    DGNStoreProvider.this.legendBuilder = DGNStoreProvider.this.dgndata.legendBuilder;
                    storeProviderServices.setFeatureTypes(featureTypes, (FeatureType)featureTypes.get(0));
                    DGNStoreProvider.this.setDynValue("CRS", DGNStoreProvider.this.projection);
                    DGNStoreProvider.this.counterNewsOIDs = DGNStoreProvider.this.data.size();
                    tc.restart("load finished.");
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.data = null;
            try {
                throw new OpenException(this.resource.getName(), (Throwable)e);
            }
            catch (AccessResourceException e1) {
                throw new OpenException(this.getProviderName(), (Throwable)e);
            }
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getDGNParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public List getFeatureTypes(FeatureStoreProviderServices store) {
        return this.getFeatureTypes(store, 1);
    }

    private List getFeatureTypes(FeatureStoreProviderServices store, int subtype) {
        EditableFeatureType featureType = store.createFeatureType(this.getName());
        featureType.setHasOID(true);
        this.ID_FIELD_ID = featureType.add(NAME_FIELD_ID, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_PARENT = featureType.add(NAME_FIELD_PARENTID, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_ENTITY = featureType.add(NAME_FIELD_ENTITY, 8, 100).setDefaultValue((Object)"").getIndex();
        this.ID_FIELD_LAYER = this.ID_FIELD_LEVEL = featureType.add(NAME_FIELD_LEVEL, 8, 100).setDefaultValue((Object)"default").getIndex();
        this.ID_FIELD_COLOR = featureType.add(NAME_FIELD_COLOR, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_TEXT = featureType.add(NAME_FIELD_TEXT, 8, 100).setDefaultValue((Object)"").getIndex();
        this.ID_FIELD_HEIGHTTEXT = featureType.add(NAME_FIELD_HEIGHTTEXT, 7).setDefaultValue((Object)10.0).getIndex();
        this.ID_FIELD_HEIGHTTEXTRAW = featureType.add(NAME_FIELD_HEIGHTTEXTRAW, 7).setDefaultValue((Object)10.0).getIndex();
        this.ID_FIELD_ROTATIONTEXT = featureType.add(NAME_FIELD_ROTATIONTEXT, 7).setDefaultValue((Object)0.0).getIndex();
        this.ID_FIELD_TYPE = featureType.add(NAME_FIELD_TYPE, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_STYPE = featureType.add(NAME_FIELD_STYPE, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_FILLCOLOR = featureType.add(NAME_FIELD_FILLCOLOR, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_STYLE = featureType.add(NAME_FIELD_STYLE, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_ELEVATION = featureType.add(NAME_FIELD_ELEVATION, 7).setDefaultValue((Object)0.0).getIndex();
        this.ID_FIELD_WEIGHT = featureType.add(NAME_FIELD_WEIGHT, 7).setDefaultValue((Object)0.0).getIndex();
        this.ID_FIELD_GROUP = featureType.add(NAME_FIELD_GROUP, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_ISSHAPE = featureType.add(NAME_FIELD_ISSHAPE, 1).setDefaultValue((Object)Boolean.FALSE).getIndex();
        this.ID_FIELD_ISCOMPLEXSHAPEHEADER = featureType.add(NAME_FIELD_ISCOMPLEXSHAPEHEADER, 1).setDefaultValue((Object)Boolean.FALSE).getIndex();
        this.ID_FIELD_ISHOLE = featureType.add(NAME_FIELD_ISHOLE, 1).setDefaultValue((Object)Boolean.FALSE).getIndex();
        this.ID_FIELD_ISCOMPLEX = featureType.add(NAME_FIELD_ISCOMPLEX, 1).setDefaultValue((Object)Boolean.FALSE).getIndex();
        this.ID_FIELD_SCALE = featureType.add(NAME_FIELD_SCALE, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINKS_COUNT = featureType.add(NAME_FIELD_LINKS_COUNT, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_INDEX = featureType.add(NAME_FIELD_LINK_INDEX, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_ENTITY = featureType.add(NAME_FIELD_LINK_ENTITY, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_TYPE = featureType.add(NAME_FIELD_LINK_TYPE, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_MS = featureType.add(NAME_FIELD_LINK_MS, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_LENGTH = featureType.add(NAME_FIELD_LINK_LENGTH, 4).setDefaultValue((Object)0).getIndex();
        this.ID_FIELD_LINK_DATA = featureType.add(NAME_FIELD_LINK_DATA, 8, 512).setDefaultValue((Object)"").getIndex();
        this.ID_FIELD_DATA = featureType.add(NAME_FIELD_DATA, 8, 512).setDefaultValue((Object)"").getIndex();
        EditableFeatureAttributeDescriptor attr = featureType.add(NAME_FIELD_GEOMETRY, 66);
        attr.setSRS(this.projection);
        int geometryTypeToUse = this.getDGNParameters().getGeometryTypeFilter();
        if (this.getDGNParameters().getGroupBy() != null) {
            switch (this.getDGNParameters().getGroupGeometriesOperation()) {
                case 0: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    geometryTypeToUse = 7;
                    break;
                }
                case 5: {
                    geometryTypeToUse = 8;
                    break;
                }
                case 1: 
                case 6: 
                case 7: {
                    geometryTypeToUse = 9;
                }
            }
        }
        try {
            attr.setGeometryType(GeometryLocator.getGeometryManager().getGeometryType(geometryTypeToUse, subtype));
        }
        catch (Exception e) {
            attr.setGeometryType(geometryTypeToUse);
            attr.setGeometrySubType(subtype);
        }
        this.ID_FIELD_GEOMETRY = attr.getIndex();
        featureType.setDefaultGeometryAttributeName(NAME_FIELD_GEOMETRY);
        this.MAX_FIELD_ID = featureType.size() - 1;
        ArrayList<EditableFeatureType> types = new ArrayList<EditableFeatureType>();
        types.add(featureType);
        return types;
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        throw new UnsupportedOperationException();
    }

    public void beginAppend() {
        throw new UnsupportedOperationException();
    }

    public void endAppend() {
        throw new UnsupportedOperationException();
    }

    public Object createNewOID() {
        return new Long(this.counterNewsOIDs++);
    }

    protected void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        return (Envelope)this.getDynValue("Envelope");
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getDGNParameters().getFile();
    }

    public String getName() {
        String name = this.getDGNParameters().getFile().getName();
        int n = name.lastIndexOf(".");
        if (n < 1) {
            return name;
        }
        return name.substring(0, n);
    }

    public String getFullName() {
        return this.getDGNParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    public static boolean equals(double a, double b, double precision) {
        double v = Math.abs(a - b);
        return v < precision;
    }

    public class Reader {
        private File file;
        private IProjection projection;
        private List types;
        private LegendBuilder leyendBuilder;
        private AbstractMemoryStoreProvider storeProvider;
        private Envelope envelope;

        public Reader initialice(AbstractMemoryStoreProvider storeProvider, File file, IProjection projection, LegendBuilder leyendBuilder) {
            this.storeProvider = storeProvider;
            this.file = file;
            this.projection = projection;
            this.leyendBuilder = leyendBuilder;
            if (leyendBuilder != null) {
                leyendBuilder.initialize((FeatureStoreProvider)storeProvider);
            }
            return this;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public void begin(FeatureStoreProviderServices storeProviderServices) {
            this.types = DGNStoreProvider.this.getFeatureTypes(storeProviderServices);
            if (this.leyendBuilder != null) {
                this.leyendBuilder.begin();
            }
        }

        public void end() {
            if (this.leyendBuilder != null) {
                this.leyendBuilder.end();
            }
        }

        public List getTypes() {
            return this.types;
        }

        public EditableFeatureType getDefaultType() {
            return (EditableFeatureType)this.types.get(0);
        }

        public void load() throws DataException, CreateEnvelopeException {
            switch (DGNStoreProvider.this.getDGNParameters().getLoadMode()) {
                default: {
                    this.load_plain();
                    break;
                }
                case 1: {
                    this.load_group1();
                }
            }
        }

        public void load_plain() throws DataException {
            BufferedWriter xmlbfw;
            FileWriter xmlfw;
            block43: {
                xmlfw = null;
                xmlbfw = null;
                this.envelope = null;
                boolean ignoreZs = DGNStoreProvider.this.getDGNParameters().ignoreZs();
                boolean useZAsElevation = DGNStoreProvider.this.getDGNParameters().useZAsElevation();
                boolean applyRoundToElevation = DGNStoreProvider.this.getDGNParameters().getApplyRoundToElevation();
                double elevationFactor = DGNStoreProvider.this.getDGNParameters().geElevationFactor();
                try {
                    if (DGNStoreProvider.this.getDGNParameters().getXMLFile() != null) {
                        File xmlfile = DGNStoreProvider.this.getDGNParameters().getXMLFile();
                        try {
                            xmlfw = new FileWriter(xmlfile);
                            xmlbfw = new BufferedWriter(xmlfw);
                        }
                        catch (Exception ex) {
                            xmlfw = null;
                            xmlbfw = null;
                            logger.warn("Can't open xmfile for output (" + xmlfile.getAbsolutePath() + "'.", (Throwable)ex);
                        }
                        if (xmlbfw != null) {
                            try {
                                xmlbfw.write("<DGN>\n");
                            }
                            catch (IOException ex) {
                                logger.warn("Can't write to the xml file.", (Throwable)ex);
                            }
                        }
                    }
                    DGNReader dgnReader = new DGNReader(this.file.getAbsolutePath(), DGNStoreProvider.this.getDGNParameters().logErrors());
                    int subtypeHeader = 1;
                    this.envelope = DGNStoreProvider.this.geomManager.createEnvelope(subtypeHeader);
                    FeatureType type = this.getDefaultType().getNotEditableCopy();
                    int counterOfElement = 0;
                    DGNElemComplexHeader parentElement = null;
                    double zvalue = 0.0;
                    for (int id = 0; id < dgnReader.getNumEntities(); ++id) {
                        dgnReader.DGNGotoElement(id);
                        DGNElemCore elemento = dgnReader.DGNReadElement();
                        if (elemento == null) continue;
                        if (parentElement != null && parentElement.getNumElements() < ++counterOfElement) {
                            parentElement = null;
                        }
                        if (xmlbfw != null) {
                            try {
                                xmlbfw.write(dgnReader.DGNDumpElement(dgnReader.getInfo(), elemento));
                            }
                            catch (IOException ex) {
                                logger.warn("Can't write to the xml file.", (Throwable)ex);
                            }
                        }
                        if (elemento.isDeleted()) continue;
                        FeatureProvider data = DGNStoreProvider.this.createFeatureProvider(type);
                        data.set(DGNStoreProvider.this.ID_FIELD_ID, (Object)elemento.getID());
                        data.set(DGNStoreProvider.this.ID_FIELD_TYPE, (Object)elemento.getType());
                        data.set(DGNStoreProvider.this.ID_FIELD_STYPE, (Object)elemento.getSType());
                        data.set(DGNStoreProvider.this.ID_FIELD_LEVEL, (Object)elemento.getLevelAsString());
                        data.set(DGNStoreProvider.this.ID_FIELD_COLOR, (Object)elemento.getColor());
                        data.set(DGNStoreProvider.this.ID_FIELD_FILLCOLOR, (Object)elemento.getShapeFillColor());
                        data.set(DGNStoreProvider.this.ID_FIELD_ENTITY, (Object)elemento.getEntityName());
                        data.set(DGNStoreProvider.this.ID_FIELD_STYLE, (Object)elemento.getStyle());
                        data.set(DGNStoreProvider.this.ID_FIELD_WEIGHT, (Object)elemento.getWeight());
                        data.set(DGNStoreProvider.this.ID_FIELD_GROUP, (Object)elemento.getGroup());
                        data.set(DGNStoreProvider.this.ID_FIELD_ELEVATION, (Object)elemento.getElevation());
                        data.set(DGNStoreProvider.this.ID_FIELD_ISCOMPLEXSHAPEHEADER, (Object)elemento.isComplexShapeHeader());
                        data.set(DGNStoreProvider.this.ID_FIELD_ISSHAPE, (Object)elemento.isShape());
                        data.set(DGNStoreProvider.this.ID_FIELD_ISHOLE, (Object)elemento.isHole());
                        data.set(DGNStoreProvider.this.ID_FIELD_ISCOMPLEX, (Object)elemento.isComplex());
                        data.set(DGNStoreProvider.this.ID_FIELD_HEIGHTTEXT, (Object)0);
                        data.set(DGNStoreProvider.this.ID_FIELD_HEIGHTTEXTRAW, (Object)0);
                        data.set(DGNStoreProvider.this.ID_FIELD_ROTATIONTEXT, (Object)0);
                        data.set(DGNStoreProvider.this.ID_FIELD_TEXT, null);
                        data.set(DGNStoreProvider.this.ID_FIELD_SCALE, (Object)dgnReader.getInfo().scale);
                        data.set(DGNStoreProvider.this.ID_FIELD_DATA, (Object)elemento.getDataAsHexadecimal());
                        if (parentElement == null) {
                            data.set(DGNStoreProvider.this.ID_FIELD_PARENT, (Object)elemento.getID());
                        } else {
                            data.set(DGNStoreProvider.this.ID_FIELD_PARENT, (Object)parentElement.getID());
                        }
                        data.set(DGNStoreProvider.this.ID_FIELD_LINKS_COUNT, (Object)dgnReader.DGNGetLinkageCount(elemento));
                        DGNLink dgnlink = dgnReader.DGNGetLinkage(elemento, DGNStoreProvider.this.getDGNParameters().getLinkFilterIndex(), DGNStoreProvider.this.getDGNParameters().getLinkFilterType(), DGNStoreProvider.this.getDGNParameters().getLinkFilterEntity(), DGNStoreProvider.this.getDGNParameters().getLinkFilterMS(), DGNStoreProvider.this.getDGNParameters().getLinkFilterDataAsPattern());
                        if (dgnlink != null) {
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_INDEX, (Object)dgnlink.getIndex());
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_TYPE, (Object)dgnlink.getType());
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_ENTITY, (Object)dgnlink.getEntityCode());
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_MS, (Object)dgnlink.getMSLink());
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_LENGTH, (Object)dgnlink.getLength());
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_DATA, (Object)dgnlink.getDataAsHexadecimal());
                        } else {
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_INDEX, (Object)-1);
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_TYPE, (Object)0);
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_ENTITY, (Object)0);
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_MS, (Object)0);
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_LENGTH, (Object)0);
                            data.set(DGNStoreProvider.this.ID_FIELD_LINK_DATA, (Object)"");
                        }
                        zvalue = 0.0;
                        try {
                            switch (elemento.stype) {
                                case 7: {
                                    parentElement = (DGNElemComplexHeader)elemento;
                                    counterOfElement = 0;
                                    break;
                                }
                                case 2: {
                                    DGNPoint p;
                                    int i;
                                    DGNElemMultiPoint dgnmultipoint = (DGNElemMultiPoint)elemento;
                                    if (dgnmultipoint.isPoint()) {
                                        DGNPoint p2 = dgnmultipoint.getPoint(0);
                                        Point point = this.createPoint(p2.getX(), p2.getY(), ignoreZs ? 0.0 : p2.getZ());
                                        data.setDefaultGeometry((Geometry)point);
                                        zvalue = p2.getZ();
                                        break;
                                    }
                                    Object geom = null;
                                    int subtypeElement = this.getGeometrySubType(dgnmultipoint);
                                    geom = dgnmultipoint.isPolygon() ? DGNStoreProvider.this.geomManager.createPolygon(subtypeHeader) : DGNStoreProvider.this.geomManager.createLine(subtypeHeader);
                                    int first = 0;
                                    int numVertices = dgnmultipoint.getNumVertices();
                                    if (dgnmultipoint.isCurve()) {
                                        first = 2;
                                        numVertices = dgnmultipoint.getNumVertices() - 2;
                                    }
                                    if (dgnmultipoint.isHole()) {
                                        for (i = numVertices - 2; i >= first; --i) {
                                            p = dgnmultipoint.getVertex(i);
                                            zvalue = p.getZ();
                                            this.addVertex((OrientablePrimitive)geom, p.getX(), p.getY(), ignoreZs ? 0.0 : zvalue);
                                        }
                                    } else {
                                        for (i = first; i < numVertices; ++i) {
                                            p = dgnmultipoint.getVertex(i);
                                            zvalue = p.getZ();
                                            this.addVertex((OrientablePrimitive)geom, p.getX(), p.getY(), ignoreZs ? 0.0 : zvalue);
                                        }
                                    }
                                    data.setDefaultGeometry((Geometry)geom);
                                    break;
                                }
                                case 5: {
                                    DGNElemArc dgnarc = (DGNElemArc)elemento;
                                    AffineTransform mT = AffineTransform.getRotateInstance(Math.toRadians(dgnarc.rotation), dgnarc.origin.x, dgnarc.origin.y);
                                    Arc2D.Double elArco = new Arc2D.Double(dgnarc.origin.x - dgnarc.primary_axis, dgnarc.origin.y - dgnarc.secondary_axis, 2.0 * dgnarc.primary_axis, 2.0 * dgnarc.secondary_axis, -dgnarc.startang, -dgnarc.sweepang, 0);
                                    zvalue = dgnarc.origin.getZ();
                                    PathIterator pathIterator = elArco.getPathIterator(null);
                                    IGeneralPathX elShapeArc = DGNStoreProvider.this.geomManager.createGeneralPath(0, pathIterator);
                                    elShapeArc.transform(mT);
                                    Object geom = null;
                                    int subtypeElement = this.getGeometrySubType(dgnarc);
                                    geom = dgnarc.isSurface() ? DGNStoreProvider.this.geomManager.createPolygon(subtypeElement) : DGNStoreProvider.this.geomManager.createLine(subtypeElement);
                                    for (int i = 0; i < elShapeArc.getNumCoords(); ++i) {
                                        double[] coords = elShapeArc.getCoordinatesAt(i);
                                        if (ignoreZs || subtypeElement == 0 || subtypeElement == 2) {
                                            geom.addVertex(coords[0], coords[1]);
                                            continue;
                                        }
                                        geom.addVertex(coords[0], coords[1], zvalue);
                                    }
                                    data.setDefaultGeometry((Geometry)geom);
                                    break;
                                }
                                case 6: {
                                    DGNElemText dgntext = (DGNElemText)elemento;
                                    int subtypeElement = this.getGeometrySubType(dgntext);
                                    Point point = (Point)DGNStoreProvider.this.geomManager.create(1, subtypeHeader);
                                    point.setCoordinateAt(0, dgntext.getPoint().getX());
                                    point.setCoordinateAt(1, dgntext.getPoint().getY());
                                    if (subtypeHeader == 1) {
                                        if (subtypeElement == 0) {
                                            point.setCoordinateAt(2, 0.0);
                                        } else {
                                            point.setCoordinateAt(2, dgntext.getPoint().getZ());
                                        }
                                    }
                                    data.set(DGNStoreProvider.this.ID_FIELD_HEIGHTTEXT, (Object)dgntext.getHeight());
                                    data.set(DGNStoreProvider.this.ID_FIELD_HEIGHTTEXTRAW, (Object)dgntext.getRawHeight());
                                    data.set(DGNStoreProvider.this.ID_FIELD_ROTATIONTEXT, (Object)dgntext.getRotation());
                                    data.set(DGNStoreProvider.this.ID_FIELD_TEXT, (Object)dgntext.getText());
                                    data.setDefaultGeometry((Geometry)point);
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("Can't process element", (Throwable)ex);
                        }
                        if (useZAsElevation) {
                            if (!DGNStoreProvider.equals(elevationFactor, 1.0, 1.0E-5)) {
                                zvalue *= elevationFactor;
                            }
                            if (applyRoundToElevation) {
                                zvalue = Math.round(zvalue);
                            }
                            data.set(DGNStoreProvider.this.ID_FIELD_ELEVATION, (Object)zvalue);
                        }
                        this.addFeature(data, dgnReader);
                    }
                    EditableFeatureType featureType = this.storeProvider.getFeatureStore().getDefaultFeatureType().getCopy().getEditable();
                    FeatureAttributeDescriptor fad = (FeatureAttributeDescriptor)featureType.get(featureType.getDefaultGeometryAttributeName());
                    featureType.remove(fad.getName());
                    EditableFeatureAttributeDescriptor efad = featureType.add(fad.getName(), fad.getType(), fad.getSize());
                    efad.setDefaultValue(fad.getDefaultValue());
                    GeometryType gty = null;
                    gty = DGNStoreProvider.this.geomManager.getGeometryType(fad.getGeomType().getType(), subtypeHeader);
                    efad.setGeometryType(gty);
                    efad.setPrecision(fad.getPrecision());
                    featureType.setDefaultGeometryAttributeName(fad.getName());
                    if (xmlbfw == null) break block43;
                    try {
                        xmlbfw.write("</DGN>\n");
                    }
                    catch (IOException ex) {
                        logger.warn("Can't write to the xml file.", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    try {
                        logger.warn("Can't process DGN file '" + DGNStoreProvider.this.getFullName() + ".", (Throwable)ex);
                        throw new LoadException((Throwable)ex, DGNStoreProvider.this.getFullName());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(xmlbfw);
                        IOUtils.closeQuietly(xmlfw);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((Writer)xmlbfw);
            IOUtils.closeQuietly((Writer)xmlfw);
        }

        private int getGeometrySubType(DGNElemCore element) {
            if (DGNStoreProvider.this.getDGNParameters().force2D()) {
                return 0;
            }
            return element.is3D() ? 1 : 0;
        }

        private void addVertex(OrientablePrimitive geom, double x, double y, double z) {
            if (geom.getDimension() == 2) {
                geom.addVertex(x, y);
            } else {
                geom.addVertex(x, y, z);
            }
        }

        private void fillRow(Object[] row, DGNElemCore elemento, DGNElemComplexHeader parentElement, DGNReader dgnReader) {
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_HEIGHTTEXT] = new Double(0.0);
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_HEIGHTTEXTRAW] = new Double(0.0);
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ROTATIONTEXT] = new Double(0.0);
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_TEXT] = null;
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.getID();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_TYPE] = elemento.getType();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_STYPE] = elemento.getSType();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LEVEL] = elemento.getLevelAsString();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.getColor();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_FILLCOLOR] = elemento.getShapeFillColor();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = elemento.getEntityName();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_STYLE] = elemento.getStyle();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_WEIGHT] = elemento.getWeight();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_GROUP] = elemento.getGroup();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ELEVATION] = elemento.getElevation();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ISCOMPLEXSHAPEHEADER] = elemento.isComplexShapeHeader();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ISSHAPE] = elemento.isShape();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ISHOLE] = elemento.isHole();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ISCOMPLEX] = elemento.isComplex();
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_PARENT] = elemento.getID();
            if (parentElement != null) {
                row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_PARENT] = parentElement.getID();
            }
            row[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_SCALE] = dgnReader.getInfo().scale;
        }

        public void load_group1() throws DataException, CreateEnvelopeException {
            this.envelope = null;
            FileWriter xmlfw = null;
            BufferedWriter xmlbfw = null;
            if (DGNStoreProvider.this.getDGNParameters().getXMLFile() != null) {
                File xmlfile = DGNStoreProvider.this.getDGNParameters().getXMLFile();
                try {
                    xmlfw = new FileWriter(xmlfile);
                    xmlbfw = new BufferedWriter(xmlfw);
                }
                catch (Exception ex) {
                    xmlfw = null;
                    xmlbfw = null;
                    logger.warn("Can't open xmfile for output (" + xmlfile.getAbsolutePath() + "'.", (Throwable)ex);
                }
                if (xmlbfw != null) {
                    try {
                        xmlbfw.write("<DGN>\n");
                    }
                    catch (IOException ex) {
                        logger.warn("Can't write to the xml file.", (Throwable)ex);
                    }
                }
            }
            DGNReader dgnReader = new DGNReader(this.file.getAbsolutePath());
            this.envelope = dgnReader.getInfo().dimension == 2 ? DGNStoreProvider.this.geomManager.createEnvelope(0) : DGNStoreProvider.this.geomManager.createEnvelope(1);
            FeatureType type = this.getDefaultType().getNotEditableCopy();
            int fTypeSize = type.size();
            Object[] auxRow = new Object[fTypeSize];
            Object[] cellRow = new Object[fTypeSize];
            Object[] complexRow = new Object[fTypeSize];
            boolean bElementoCompuesto = false;
            boolean bEsPoligono = false;
            boolean bInsideCell = false;
            boolean bFirstHoleEntity = false;
            boolean bConnect = false;
            int complex_index_fill_color = -1;
            IGeneralPathX elementoCompuesto = DGNStoreProvider.this.geomManager.createGeneralPath(0, null);
            int counterOfElement = 0;
            DGNElemComplexHeader parentElement = null;
            block16: for (int id = 0; id < dgnReader.getNumEntities(); ++id) {
                dgnReader.DGNGotoElement(id);
                DGNElemCore elemento = dgnReader.DGNReadElement();
                if (parentElement != null && parentElement.getNumElements() < ++counterOfElement) {
                    parentElement = null;
                }
                if (xmlbfw != null && elemento != null) {
                    try {
                        xmlbfw.write(dgnReader.DGNDumpElement(dgnReader.getInfo(), elemento));
                    }
                    catch (IOException ex) {
                        logger.warn("Can't write to the xml file.", (Throwable)ex);
                    }
                }
                int nClass = 0;
                this.fillRow(auxRow, elemento, parentElement, dgnReader);
                auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_HEIGHTTEXT] = new Double(0.0);
                auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ROTATIONTEXT] = new Double(0.0);
                auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_TEXT] = null;
                if (elemento.properties != 0) {
                    nClass = elemento.properties & 0xF;
                }
                if (elemento == null || elemento.deleted != 0 || nClass != 0) continue;
                if (elemento.stype == 2 || elemento.stype == 5 || elemento.stype == 8 || elemento.stype == 13 || elemento.stype == 7) {
                    if (elemento.complex != 0) {
                        bElementoCompuesto = true;
                    } else {
                        if (bElementoCompuesto) {
                            if (bInsideCell) {
                                auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = cellRow[DGNStoreProvider.this.ID_FIELD_ENTITY];
                            } else {
                                auxRow = complexRow;
                            }
                            this.addShape(this.createMultiCurve(elementoCompuesto), auxRow, type, dgnReader);
                            if (bEsPoligono) {
                                if (complex_index_fill_color != -1) {
                                    auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = complex_index_fill_color;
                                }
                                this.addShape(this.createMultiSurface(elementoCompuesto), auxRow, type, dgnReader);
                            }
                            elementoCompuesto = DGNStoreProvider.this.geomManager.createGeneralPath(0, null);
                        }
                        bElementoCompuesto = false;
                        bEsPoligono = false;
                        bConnect = false;
                        bInsideCell = false;
                    }
                }
                switch (elemento.stype) {
                    case 13: {
                        bInsideCell = true;
                        this.fillRow(cellRow, elemento, parentElement, dgnReader);
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Shared Cell";
                        continue block16;
                    }
                    case 8: {
                        bInsideCell = true;
                        this.fillRow(cellRow, elemento, parentElement, dgnReader);
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        cellRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Cell";
                        complex_index_fill_color = dgnReader.DGNGetShapeFillInfo(elemento);
                        continue block16;
                    }
                    case 7: {
                        DGNElemComplexHeader psComplexHeader;
                        parentElement = psComplexHeader = (DGNElemComplexHeader)elemento;
                        counterOfElement = parentElement.getNumElements();
                        this.fillRow(complexRow, elemento, parentElement, dgnReader);
                        complexRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        complexRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        complexRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        complexRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Complex";
                        if (psComplexHeader.type == 14) {
                            bEsPoligono = true;
                            if ((psComplexHeader.properties & 0x8000) != 0) {
                                bFirstHoleEntity = true;
                            } else {
                                complex_index_fill_color = dgnReader.DGNGetShapeFillInfo(elemento);
                            }
                            bConnect = true;
                            continue block16;
                        }
                        bEsPoligono = false;
                        bConnect = false;
                        continue block16;
                    }
                    case 2: {
                        int i;
                        DGNElemMultiPoint psLine = (DGNElemMultiPoint)elemento;
                        this.fillRow(auxRow, elemento, parentElement, dgnReader);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Multipoint";
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        if (psLine.num_vertices == 2 && psLine.vertices[0].x == psLine.vertices[1].x && psLine.vertices[0].y == psLine.vertices[1].y) {
                            auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Point";
                            this.addShape((Geometry)this.createPoint(psLine.vertices[0].x, psLine.vertices[0].y, psLine.vertices[0].z), auxRow, type, dgnReader);
                            continue block16;
                        }
                        IGeneralPathX elShape = DGNStoreProvider.this.geomManager.createGeneralPath(0, null);
                        if (psLine.type == 11) {
                            psLine.num_vertices -= 4;
                            for (int aux_n = 0; aux_n < psLine.num_vertices; ++aux_n) {
                                psLine.vertices[aux_n] = psLine.vertices[aux_n + 2];
                            }
                        }
                        if (psLine.type == 6 && (psLine.properties & 0x8000) != 0) {
                            elShape.moveTo(psLine.vertices[psLine.num_vertices - 1].x, psLine.vertices[psLine.num_vertices - 1].y);
                            for (i = psLine.num_vertices - 2; i >= 0; --i) {
                                elShape.lineTo(psLine.vertices[i].x, psLine.vertices[i].y);
                            }
                        } else {
                            elShape.moveTo(psLine.vertices[0].x, psLine.vertices[0].y);
                            for (i = 1; i < psLine.num_vertices; ++i) {
                                elShape.lineTo(psLine.vertices[i].x, psLine.vertices[i].y);
                            }
                        }
                        if (psLine.vertices[0].x == psLine.vertices[psLine.num_vertices - 1].x && psLine.vertices[0].y == psLine.vertices[psLine.num_vertices - 1].y) {
                            bEsPoligono = true;
                            if (elemento.attr_bytes > 0) {
                                elemento.color = dgnReader.DGNGetShapeFillInfo(elemento);
                                if (elemento.color != -1) {
                                    auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                                }
                            }
                            if (elemento.complex == 0) {
                                this.addShape(this.createSurface(elShape), auxRow, type, dgnReader);
                            }
                        }
                        if (elemento.complex != 0) {
                            if (bFirstHoleEntity || psLine.type == 6 && (psLine.properties & 0x8000) != 0) {
                                elementoCompuesto.append(elShape.getPathIterator(null), false);
                                bFirstHoleEntity = false;
                                continue block16;
                            }
                            elementoCompuesto.append(elShape.getPathIterator(null), bConnect);
                            continue block16;
                        }
                        this.addShape(this.createMultiCurve(elShape), auxRow, type, dgnReader);
                        continue block16;
                    }
                    case 5: {
                        DGNElemArc psArc = (DGNElemArc)elemento;
                        AffineTransform mT = AffineTransform.getRotateInstance(Math.toRadians(psArc.rotation), psArc.origin.x, psArc.origin.y);
                        Arc2D.Double elArco = new Arc2D.Double(psArc.origin.x - psArc.primary_axis, psArc.origin.y - psArc.secondary_axis, 2.0 * psArc.primary_axis, 2.0 * psArc.secondary_axis, -psArc.startang, -psArc.sweepang, 0);
                        IGeneralPathX elShapeArc = DGNStoreProvider.this.geomManager.createGeneralPath(0, elArco.getPathIterator(null));
                        elShapeArc.transform(mT);
                        if (dgnReader.getInfo().dimension == 3) {
                            // empty if block
                        }
                        this.fillRow(auxRow, elemento, parentElement, dgnReader);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = "Arc";
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        if (elemento.complex != 0) {
                            if (elemento.type == 15) {
                                bConnect = false;
                            }
                            if (bFirstHoleEntity || elemento.type == 6 && (elemento.properties & 0x8000) != 0) {
                                elementoCompuesto.append(elShapeArc.getPathIterator(null), false);
                                bFirstHoleEntity = false;
                                continue block16;
                            }
                            elementoCompuesto.append(elShapeArc.getPathIterator(null), bConnect);
                            continue block16;
                        }
                        this.addShape(this.createMultiCurve(elShapeArc), auxRow, type, dgnReader);
                        if (psArc.type != 15) continue block16;
                        this.addShape(this.createSurface(elShapeArc), auxRow, type, dgnReader);
                        continue block16;
                    }
                    case 6: {
                        DGNElemText psText = (DGNElemText)elemento;
                        Point elShapeTxt = this.createPoint(psText.origin.x, psText.origin.y, psText.origin.z);
                        this.fillRow(auxRow, elemento, parentElement, dgnReader);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ID] = elemento.element_id;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ENTITY] = DGNStoreProvider.NAME_FIELD_TEXT;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_LAYER] = String.valueOf(elemento.level);
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = elemento.color;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_HEIGHTTEXT] = psText.height_mult;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_HEIGHTTEXTRAW] = psText.height_raw;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_ROTATIONTEXT] = psText.rotation;
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_TEXT] = psText.string;
                        this.addShape((Geometry)elShapeTxt, auxRow, type, dgnReader);
                    }
                }
            }
            if (bElementoCompuesto) {
                auxRow = bInsideCell ? cellRow : complexRow;
                this.addShape(this.createMultiCurve(elementoCompuesto), auxRow, type, dgnReader);
                if (bEsPoligono) {
                    if (complex_index_fill_color != -1) {
                        auxRow[((DGNStoreProvider)DGNStoreProvider.this).ID_FIELD_COLOR] = complex_index_fill_color;
                    }
                    this.addShape(this.createSurface(elementoCompuesto), auxRow, type, dgnReader);
                }
            }
            if (xmlbfw != null) {
                try {
                    xmlbfw.write("</DGN>\n");
                }
                catch (IOException ex) {
                    logger.warn("Can't write to the xml file.", (Throwable)ex);
                }
                IOUtils.closeQuietly((Writer)xmlbfw);
                IOUtils.closeQuietly((Writer)xmlfw);
            }
        }

        private Geometry createMultiSurface(IGeneralPathX elementoCompuesto) throws DataException {
            try {
                return DGNStoreProvider.this.geomManager.createMultiSurface((GeneralPathX)elementoCompuesto, 0);
            }
            catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
                throw new CreateGeometryException((Throwable)e);
            }
        }

        private Point createPoint(double x, double y, double z) throws DataException {
            Point point;
            int subtype = 1;
            if (DGNStoreProvider.this.getDGNParameters().force2D()) {
                subtype = 0;
            }
            try {
                point = (Point)DGNStoreProvider.this.geomManager.create(1, subtype);
            }
            catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
                throw new CreateGeometryException((Throwable)e);
            }
            point.setCoordinates(new double[]{x, y, z});
            return point;
        }

        private void addFeature(FeatureProvider data, DGNReader dgnReader) throws DataException {
            DGNStoreProvider.this.addFeatureProvider(data);
            Geometry geometry = data.getDefaultGeometry();
            if (geometry != null) {
                if (this.envelope == null) {
                    this.envelope = geometry.getEnvelope();
                } else {
                    this.envelope.add(geometry.getEnvelope());
                }
            }
            if (this.leyendBuilder != null) {
                this.leyendBuilder.process(data, dgnReader);
            }
        }

        private void addShape(Geometry geometry, Object[] auxRow, FeatureType type, DGNReader dgnReader) throws DataException {
            FeatureProvider data = DGNStoreProvider.this.createFeatureProvider(type);
            for (int i = 0; i < type.size(); ++i) {
                data.set(i, auxRow[i]);
            }
            data.setDefaultGeometry(geometry);
            this.addFeature(data, dgnReader);
        }

        private Geometry createMultiCurve(IGeneralPathX elementoCompuesto) throws DataException {
            try {
                return DGNStoreProvider.this.geomManager.createMultiCurve((GeneralPathX)elementoCompuesto, 0);
            }
            catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
                throw new CreateGeometryException((Throwable)e);
            }
        }

        private Geometry createSurface(IGeneralPathX elementoCompuesto) throws DataException {
            try {
                return DGNStoreProvider.this.geomManager.createCurve((GeneralPathX)elementoCompuesto, 0);
            }
            catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
                throw new CreateGeometryException((Throwable)e);
            }
        }
    }

    public static class TimeCounter {
        private static final Logger logger = LoggerFactory.getLogger(TimeCounter.class);
        private long counter = 0L;
        private Date t1;
        private Date t2;

        public void start() {
            this.t2 = this.t1 = new Date();
        }

        public void restart() {
            this.t2 = this.t1 = new Date();
            this.counter = 0L;
        }

        public void stop() {
            this.t2 = new Date();
            this.counter += this.t2.getTime() - this.t1.getTime();
        }

        public long get() {
            return this.counter;
        }

        public void log(String msg) {
            logger.debug("Time " + this.get() + " ms. " + msg);
        }

        public void restart(String msg) {
            this.stop();
            this.log(msg);
            this.restart();
        }
    }

    private class DGNData {
        public List<FeatureProvider> data = null;
        public FeatureType defaultFType = null;
        public List<FeatureType> fTypes = null;
        public Envelope envelope = null;
        public IProjection projection;
        public LegendBuilder legendBuilder;

        private DGNData() {
        }

        public Envelope getEnvelopeCopy() throws CreateEnvelopeException {
            if (this.envelope == null) {
                return null;
            }
            try {
                return (Envelope)this.envelope.clone();
            }
            catch (CloneNotSupportedException ex) {
                logger.warn("Can't clone envelope.", (Throwable)ex);
                return null;
            }
        }
    }
}

