/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.store.dgn.DGNOpenStoreParameters;
import org.gvsig.fmap.dal.store.dgn.DGNStoreProvider;
import org.gvsig.fmap.dal.store.dgn.PostProcessFilterOperation;
import org.gvsig.fmap.dal.store.dgn.PostProcessGroupOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessFeatures {
    private static final Logger logger = LoggerFactory.getLogger(PostProcessFeatures.class);
    private final FeatureType featureType;
    private final DGNOpenStoreParameters parameters;
    private Envelope envelope;
    private final int geomSubtype;
    private PostProcessFilterOperation filter = null;

    public PostProcessFeatures(DGNOpenStoreParameters parameters, FeatureType featureType) {
        this.featureType = featureType;
        this.parameters = parameters;
        this.geomSubtype = parameters.ignoreZs() ? 0 : featureType.getDefaultGeometryAttribute().getGeomType().getSubType();
    }

    private DGNOpenStoreParameters getDGNParameters() {
        return this.parameters;
    }

    private PostProcessFilterOperation getFilter() {
        if (this.filter == null) {
            this.filter = new PostProcessFilterOperation(this.getDGNParameters(), this.featureType);
        }
        return this.filter;
    }

    public List<FeatureProvider> apply(List<FeatureProvider> rows) throws CreateEnvelopeException {
        DGNStoreProvider.TimeCounter tc_total = new DGNStoreProvider.TimeCounter();
        DGNStoreProvider.TimeCounter tc_accept = new DGNStoreProvider.TimeCounter();
        PostProcessFilterOperation filter = this.getFilter();
        List<Object> result = null;
        Iterator<FeatureProvider> rowsIterator = rows.iterator();
        int rowCount = 0;
        int rowFitereds = 0;
        if (this.parameters.getGroupBy() == null) {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            this.envelope = geomManager.createEnvelope(this.geomSubtype);
            tc_total.start();
            result = new ArrayList();
            while (rowsIterator.hasNext()) {
                FeatureProvider feature = rowsIterator.next();
                ++rowCount;
                tc_accept.start();
                boolean accept = filter.accept(feature);
                tc_accept.stop();
                if (!accept) continue;
                ++rowFitereds;
                Geometry geom = feature.getDefaultGeometry();
                if (geom != null) {
                    this.envelope.add(geom.getEnvelope());
                }
                result.add(feature);
            }
            tc_total.stop();
            tc_accept.log("Accepts time filter");
            tc_total.log("Total time filer, rows input " + rowCount + ", output " + rowFitereds);
        } else {
            tc_total.start();
            PostProcessGroupOperation groupOperation = new PostProcessGroupOperation(this.featureType, this.parameters.getGroupBy(), this.parameters.getGroupGeometriesOperation());
            while (rowsIterator.hasNext()) {
                FeatureProvider feature = rowsIterator.next();
                ++rowCount;
                tc_accept.start();
                boolean accept = filter.accept(feature);
                tc_accept.stop();
                if (!accept) continue;
                ++rowFitereds;
                groupOperation.add(feature);
            }
            result = groupOperation.getRows();
            this.envelope = groupOperation.getEnvelope();
            tc_total.stop();
            tc_accept.log("Accepts time filter+group");
            tc_total.log("Total time filer+group, rows input " + rowCount + ", output " + rowFitereds);
        }
        if (this.parameters.sortByGeometryType()) {
            this.sortRows(result);
        }
        return result;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    private void sortRows(List<FeatureProvider> rows) {
        DGNStoreProvider.TimeCounter tc = new DGNStoreProvider.TimeCounter();
        tc.start();
        Collections.sort(rows, new Comparator<FeatureProvider>(){

            @Override
            public int compare(FeatureProvider o1, FeatureProvider o2) {
                Geometry g1 = o1.getDefaultGeometry();
                Geometry g2 = o2.getDefaultGeometry();
                if (g1 == null) {
                    if (g2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (g2 == null) {
                    return 1;
                }
                return g2.getType() - g1.getType();
            }
        });
        tc.stop();
        tc.log("sort data, rows " + rows.size());
    }

    public boolean hasOperations() {
        PostProcessFilterOperation filter = this.getFilter();
        if (filter.hasFilter()) {
            return true;
        }
        return this.parameters.getGroupBy() != null;
    }
}

