/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn.lib;

import java.util.Formatter;
import org.gvsig.fmap.dal.store.dgn.lib.DGNReader;

public class DGNElemCore {
    public int offset;
    public int size;
    public int element_id;
    public int stype;
    public int level;
    public int type;
    public int complex;
    public int deleted;
    public int graphic_group;
    public int properties;
    public int color;
    public int weight;
    public int style;
    public int attr_bytes;
    public byte[] attr_data;
    public int raw_bytes;
    public byte[] raw_data;
    protected DGNReader dgnreader = null;

    public DGNElemCore(DGNReader dgnreader) {
        this.dgnreader = dgnreader;
    }

    public boolean isComplex() {
        return this.complex != 0;
    }

    public boolean isDeleted() {
        return this.deleted != 0;
    }

    public boolean isHole() {
        if (this.type != 6) {
            return false;
        }
        return (this.properties & 0x8000) != 0;
    }

    public boolean is3D() {
        return this.getDimensions() == 3;
    }

    public boolean isComplexShapeHeader() {
        return this.type == 14;
    }

    public boolean isShape() {
        return this.type == 6;
    }

    public boolean isEllipse() {
        return this.type == 15;
    }

    public boolean isCurve() {
        return this.type == 11;
    }

    public int getShapeFillColor() {
        return this.dgnreader.DGNGetShapeFillInfo(this);
    }

    public String getLevelAsString() {
        return String.valueOf(this.level);
    }

    public int getLevel() {
        return this.level;
    }

    public int getStyle() {
        return this.style;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getEntityName() {
        return this.dgnreader.DGNTypeToName(this.type);
    }

    public int getColor() {
        return this.color;
    }

    public int getID() {
        return this.element_id;
    }

    public int getGroup() {
        return this.graphic_group;
    }

    public double getElevation() {
        return 0.0;
    }

    public int getDimensions() {
        return this.dgnreader.getInfo().dimension;
    }

    public int getType() {
        return this.type;
    }

    public int getSType() {
        return this.stype;
    }

    public byte[] getData() {
        return this.raw_data;
    }

    public String getDataAsHexadecimal() {
        if (this.raw_data == null) {
            return null;
        }
        Formatter out = new Formatter();
        for (int i = 0; i < this.raw_data.length; ++i) {
            int ch = this.raw_data[i] & 0xFF;
            out.format("%02X", ch);
        }
        return out.toString();
    }
}

