/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.detect.AutoDetectReader;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.xml.sax.InputSource;

public class Xml2dbCommons {
    public static Charset detectCharset(InputStream is) {
        try {
            AutoDetectReader reader = new AutoDetectReader(is);
            return reader.getCharset();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String detectCharsetName(InputStream is) {
        Charset charset = Xml2dbCommons.detectCharset(is);
        if (charset == null) {
            return null;
        }
        return charset.name();
    }

    public static InputSource openReader(File xmlfile, Charset charset) {
        try {
            FileInputStream fis = new FileInputStream(xmlfile);
            InputSource is = new InputSource();
            is.setPublicId(xmlfile.getAbsolutePath());
            is.setByteStream(fis);
            if (charset != null) {
                is.setEncoding(charset.name());
            }
            return Xml2dbCommons.openReader(is);
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't open xml input stream.", t);
        }
    }

    public static InputSource openReader(InputStream xml, Charset charset) {
        InputSource is = new InputSource();
        is.setByteStream(xml);
        if (charset != null) {
            is.setEncoding(charset.name());
        }
        return Xml2dbCommons.openReader(is);
    }

    public static InputSource openReader(InputSource is) {
        try {
            if (StringUtils.isBlank((CharSequence)is.getEncoding())) {
                AutoDetectReader reader = new AutoDetectReader(is.getByteStream());
                is.setCharacterStream((Reader)reader);
                is.setEncoding(reader.getCharset().name());
            } else {
                BOMInputStream bomIs = new BOMInputStream(is.getByteStream());
                is.setByteStream((InputStream)bomIs);
                InputStreamReader reader = new InputStreamReader(is.getByteStream(), is.getEncoding());
                is.setCharacterStream(reader);
            }
            return is;
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't open xml input stream.", t);
        }
    }

    public static long countLines(File xml, Charset charset, SimpleTaskStatus status) {
        try {
            FileInputStream fis = new FileInputStream(xml);
            return Xml2dbCommons.countLines(fis, charset, status);
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't count lines.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countLines(InputStream xml, Charset charset, SimpleTaskStatus status) {
        try {
            long count = 0L;
            BufferedReader br = null;
            status.setIndeterminate();
            status.setCurValue(0L);
            try {
                InputSource is = new InputSource(xml);
                if (charset != null) {
                    is.setEncoding(charset.name());
                }
                is = Xml2dbCommons.openReader(is);
                br = new BufferedReader(is.getCharacterStream());
                int n = 1;
                I18nManager i18n = ToolsLocator.getI18nManager();
                while (br.readLine() != null) {
                    if (count % (long)n == 0L) {
                        status.message(i18n.getTranslation("_Calculating_lines"));
                        status.setCurValue(count);
                    }
                    if (++count > 100000L) {
                        n = 10000;
                        continue;
                    }
                    if (count > 10000L) {
                        n = 1000;
                        continue;
                    }
                    if (count > 1000L) {
                        n = 100;
                        continue;
                    }
                    if (count <= 100L) continue;
                    n = 10;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            return count;
        }
        catch (Throwable t) {
            throw new RuntimeException("Can't count lines.", t);
        }
    }
}

