/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl.xmlinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLAttributeInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLAttributeInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTableInfoImpl
implements XMLTableInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTableInfoImpl.class);
    private final String path;
    private final List<XMLAttributeInfo> attributes;
    private final XMLAttributeInfoImpl tagInfo;
    private String name;
    private EditableFeatureType featureType;
    private String originalName;

    public XMLTableInfoImpl(String path, XMLAttributeInfoImpl tagInfo) {
        this.tagInfo = tagInfo;
        this.name = FilenameUtils.getBaseName((String)path);
        this.path = path;
        this.attributes = new ArrayList<XMLAttributeInfo>();
        this.featureType = null;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void add(XMLAttributeInfoImpl attrinfo) {
        for (XMLAttributeInfo info : this.attributes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)attrinfo.getName(), (CharSequence)info.getName())) continue;
            LOGGER.warn("Duplicated field '" + info.getName() + " in Table '" + this.getName() + "' (" + attrinfo.getPath() + "," + info.getPath() + ")");
        }
        this.attributes.add(attrinfo);
        attrinfo.setTable(this);
    }

    public int getMaxCountChild(String name) {
        return this.tagInfo.getMaxChildCount(name);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("name", (Object)this.name);
        builder.append("path", (Object)this.path);
        builder.append("attributes", this.attributes.toArray(), true);
        return builder.build();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void rename(String name) {
        this.originalName = this.name;
        this.name = name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public int size() {
        return this.attributes.size();
    }

    public XMLAttributeInfo get(int index) {
        return this.attributes.get(index);
    }

    public Iterator<XMLAttributeInfo> iterator() {
        return this.attributes.iterator();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public void sort() {
        Collections.sort(this.attributes, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    public void setFeatureType(EditableFeatureType featureType) {
        this.featureType = featureType;
    }

    public EditableFeatureType getFeatureType() {
        return this.featureType;
    }
}

