#!/bin/bash

set -e

GVSIG_REPOSITORY="https://devel.gvsig.org/m2repo/j2se"

do_login() {
  if [ -n "$USERNAME" -a -n "$PASSWORD" ] ; then
     return
  fi
  USERNAME=$(zenity --password --username)
  if [ -z "$USERNAME" ] ; then
    exit 0
  fi
  PASSWORD="${USERNAME/*|/}"
  USERNAME="${USERNAME/|*/}"
}

do_deploy() {
  echo "Deploy"
  
  do_login
  
  curl -sf --insecure --user "${USERNAME}:${PASSWORD}" -X MKCOL "${GVSIG_REPOSITORY}/${gdal_groupId/./\/}/${gdal_artifactId}/${gdal_version}" >/dev/null 
  if [ "$?" != "0" -a "$?" != "22" ] ; then
    echo "Can't access to the repository for write."
    exit 1
  fi
  
  mvn deploy:deploy-file \
    -Durl=https://devel.gvsig.org/m2repo/j2se \
    -DrepositoryId=gvsig-repository \
    -DgroupId="${gdal_groupId}" \
    -DartifactId="${gdal_artifactId}" \
    -Dversion="${gdal_version}" \
    -Dpackaging=jar \
    -Dfile="${gdal_jar}" \
    -Ddescription="Binarios de GDAL."
       
  mvn deploy:deploy-file \
    -Durl=https://devel.gvsig.org/m2repo/j2se \
    -DrepositoryId=gvsig-repository \
    -DgroupId="${gdal_groupId}" \
    -DartifactId="${gdal_artifactId}" \
    -Dversion="${gdal_version}" \
    -Dpackaging=tar.gz \
    -Dclassifier="${gdal_classifier}" \
    -Dfile="../gdal-${gdal_version}-${gdal_classifier}.tar.gz"  \
    -Ddescription="Binarios de GDAL."  
    
}


do_package() {
  echo "Package"
  rm -f "../gdal-${gdal_version}-${gdal_classifier}.tar.gz"
  tar zcvf "../gdal-${gdal_version}-${gdal_classifier}.tar.gz" .
}


do_main() {
  cd $(dirname $0)

  . ./pack.cfg

  case "$1" in
  deploy)
    do_deploy
    ;;
  package)
    do_package
    ;;
  *)
    do_package
    do_deploy
    ;;
  esac
}


do_main



