package scripting;


import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

/**
 * Module with functions to show simple dialogs.
 *
 */
public class commonsdialog {

    /**
      * msgbox messagetypes
      */
    public static final int FORBIDEN = 0;
    public static final int IDEA = 1;
    public static final int WARNING = 2;
    public static final int QUESTION = 3;


    /**
      * Confirmdialog optionType Options
      */
    public static final int YES_NO = 0;
    public static final int YES_NO_CANCEL = 1;
    public static final int ACCEPT_CANCEL = 2;


    /**
      * Return values for confirmDialog
      */
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    /**
      * filechooser options
      */
    public static final int OPEN_FILE = 0;
    public static final int OPEN_DIRECTORY = 1;
    public static final int SAVE_FILE = 2;

    /**
      * filechooser selectionMode
      */
    public static final int FILES_ONLY = JFileChooser.FILES_ONLY;
    public static final int DIRECTORIES_ONLY = JFileChooser.DIRECTORIES_ONLY;

    /**
      * Shows a message dialog with ok button only.
      * <br>
      * Valid values for messageType are:<br>
      * <ul>
      *   <li>FORBIDEN</li>
      *   <li>IDEA</li>
      *   <li>WARNING</li>
      *   <li>QUESTION</li>
      * </ul>
      *
      * @param message
      * @param title, optional, title of the dialog
      * @param messageType, optional, default value is IDEA
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      *
     */
    public static void msgbox(String message, String title, int messageType, Component root) {

    }

    /**
      * Shows a dialog to request a input to the user.
      * <br>
      * Valid values for messageType are:<br>
      * <ul>
      *   <li>FORBIDEN</li>
      *   <li>IDEA</li>
      *   <li>WARNING</li>
      *   <li>QUESTION</li>
      * </ul>
      *
      * @param prompt
      * @param title, optional, title of the dialog
      * @param messageType, optional, default value is IDEA
      * @param initialValue, optional, default value is ""
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return the string value entered by the user or None.
      */
    public static String inputbox(String prompt, String title, int messageType, String initialValue, Component root) {
      return null;
    }

    /**
      * Shows a dialog to request to the user an answer of YES, NO or CANCEL.
      *
      * <br>
      * Valid values for optionType are:<br>
      * <ul>
      *   <li>YES_NO</li>
      *   <li>YES_NO_CANCEL</li>
      *   <li>ACCEPT_CANCEL</li>
      * </ul>
      * <br>
      * Valid values for messageType are:<br>
      * <ul>
      *   <li>FORBIDEN</li>
      *   <li>IDEA</li>
      *   <li>WARNING</li>
      *   <li>QUESTION</li>
      * </ul>
      *
      * @param prompt
      * @param title, optional, title of the dialog
      * @param optionType, optional, default value is YES_NO
      * @param messageType, optional, default value is IDEA
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return YES, NO, CANCEL.
      */
    public static int confirmDialog(String prompt, String title, int optionType, int messageType, JComponent root) {
	  return 0;
    }

    /**
      * Show an file or folder selector dialog.
      *
      * If multiselection is False, the default value, return the path-name of the
      * selected file or folder. If is True, return a list of the selecteds path-names.
      * <br>
      * Return None if the user cancel the action.
      * <br>
      * Valid values for mode are:<br>
      * <ul>
      *   <li>FILES_ONLY</li>
      *   <li>DIRECTORIES_ONLY</li>
      * </ul>
      *
      * @param mode
      * @param title, optional, title of the dialog
      * @param initialPath, optional, default value is None
      * @param multiselection, optional, default value is False
      * @param filter, optional, default value is None
      * @param fileHidingEnabled, optional, default value is True
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return the pathnames selected or None if user cancel.
      */
    public static String[] filechooser(int mode, String title, String initialPath,
       boolean multiselection, String filter, boolean fileHidingEnabled, Component root) {
	  return null;
    }


    /**
      * Show a selector dialog for choose a file for reading.
      * <br>
      * This is a utility function that call to filechooser.
      * <br>
      * Return None if the user cancel the action.
      *
      * @param title, optional, title of the dialog
      * @param initialPath, optional, default value is None
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return the pathnames selected or None if user cancel.
      */
    public static String[] openFileDialog(String title, String initialPath, Component root) {
	return null;
    }

    /**
      * Show a selector dialog for choose a folder.
      * <br>
      * This is a utility function that call to filechooser.
      * <br>
      * Return None if the user cancel the action.
      *
      * @param title, optional, title of the dialog
      * @param initialPath, optional, default value is None
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return the pathnames selected or None if user cancel.
      */
    public static String[] openFolderDialog(String title, String initialPath, Component root) {
	return null;
    }

    /**
      * Show a selector dialog for choose a file for writing.
      * <br>
      * This is a utility function that call to filechooser.
      * <br>
      * Return None if the user cancel the action.
      *
      * @param title, optional, title of the dialog
      * @param initialPath, optional, default value is None
      * @param root, optional, parent Component for this dialog, default values is gvSIG main window.
      * @return the pathnames selected or None if user cancel.
      */
    public static String[] saveFileDialog(String title, String initialPath, Component root) {
	return null;
    }

}
