package scripting.dal;

import org.gvsig.fmap.geom.Geometry;

public interface EditableFeature extends org.gvsig.fmap.dal.feature.EditableFeature { 


  /**
   * Gets the value of the default attribute to store the geometry. 
   *
   */
  public Geometry geometry() ;


  /**
   * Create and return a dict and fill it with the name/values of the attributes.
   *
   */
  public dict getValues() ;
  
  /**
   * Enable the edit mode in this feature.
   *
   * @deprecated can't use this method, is not jet implemented. Use getEditable instead.
   */
  public void edit() ;
  
  /**
   * Gets the value of the attribute name of the feature. 
   *
   * This method allow to treat a Feature as a dict.
   *
   * @param name of the atttribute to get
   *
   */
  public void __getitem__(String name) ;

  /**
   * Returns the java object associated to this python object. 
   * With the current implementation this is not necessary, don't
   * use now python wrappers for java objects.
   *
   * @deprecated this method now return self alwais.
   *
   */
  public void __call__() ;


  /**
   * Gets the number of attributes of the feature. 
   *
   * This method allow to use "len(feature)"
   *
   */
  public void __len__() ;

  /**
   * Allow to iterate ower the name/values of the attributes of the feature. 
   *
   */
  public Generator iteritems() ;

  /**
   * Allow to iterate ower the values of the attributes of the feature. 
   *
   */
  public Generator itervalues() ;

  /**
   * Allow to iterate ower the names of the attributes of the feature. 
   *
   */
  public Generator iterkeys() ;
  
  /**
   * Sets the geomtry asociated to the attribute name. 
   *
   * @param name of the atttribute to set
   * @param value geomtry to set in the attribute name
   *
   */
  public void setGeometry(String name, Geometry value) ;

  /**
   * Sets the geomtry asociated to the attribute name. 
   *
   * @param value geomtry to set in the default attribute for the geometry
   *
   */
  public void setGeometry(Geometry value) ;

  /**
   * Assing the values passed as parameters to the feature.
   *
   * If parameters are passed as postion ara assigned in that order
   * to the attributes of the features.
   *
   * If parameters are passed by name ara assigned to the attributes
   * of the feature by this name.
   *
   */
  public void setValues(Object...values) ;
  
  /**
   * Sets value of the attribute name. 
   *
   * @param name of the atttribute to set
   * @param value to set in the attribute name
   *
   */
  public void __setitem__(String name, Object value) ;

  /**
   * Sets value of the attribute name. 
   *
   * @param name of the atttribute to set
   * @param value to set in the attribute name
   *
   */
  public void __setattr__(String name, Object value) ;

}