
#=================================================
#
# Metodo de utilidad para recibir notificaciones cuando
# se anada una capa al proyecto.
#
# Para usarlo:
#
# layerAdded_addListener(func)
#
# Cada vez que se anada una capa al proyecto se invocara
# a la funcion "func" pasandole como parametro la capa
# que ha sido anadida.
#
#




from org.gvsig.fmap.mapcontrol import MapControlLocator
from org.gvsig.fmap.mapcontrol import MapControlCreationListener
from org.gvsig.fmap.mapcontext.layers import LayerCollectionListener


class _LayerAddedListener(MapControlCreationListener,LayerCollectionListener):
  def __init__(self, callable):
    self.callable = callable

  def mapControlCreated(self, mapControl):
    try:
      self.counter +=1
      layers = mapControl.getMapContext().getLayers()
      if layers != None:
        layers.addLayerCollectionListener(self)
    except Exception,ex:
      print "Error in mapcontrolcreated "+ str(ex)
    return mapControl

  def layerAdded(self, e):
    try:
      self.callable(e.getAffectedLayer())
    except Exception,ex:
      print "Error in layerAdded "+ str(ex)

  def layerAdding(self, e):
    pass

  def layerMoved(self, e):
    pass

  def layerMoving(self, e):
    pass

  def layerRemoved(self, e):
    pass

  def layerRemoving(self, e):
    pass

  def visibilityChanged(self, e):
    pass


def layerAdded_addListener(func):
  mapControlManager = MapControlLocator.getMapControlManager()
  mapControlManager.addMapControlCreationListener(_LayerAddedListener(func))

def layerAdded_removeListener(func):
  pass



#def myListener(layer):
#  print "Layer '%s' anadida a una vista."  % layer.getName()

def main(*args):
  #addListener_layerAdded(myListener)
  pass

