# encoding: utf-8

import gvsig
from gvsig import commonsdialog

from java.awt import Color

"""
Este script se recorre todas la features de la capa activa, y asumiendo
que tiene un campo ELEVATION, calcula la elevacion maxima y minima de 
estas, y con esto:
- Presentar un mensaje al usuario informando de cuales son
- Seleccionar las geometrias asociadas a la elevacion maxima y minima vista.
- Pone un punto en el centro de las geometrias de elevacion maxima y minima.

En la carpeta data puede encontrar la capa polygons_with_elevation usada
para realizar las pruebas con este scripts.
"""

def main(): 
  """
  This script runs all the features of the active layer, and calculates the 
  maximum and minimum elevation these, and with this:
    - Shows a message informing the user which are
    - Select the geometries associated with maximum and minimum elevation. 
    - Shows maximum and minimum elevation geometries centroid in the view 
      graphicsLayer
  
  If no ELEVATION field shows a message and finish script execution.
  
  In the data folder can be found cv05_3d_polygons layer used
  for testing with this script.
  """
  #
  #Invoke gvsig.currentLayer function to get active layer
  #If not view or active layer in view raise RuntimeException
  layer = gvsig.currentLayer()
  
  #
  #Invoke layer.getSchema method to get layer definition data 
  schema = layer.getSchema()
  
  #
  #Invoke schema.get method to get ELEVATION field or None
  field = schema.get('ELEVATION', None)
  
  #
  #Check if field exist
  if not field:
      #If not shows message and finish
      text = '"ELEVATION" field must exist in the active layer.\nFinish script'
      title = "ERROR"
      message_type = commonsdialog.WARNING
      commonsdialog.msgbox(text, title, message_type)
      return
      
  acetato = gvsig.currentView().getGraphicsLayer()
  acetato.removeGraphics("example")
  smax = acetato.addSymbol(gvsig.utils.simplePointSymbol(Color.RED))
  smin = acetato.addSymbol(gvsig.utils.simplePointSymbol(Color.BLUE))
  
  emax = 0.0
  emin = 0.0
  fmax = None
  fmin = None

  #
  # Gets features using layer.features method
  features = layer.features()
  
  #
  #Runs layer features
  for feature in features:
    # 
    # Cheacks if current feature ELEVATION is higher than calculated. 
    # If so, stored current ELEVATION value and the feature instance
    if feature.ELEVATION > emax :
        emax = feature.ELEVATION
        fmax = feature.getCopy()
      
    # Same but with minimum ELEVATION
    if feature.ELEVATION < emin or emin ==0.0:
        emin = feature.ELEVATION
        fmin = feature.getCopy()
  #
  # Selects features in the layer.
  if fmax!=None:
    layer.select(fmax)
    #
    # gets geometry centroid to put our point with a label
    point = fmax.geometry().centroid()
    #
    # Adds to graphicsLayer the point and symbol with label
    acetato.addGraphic("example", point, smax, "Maximun Elevation")

  if fmin!=None:
    layer.getSelection().select(fmin)
    punto = fmax.geometry().centroid()
    acetato.addGraphic("example", punto, smin,"Minimun Elevation")

  #
  # Finally show results in a msgbox message.
  text = "Maximum Elevation=%s, Minumun Elevation=%s" % (emax, emin)
  title = "Maximun and minumum values"
  message_type = commonsdialog.IDEA
  
  commonsdialog.msgbox(text, title, message_type)

