# encoding: utf-8

import gvsig
from gvsig import currentView
from gvsig import createFeatureType
from gvsig.geom import POINT, D2, createPoint
from gvsig import createShape

import random

def createPointLayer():
  #
  # Vamos a crear los puntos sobre el area representada en la vista.
  # usaremos la funcion random.randint de python, que solo usa enteros
  # y devuelbe enteros, asi que usaremos valores decimales con tres
  # decimanes representandolos como de coma fija en un entero.
  # 
  # 1.123 ===> 1123 
  #
  # Y cuando vayamos a crear los puntos con esos valores los volveremos
  # a transformar en decimales dividienlos por 1000.0
  #
  
  #
  # Para eso, lo primero obtendremos el Envelope de la vista
  envelope = currentView().getMapContext().getViewPort().getEnvelope()

  #
  # Calculamos los valores maximos y minimos de las coordenadas de
  # ese envelope como valores con tres decimales en coma fija representados
  # en un entero.
  #  
  minx = int(envelope.getMinimum(0) * 1000)
  maxx = int(envelope.getMaximum(0) * 1000)
  miny = int(envelope.getMinimum(1) * 1000)
  maxy = int(envelope.getMaximum(1) * 1000)
  
  print minx, maxx
  print miny, maxy

  #
  # Creamos un shape con solo un campo geometria de tipo
  # punto 2D
  schema = createFeatureType() # DefaultFeatureType
  schema.append("GEOMETRY", "GEOMETRY")
  schema.get("GEOMETRY").setGeometryType(POINT, D2)
  puntos = createShape(schema, prefixname="puntos")

  # 
  # Ponemos en edicion el nuevo shape vacio
  puntos.edit()
  
  # Vamos a crear 20 puntos
  for x in range(20):
    #
    # Calculamos la x e y y la dividimos por 1000.0
    # para pasarla a double.
    x = random.randint(minx, maxx)/1000.0
    y = random.randint(miny, maxy)/1000.0
    # Creamos el punto
    point = createPoint(D2,x,y)
    # Lo añadimos a la capa de puntos
    puntos.append( { "GEOMETRY": point } )
  
  #
  # Cuando hemos añadido todos los puntos terminamos la edicion
  puntos.finishEditing()
  
  # Por ultimo añadiremos la capa a la vista
  currentView().addLayer(puntos)
  
  # Y mostraremos por consola la ruta en la que se ha creado la capa
  print puntos.getDataStore().getFullName()
  
  return puntos
  
def main(*args):
  createPointLayer()
  