/*
 * Copyright (C) 2005 Jeff Tassin
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.jeta.swingbuilder.resources;

/**
 * This class provides icon definitions for the application.
 * 
 * @author Jeff Tassin
 */
public class Icons {

	// development
	public static final String APPLICATION_16 = "development/16x16/application.png";
	public static final String BEAN_16 = "development/16x16/bean.png";
	public static final String BORDER_16 = "development/16x16/border.png";
	public static final String COMPONENT_16 = "development/16x16/web_component.png";
	public static final String GENERIC_COMPONENT_16 = "development/16x16/generic_component.png";
	public static final String FONT_16 = "development/16x16/font.png";
	public static final String USER_16 = "development/16x16/user.png";

	public static final String NEW_PROJECT_24 = "development/24x24/new_project.png";
	public static final String OPEN_PROJECT_24 = "development/24x24/open_project.png";

	// forms
	public static final String BUTTON_16 = "forms/16x16/button.png";
	public static final String CHECK_16 = "forms/16x16/check.png";
	public static final String COMBO_16 = "forms/16x16/combo.png";
	public static final String EMBEDDED_FORM_16 = "forms/16x16/embedded_form.png";
	public static final String FORMATTED_FIELD_16 = "forms/16x16/formatted_field.png";
	public static final String HORIZONTAL_LINE_16 = "forms/16x16/palette_hline16.gif";
	public static final String JGOODIES_SEPARATOR_16 = "forms/16x16/palette_jgoodies_separator.gif";
	public static final String LABEL_16 = "forms/16x16/palette_label16.gif";
	public static final String LINKED_FORM_16 = "forms/16x16/linked_form.png";
	public static final String LIST_16 = "forms/16x16/text_list.png";
	public static final String MOUSE_16 = "forms/16x16/palette_mouse.gif";
	public static final String PALETTE_16 = "forms/16x16/palette.png";
	public static final String PASSWORD_FIELD_16 = "forms/16x16/password_field.png";
	public static final String PROGRESS_BAR_16 = "forms/16x16/progress_bar.png";
	public static final String RADIO_16 = "forms/16x16/radio.png";
	public static final String RICH_TEXT_16 = "forms/16x16/text_rich_colored.png";
	public static final String SCROLL_BARS_16 = "forms/16x16/scroll_bars.png";
	public static final String SLIDER_16 = "forms/16x16/slider.png";
	public static final String SPINNER_16 = "forms/16x16/spinner.png";
	public static final String TABLE_CELL_16 = "forms/16x16/table_cell.png";
	public static final String TABPANE_16 = "forms/16x16/tabpane.png";
	public static final String TEXT_FIELD_16 = "forms/16x16/text_field.png";
	public static final String TITLE_BORDER_LABEL_16 = "forms/16x16/palette_border_label.gif";
	public static final String TITLE_BORDER_BOTTOM_16 = "forms/16x16/palette_border_bottom.gif";
	public static final String TITLE_BORDER_SIDE_16 = "forms/16x16/palette_border_side.gif";
	public static final String TEXT_16 = "forms/16x16/text.png";
	public static final String TREE_16 = "forms/16x16/text_tree.png";
	public static final String TOGGLE_BUTTON_16 = "forms/16x16/toggle_button.png";
	public static final String VERTICAL_LINE_16 = "forms/16x16/palette_vline16.gif";

	// general
	public static final String COLOR_WELL_16 = "general/16x16/color_well.png";
	public static final String DELETE_16 = "general/16x16/delete.png";
	public static final String DELETE2_16 = "general/16x16/delete2.png";
	public static final String EDIT_16 = "general/16x16/edit.png";
	public static final String NEW_16 = "general/16x16/new.png";
	public static final String OPEN_16 = "general/16x16/open.png";
	public static final String PAINT_BRUSH_16 = "general/16x16/brush.png";
	public static final String PORTRAIT_16 = "general/16x16/portrait.png";
	public static final String REFRESH_16 = "general/16x16/refresh.png";
	public static final String WINDOW_CLOSE_16 = "general/16x16/window_close.png";
	public static final String WINDOWS_16 = "general/16x16/windows.png";
	public static final String SPLIT_WINDOWS_16 = "general/16x16/split_windows.png";

	public static final String ADD_24 = "general/24x24/add.png";
	public static final String COPY_24 = "general/24x24/copy.png";
	public static final String CUT_24 = "general/24x24/cut.png";
	public static final String OPEN_24 = "general/24x24/open.png";
	public static final String PASTE_24 = "general/24x24/paste.png";
	public static final String REDO_24 = "general/24x24/redo.png";
	public static final String SAVE_24 = "general/24x24/save.png";
	public static final String UNDO_24 = "general/24x24/undo.png";

	// media
	public static final String PLAY_24 = "media/24x24/play.png";

	// navigation
	public static final String DOWN_16 = "navigation/16x16/down.png";
	public static final String UP_16 = "navigation/16x16/up.png";

	// table
	public static final String CELL_16 = "table/16x16/table_cell.png";
	public static final String COLUMN_16 = "table/16x16/column.png";
	public static final String ROW_16 = "table/16x16/row.png";
	public static final String TABLE_16 = "table/16x16/table.png";

	public static final String COLUMN_DECREASE_SPAN_24 = "table/24x24/column_decrease_span.png";
	public static final String COLUMN_DELETE_24 = "table/24x24/column_delete.png";
	public static final String COLUMN_GROW_24 = "table/24x24/column_grow.png";
	public static final String COLUMN_INCREASE_SPAN_24 = "table/24x24/column_increase_span.png";
	public static final String COLUMN_INSERT_24 = "table/24x24/column_insert.png";
	public static final String COLUMN_NOGROW_24 = "table/24x24/column_nogrow.png";
	public static final String COLUMN_SEP_LARGE_24 = "table/24x24/column_sep_large.png";
	public static final String COLUMN_SEP_SMALL_24 = "table/24x24/column_sep_small.png";

	public static final String ROW_DECREASE_SPAN_24 = "table/24x24/row_decrease_span.png";
	public static final String ROW_DELETE_24 = "table/24x24/row_delete.png";
	public static final String ROW_GROW_24 = "table/24x24/row_grow.png";
	public static final String ROW_INCREASE_SPAN_24 = "table/24x24/row_increase_span.png";
	public static final String ROW_INSERT_24 = "table/24x24/row_insert.png";
	public static final String ROW_NOGROW_24 = "table/24x24/row_nogrow.png";
	public static final String ROW_SEP_LARGE_24 = "table/24x24/row_sep_large.png";
	public static final String ROW_SEP_SMALL_24 = "table/24x24/row_sep_small.png";

}
