/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;

public class BeanMemento
extends ComponentMemento {
    static final long serialVersionUID = -92122133275350884L;
    public static final int VERSION = 2;
    private String m_jetabean_class;
    private String m_bean_class;
    private PropertiesMemento m_properties;
    private byte[] m_bean_xml;
    private Collection m_custom_properties;

    public boolean containsProperty(String propName) {
        if (this.m_properties != null) {
            return this.m_properties.containsProperty(propName);
        }
        return false;
    }

    public Collection getCustomProperties() {
        return this.m_custom_properties;
    }

    public String getJETABeanClass() {
        return this.m_jetabean_class;
    }

    public String getBeanClass() {
        return this.m_bean_class;
    }

    public byte[] getBeanXML() {
        return this.m_bean_xml;
    }

    public PropertiesMemento getProperties() {
        return this.m_properties;
    }

    public void print() {
        System.out.println("     BeanMemento state.................. ");
        System.out.println("           jetabean: " + this.m_jetabean_class);
        System.out.println("           bean_class: " + this.m_bean_class);
    }

    public void setCustomProperties(Collection props) {
        this.m_custom_properties = props;
    }

    public void setBeanClass(String beanClass) {
        this.m_bean_class = beanClass;
    }

    public void setJETABeanClass(String className) {
        this.m_jetabean_class = className;
    }

    public void setBeanXML(byte[] xml) {
        this.m_bean_xml = xml;
    }

    public void setProperties(PropertiesMemento props) {
        this.m_properties = props;
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_jetabean_class = in.readString("jetabeanclass");
        this.m_bean_class = in.readString("beanclass");
        if (version == 1) {
            this.m_bean_xml = (byte[])in.readObject("bean_xml");
            this.m_custom_properties = (Collection)in.readObject("custom_properties");
            this.m_properties = null;
        } else {
            Object props = in.readObject("beanproperties");
            if (props instanceof byte[]) {
                ByteArrayInputStream bis = new ByteArrayInputStream((byte[])props);
                ObjectInputStream ois = new ObjectInputStream(bis);
                this.m_properties = (PropertiesMemento)ois.readObject();
            } else if (props instanceof PropertiesMemento) {
                this.m_properties = (PropertiesMemento)props;
            }
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(ComponentMemento.class));
        out.writeVersion(2);
        out.writeObject("jetabeanclass", this.m_jetabean_class);
        out.writeObject("beanclass", this.m_bean_class);
        out.writeObject("beanproperties", this.m_properties);
    }
}

