/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectEncoder;
import org.gvsig.tools.util.Invocable;

public class SimpleDynObjectEncoder
implements DynObjectEncoder {
    @Override
    public String encode(DynObject value) {
        return this.encode(value, "UTF-8", null);
    }

    @Override
    public String encode(DynObject value, String charset) {
        return this.encode(value, "UTF-8", null);
    }

    @Override
    public String encode(DynObject value, String charset, Invocable transform) {
        DynClass definition = value.getDynClass();
        StringBuilder builder = new StringBuilder();
        builder.append(this.encodePair("_entity_", definition.getFullName(), charset));
        for (DynField field : definition.getDynFields()) {
            String name = field.getName();
            Object v0 = value.getDynValue(name);
            builder.append(",");
            if (transform != null) {
                v0 = transform.call(name, v0);
            }
            builder.append(this.encodePair(name, v0, charset));
        }
        return builder.toString();
    }

    @Override
    public DynObject decode(String value) {
        String[] entries = value.split(",");
        if (entries == null || entries.length < 1) {
            return null;
        }
        String[] entryEntity = entries[0].split(":");
        String entityName = this.decodeValue(entryEntity[1].trim());
        DynObject output = ToolsLocator.getDynObjectManager().createDynObject(entityName);
        return this.decode(value, output, entries, "UTF-8");
    }

    @Override
    public DynObject decode(String value, DynObject output) {
        return this.decode(value, output, "UTF-8");
    }

    @Override
    public DynObject decode(String value, DynObject output, String charset) {
        String[] entries = value.split(",");
        if (entries == null || entries.length < 1) {
            return null;
        }
        return this.decode(value, output, entries, "UTF-8");
    }

    protected DynObject decode(String value, DynObject output, String[] entries, String charset) {
        DynClass definition = output.getDynClass();
        block8: for (String entry : entries) {
            String[] entryPair = entry.split(":");
            DynField field = definition.getDynField(entryPair[0]);
            if (field == null) continue;
            String name = entryPair[0];
            String v0 = entryPair.length == 2 ? entryPair[1] : null;
            switch (field.getType()) {
                case 15: {
                    DynObject v1 = this.decode(this.decodeValue(v0, charset));
                    output.setDynValue(name, v0);
                    continue block8;
                }
                case 33: {
                    continue block8;
                }
                case 34: {
                    continue block8;
                }
                case 35: {
                    continue block8;
                }
                case 36: {
                    continue block8;
                }
                case 64: {
                    continue block8;
                }
                default: {
                    output.setDynValue(name, this.decodeValue(v0, charset));
                }
            }
        }
        return output;
    }

    @Override
    public String encodePair(String name, Object value) {
        return this.encodePair(name, value, "UTF-8");
    }

    @Override
    public String encodePair(String name, Object value, String charset) {
        if (value == null) {
            return name + ":";
        }
        if (value instanceof DynObject) {
            return name + ":" + this.encodeValue(this.encode((DynObject)value, charset));
        }
        if (value instanceof List) {
            return name + ":";
        }
        if (value instanceof Map) {
            return name + ":";
        }
        if (value instanceof Set) {
            return name + ":";
        }
        if (value.getClass().isArray()) {
            return name + ":";
        }
        return name + ":" + this.encodeValue(value.toString(), charset);
    }

    @Override
    public String encodeValue(String value) {
        return this.encodeValue(value, "UTF-8");
    }

    @Override
    public String encodeValue(String value, String charset) {
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value.replace(",", "%2C");
        }
    }

    @Override
    public String decodeValue(String value) {
        return this.decodeValue(value, "UTF-8");
    }

    @Override
    public String decodeValue(String value, String charset) {
        try {
            if (value == null) {
                return null;
            }
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value.replace("%2C", ",");
        }
    }
}

