/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.packageutils.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.packageutils.PackageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageInfoFileReader {
    private static final Logger logger = LoggerFactory.getLogger(PackageInfoFileReader.class);

    public void read(PackageInfo packageInfo, String fileName) throws IOException, FileNotFoundException {
        this.read(packageInfo, new File(fileName));
    }

    public void read(PackageInfo packageInfo, File file) throws IOException, FileNotFoundException {
        this.read(packageInfo, new FileInputStream(file));
    }

    public void read(PackageInfo packageInfo, InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        is.close();
        this.read(packageInfo, properties);
    }

    public void read(PackageInfo packageInfo, Properties properties) {
        packageInfo.setCode(properties.getProperty("code"));
        String codealias1 = properties.getProperty("code-alias");
        if (codealias1 != null) {
            String[] s = codealias1.split(",");
            for (int i = 0; i < s.length; ++i) {
                s[i] = s[i].trim();
                if ("".equals(s[i])) continue;
                packageInfo.getAllCodes().add(s[i]);
            }
        }
        packageInfo.setName(properties.getProperty("name"));
        String pkgName = packageInfo.getName();
        packageInfo.setDescription(properties.getProperty("description"));
        packageInfo.getVersion().parse(properties.getProperty("version"));
        String build = properties.getProperty("buildNumber");
        if (build != null) {
            try {
                int buildNumber = Integer.parseInt(build);
                packageInfo.getVersion().setBuild(buildNumber);
            }
            catch (Exception buildNumber) {
                // empty catch block
            }
        }
        packageInfo.setType(properties.getProperty("type"));
        packageInfo.setState(properties.getProperty("state"));
        packageInfo.setOfficial(Boolean.valueOf(properties.getProperty("official")));
        packageInfo.setOperatingSystem(properties.getProperty("operating-system"));
        packageInfo.setArchitecture(properties.getProperty("architecture"));
        packageInfo.setJavaVM(properties.getProperty("java-version"));
        String value = properties.getProperty("application-version");
        if (value == null) {
            value = properties.getProperty("gvSIG-version");
        }
        packageInfo.getApplicationVersion().parse(value);
        packageInfo.setDownloadURL(properties.getProperty("download-url"));
        packageInfo.setModelVersion(properties.getProperty("model-version"));
        packageInfo.setOwner(properties.getProperty("owner"));
        packageInfo.setDependencies(properties.getProperty("dependencies"));
        packageInfo.setSourcesURL(this.getUrl(properties, "sources-url", pkgName));
        packageInfo.setWebURL(this.getUrl(properties, "web-url", pkgName));
        packageInfo.setOwnerURL(this.getUrl(properties, "owner-url", pkgName));
        packageInfo.addCategoriesAsString(properties.getProperty("categories"));
    }

    private URL getUrl(Properties properties, String name, String pkgName) {
        String s = properties.getProperty(name);
        if (!StringUtils.isBlank((CharSequence)s)) {
            URL url;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e) {
                logger.info("Malformed url for '" + name + "' in package '" + pkgName + "', url='" + s + "'.");
                return null;
            }
            return url;
        }
        return null;
    }
}

