/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api.viewer;

import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJViewer<T>
implements JViewer<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJViewer.class);
    private final ViewerFactory<T> factory;

    protected AbstractJViewer(ViewerFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public void setContents(T data) {
        if (data == null) {
            this.clean();
            return;
        }
        throw new IllegalArgumentException("Data type '" + data.getClass().getSimpleName() + "' not supported.");
    }

    @Override
    public T getContents() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return this.factory.isEditable();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getMimetype() {
        return this.factory.getMimetype();
    }

    @Override
    public ViewerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void clean() {
    }
}

