/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.persistence.serverData;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class ServerDataPersistence
implements Persistent,
Comparable<ServerDataPersistence> {
    public static final String PERSISTENT_NAME = "ServerDataList_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "ServerDataList Persistent";
    private String serviceType = null;
    private List<ServerData> serverList = null;

    public ServerDataPersistence(String serviceType) {
        this.serviceType = serviceType;
        this.serverList = new ArrayList<ServerData>();
    }

    public ServerDataPersistence() {
        this.serverList = new ArrayList<ServerData>();
        this.serviceType = "UNKNOW";
    }

    public void addServerData(ServerData server) {
        String address = server.getServerAddress();
        for (int i = 0; i < this.serverList.size(); ++i) {
            ServerData sd = this.serverList.get(i);
            if (!sd.getServerAddress().equals(address)) continue;
            this.serverList.set(i, server);
            return;
        }
        this.serverList.add(server);
    }

    public boolean existsServer(String address) {
        return this.contains(address);
    }

    public ServerData[] getArrayOfServerData() {
        return this.serverList.toArray(new ServerData[this.serverList.size()]);
    }

    public List<ServerData> getServerData() {
        return this.serverList;
    }

    public void setArrayOfServerData(ServerData[] servers) {
        if (servers != null) {
            this.serverList = Arrays.asList(servers);
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("serverData", (Object[])this.getArrayOfServerData());
        state.set("serviceType", this.serviceType);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        if (state.get("serverData") instanceof List) {
            this.serverList = (List)state.get("serverData");
        }
        this.serviceType = state.getString("serviceType");
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(ServerDataPersistence.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
        }
        definition.addDynFieldList("serverData").setClassOfItems(ServerData.class).setMandatory(false);
        definition.addDynFieldString("serviceType").setMandatory(true);
    }

    @Override
    public int compareTo(ServerDataPersistence a) {
        if (a.getServiceType().equals(this.getServiceType())) {
            if (this.getServerData().size() != a.getServerData().size()) {
                return -1;
            }
            for (int i = 0; i < this.getServerData().size(); ++i) {
                ServerData serverData = this.getServerData().get(i);
                if (a.existsServer(serverData.getServerAddress())) continue;
                return -1;
            }
        }
        return 0;
    }

    public boolean isEmpty() {
        if (this.serverList == null) {
            return true;
        }
        return this.serverList.isEmpty();
    }

    public void remove(String serverAddress) {
        if (StringUtils.isBlank((CharSequence)serverAddress)) {
            return;
        }
        Iterator<ServerData> it = this.getServerData().iterator();
        while (it.hasNext()) {
            ServerData x = it.next();
            if (!serverAddress.equalsIgnoreCase(x.getServerAddress())) continue;
            it.remove();
            return;
        }
    }

    public void add(String server, String protocol) {
        if (StringUtils.isBlank((CharSequence)server)) {
            return;
        }
        this.add(new ServerData(server, protocol));
    }

    public void add(ServerData server) {
        String address = server.getServerAddress().trim();
        for (int i = 0; i < this.getServerData().size(); ++i) {
            ServerData sd = this.getServerData().get(i);
            if (!sd.getServerAddress().trim().equals(address)) continue;
            this.getServerData().set(i, server);
            return;
        }
        this.getServerData().add(server);
    }

    public boolean contains(String serverAddress) {
        if (StringUtils.isBlank((CharSequence)serverAddress)) {
            return false;
        }
        serverAddress = serverAddress.trim();
        for (int i = 0; i < this.getServerData().size(); ++i) {
            String address = this.getServerData().get(i).getServerAddress().trim();
            if (!serverAddress.equalsIgnoreCase(address)) continue;
            return true;
        }
        return false;
    }
}

