/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class FileFunction
extends AbstractFunction {
    public static final String NAME = "FILE";

    public FileFunction() {
        super("Programming", NAME, Range.is((Comparable)Integer.valueOf(1)), null, "FILE({{expression}})", null, "Object", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object obj = this.getObject(args, 0);
        File value = FileFunction.toFile(obj);
        return value;
    }

    public static File toFile(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof CharSequence) {
            return new File(((CharSequence)obj).toString());
        }
        if (obj instanceof URI) {
            return new File((URI)obj);
        }
        if (obj instanceof URL) {
            return new File(((URL)obj).getPath());
        }
        throw new ExpressionRuntimeException("The FILE function require a File or a String and a received a '" + obj.getClass().getSimpleName() + "'.");
    }
}

