/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ReverseInStrFunction
extends AbstractFunction {
    public ReverseInStrFunction() {
        super("String", "REVERSEINSTR", Range.is((Comparable)Integer.valueOf(2)), "Returns the index (position) of the last occurrence of a specified substring in a string.", "REVERSEINSTR({{string}}, substring)", new String[]{"string - String in which to perform the search. ", "substring - String to search"}, "Integer", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String string = this.getStr(args, 0);
        String substring = this.getStr(args, 1);
        if (string == null || substring == null) {
            return null;
        }
        int n = string.lastIndexOf(substring);
        if (n < 0) {
            return 0;
        }
        return n + 1;
    }
}

