/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.types;

import com.sardak.antform.gui.ControlPanel;
import com.sardak.antform.interfaces.ActionListenerComponent;
import com.sardak.antform.types.DefaultProperty;
import com.sardak.antform.util.CSVReader;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.tools.ant.Task;

public class SelectionProperty
extends DefaultProperty
implements ActionListenerComponent {
    private String values;
    private String separator = ",";
    private String escapeSequence = "\\";
    private String[] splitValues = null;
    private JComboBox comboBox;

    public void setEscapeSequence(String escapeSequence) {
        this.escapeSequence = escapeSequence;
    }

    public String getEscapeSequence() {
        return this.escapeSequence;
    }

    public String[] getSplitValues() {
        if (this.splitValues == null) {
            this.split();
        }
        return this.splitValues;
    }

    public void setSplitValues(String[] splitValues) {
        this.splitValues = splitValues;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getValues() {
        return this.values;
    }

    private void split() {
        CSVReader reader = new CSVReader(this.separator, this.escapeSequence);
        List valueList = reader.digest(this.values, true);
        this.splitValues = valueList.toArray(new String[valueList.size()]);
    }

    public void setValues(String values) {
        this.values = values;
    }

    public void addToControlPanel(ControlPanel panel) {
        this.comboBox = new JComboBox<String>(this.getSplitValues());
        this.comboBox.setEnabled(this.isEditable());
        panel.getStylesheetHandler().addComboBox(this.comboBox);
        this.initComponent(this.comboBox, panel);
    }

    public boolean validate(Task task) {
        return this.validate(task, "SelectionProperty");
    }

    public boolean validate(Task task, String widget) {
        boolean isValid = super.validate(task, widget);
        if (this.getValues() == null) {
            task.log(widget + " : attribute \"values\" missing.");
            isValid = false;
        }
        return isValid;
    }

    public void ok() {
        this.getProject().setProperty(this.getProperty(), this.comboBox.getSelectedItem().toString());
    }

    public void reset() {
        if (this.isValidValue(this.getCurrentProjectPropertyValue())) {
            this.comboBox.setSelectedItem(this.getCurrentProjectPropertyValue());
        } else {
            this.comboBox.setSelectedIndex(0);
        }
    }

    protected boolean isValidValue(String s) {
        boolean isValidValue = false;
        for (int i = 0; i < this.getSplitValues().length; ++i) {
            if (!this.getSplitValues()[i].equals(s)) continue;
            isValidValue = true;
            break;
        }
        return isValidValue;
    }

    public JComponent getFocusableComponent() {
        return this.comboBox;
    }
}

