/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import org.gvsig.tools.swing.api.FilteredModel;
import org.gvsig.tools.swing.api.FilteredTreeController;
import org.gvsig.tools.swing.api.FilteredTreeModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.TreeModelRecursiveWildcarMatchFilter;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.FilteredTreeModelImpl;

public class DefaultFilteredTreeController
implements FilteredTreeController {
    private final JTree tree;
    private final JTextComponent text;
    private final JButton button;

    public DefaultFilteredTreeController(JTree tree, JTextComponent text, JButton button) {
        this.tree = tree;
        this.text = text;
        this.button = button;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        FilteredTreeModel model = this.createModel(this.tree);
        this.tree.setModel((TreeModel)model);
        toolsSwingManager.addClearButton(this.text, e -> {
            this.text.setText("");
            this.clearFilter();
        });
        toolsSwingManager.setDefaultPopupMenu(this.text);
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DefaultFilteredTreeController.this.setFilter(DefaultFilteredTreeController.this.text.getText());
                }
            }
        });
        this.button.setIcon(this.getIcon("common-filter"));
        if (this.button.getText().equals("...")) {
            this.button.setText("");
        }
        this.button.addActionListener(e -> this.setFilter(this.text.getText()));
    }

    protected ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    public FilteredTreeModel createModel(JTree tree) {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        FilteredTreeModel model = toolsSwingManager.createFilteredTreeModel(tree);
        return model;
    }

    public FilteredTreeModel getModel() {
        return (FilteredTreeModel)this.tree.getModel();
    }

    public void setModel(TreeModel model) {
        if (!(model instanceof FilteredTreeModel)) {
            model = new FilteredTreeModelImpl((TreeModel)model);
        }
        this.tree.setModel((TreeModel)model);
    }

    public void clearFilter() {
        this.getModel().setFilter(null);
    }

    public void setFilter(String filter) {
        this.getModel().setFilter(filter);
    }

    public void setFilter(FilteredModel.FilterFunction filter) {
        if (filter == null) {
            filter = new TreeModelRecursiveWildcarMatchFilter(this.getModel());
        }
        this.getModel().setFilterFunction(filter);
    }
}

