/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.dynclass.DynFieldView;
import org.gvsig.tools.swing.impl.dynclass.DynObjectValueItemControler;
import org.gvsig.tools.swing.impl.dynclass.SwingHelper;
import org.gvsig.tools.swing.impl.dynclass.TagsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynFieldControler
extends DynFieldView {
    private static final Logger logger = LoggerFactory.getLogger(DynFieldControler.class);
    private static final long serialVersionUID = 4237329387535520828L;
    private final TagsHelper tags;
    private final WindowManager_v2 windowManager;
    private List<DynObjectValueItem> availableValues;

    public DynFieldControler(WindowManager_v2 windowManager) {
        this.tags = new TagsHelper(windowManager);
        this.windowManager = windowManager;
        this.initComponents();
    }

    private void initComponents() {
        this.tags.bind(this.tblTags, this.btnDeleteTag, this.btnAddTag, this.btnModifyTag);
        this.btnModiyAvailableValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynFieldControler.this.modifyCurrentAvailableValue();
            }
        });
        this.btnAddAvailableValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynFieldControler.this.addAvailableValue();
            }
        });
        this.btnDeleteAvailableValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynFieldControler.this.deleteCurrentAvailableValue();
            }
        });
    }

    public String getFieldName() {
        String s = this.txtName.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return s;
    }

    public DynObjectValueItem getCurrentAvaliableValue() {
        int row = this.tblAvailableValues.getSelectedRow();
        if (row < 0) {
            return null;
        }
        DynObjectValueItem pair = this.availableValues.get(row);
        return pair;
    }

    private void addAvailableValue() {
        final DynObjectValueItemControler panel = new DynObjectValueItemControler(this.windowManager);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Available values - New", null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    DynObjectValueItem item = new DynObjectValueItem((Object)"", "");
                    panel.fetch(item);
                    DynFieldControler.this.availableValues.add(item);
                    DynFieldControler.this.tblAvailableValues.setModel(new AvailableValuesTableModel());
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    private void deleteCurrentAvailableValue() {
        DynObjectValueItem item = this.getCurrentAvaliableValue();
        if (item == null) {
            return;
        }
        this.availableValues.remove(item);
        this.tblAvailableValues.setModel(new AvailableValuesTableModel());
    }

    private void modifyCurrentAvailableValue() {
        final DynObjectValueItem item = this.getCurrentAvaliableValue();
        if (item == null) {
            return;
        }
        final DynObjectValueItemControler panel = new DynObjectValueItemControler(this.windowManager);
        panel.set(item);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Available values - " + item.getLabel(), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    panel.fetch(item);
                    DynFieldControler.this.tblAvailableValues.repaint();
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    public void set(DynField field) {
        DynField_v2 field2 = (DynField_v2)field;
        this.txtName.setEditable(false);
        this.tags.set(field2.getTags());
        this.txtName.setText(field.getName());
        this.txtLabel.setText(field2.getLabel());
        this.txtDescription.setText(field.getDescription());
        Object v = field.getDefaultValue();
        if (v == null) {
            this.txtDefaultvalue.setText("");
        } else {
            this.txtDefaultvalue.setText(v.toString());
        }
        v = field.getMaxValue();
        if (v == null) {
            this.txtMaxValue.setText("");
        } else {
            this.txtMaxValue.setText(v.toString());
        }
        v = field.getMinValue();
        if (v == null) {
            this.txtMinValue.setText("");
        } else {
            this.txtMinValue.setText(v.toString());
        }
        this.chkHidden.setSelected(field.isHidden());
        this.chkReadonly.setSelected(field.isReadOnly());
        this.chkMandatory.setSelected(field.isMandatory());
        this.cboGroup.setSelectedItem(field.getGroup());
        this.spnOrder.setValue(field.getOder());
        this.cboSubtype.setSelectedItem(field.getSubtype());
        this.cboCalculate.setSelectedItem(field2.getCalculateMethod());
        if (field2.getAvailableValuesMethod() == null) {
            this.cboAvailableValuesMethod.setSelectedItem("");
        } else {
            this.cboAvailableValuesMethod.setSelectedItem(field2.getAvailableValuesMethod().getName());
        }
        SwingHelper.setText(this.cboType, field.getDataType().getName());
        if (field2.getDynClassOfValue() == null) {
            this.cboDynClassOfValue.setSelectedItem("");
        } else {
            this.cboDynClassOfValue.setSelectedItem(field2.getDynClassOfValue().getName());
        }
        if (field2.getClassOfValue() == null) {
            this.cboClassOfValue.setSelectedItem("");
        } else {
            this.cboClassOfValue.setSelectedItem(field2.getClassOfValue().getName());
        }
        if (field.isContainer()) {
            if (field2.getTypeOfItems() == 15) {
                this.cboTypeOfItems.setSelectedIndex(1);
            } else {
                this.cboTypeOfItems.setSelectedIndex(0);
            }
            if (field2.getDynClassOfItems() == null) {
                this.cboDynClassOfItems.setSelectedItem("");
            } else {
                this.cboDynClassOfItems.setSelectedItem(field2.getDynClassOfItems().getName());
            }
            if (field2.getClassOfItems() == null) {
                this.cboClassOfItems.setSelectedItem("");
            } else {
                this.cboClassOfItems.setSelectedItem(field2.getClassOfItems().getName());
            }
            this.cboTypeOfItems.setEnabled(true);
            this.cboClassOfItems.setEnabled(true);
            this.cboDynClassOfItems.setEnabled(true);
        } else {
            this.cboTypeOfItems.setSelectedIndex(-1);
            this.cboClassOfItems.setSelectedIndex(-1);
            this.cboDynClassOfItems.setSelectedIndex(-1);
            this.cboTypeOfItems.setEnabled(false);
            this.cboClassOfItems.setEnabled(false);
            this.cboDynClassOfItems.setEnabled(false);
        }
        this.availableValues = field.getAvailableValues() == null ? new ArrayList<DynObjectValueItem>() : Arrays.asList(field.getAvailableValues());
        this.tblAvailableValues.setModel(new AvailableValuesTableModel());
    }

    public void clear() {
        this.txtName.setEditable(true);
        this.tags.set((Tags)new DefaultTags());
        this.txtName.setText("");
        this.txtLabel.setText("");
        this.txtDescription.setText("");
        this.txtDefaultvalue.setText("");
        this.txtMaxValue.setText("");
        this.txtMinValue.setText("");
        this.chkHidden.setSelected(false);
        this.chkReadonly.setSelected(false);
        this.chkMandatory.setSelected(false);
        this.cboGroup.setSelectedItem("");
        this.spnOrder.setValue(0);
        this.cboSubtype.setSelectedItem("");
        this.cboCalculate.setSelectedItem("");
        this.cboAvailableValuesMethod.setSelectedItem("");
        this.cboDynClassOfValue.setSelectedItem("");
        this.cboClassOfValue.setSelectedItem("");
        this.cboTypeOfItems.setSelectedIndex(0);
        this.cboDynClassOfItems.setSelectedItem("");
        this.cboClassOfItems.setSelectedItem("");
        this.cboTypeOfItems.setEnabled(true);
        this.cboClassOfItems.setEnabled(true);
        this.cboDynClassOfItems.setEnabled(true);
        this.availableValues = new ArrayList<DynObjectValueItem>();
        this.tblAvailableValues.setModel(new AvailableValuesTableModel());
    }

    private String str(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void fetch(DynField field) {
        DynMethod method;
        DataTypesManager dtm = ToolsLocator.getDataTypesManager();
        DynField_v2 field2 = (DynField_v2)field;
        field.setGroup(this.str(this.cboGroup.getSelectedItem()));
        field.setDescription(this.txtDescription.getText());
        field2.setLabel(this.txtLabel.getText());
        field.setHidden(this.chkHidden.isSelected());
        field.setMandatory(this.chkMandatory.isSelected());
        field.setReadOnly(this.chkReadonly.isSelected());
        field.setOrder(((Integer)this.spnOrder.getValue()).intValue());
        field.setType(dtm.getType(this.str(this.cboType.getSelectedItem())));
        String s = this.str(this.cboDynClassOfValue.getSelectedItem());
        if (StringUtils.isEmpty((CharSequence)s) && StringUtils.isEmpty((CharSequence)(s = this.str(this.cboClassOfValue.getSelectedItem())))) {
            s = null;
        }
        field2.setClassOfValue(s);
        if (field.getDataType().isContainer()) {
            field2.setTypeOfItems(dtm.getType(this.str(this.cboTypeOfItems.getSelectedItem())));
            s = this.str(this.cboDynClassOfItems.getSelectedItem());
            if (StringUtils.isEmpty((CharSequence)s) && StringUtils.isEmpty((CharSequence)(s = this.str(this.cboClassOfItems.getSelectedItem())))) {
                s = null;
            }
            field2.setClassOfItems(s);
        }
        field.setSubtype(this.str(this.cboSubtype.getSelectedItem()));
        String methodName = this.str(this.cboCalculate.getSelectedItem());
        if (!StringUtils.isEmpty((CharSequence)methodName)) {
            try {
                method = ToolsLocator.getDynObjectManager().getDynMethod(methodName);
                field2.setCalculateMethod(method);
            }
            catch (DynMethodException ex) {
                logger.warn("Cant create calculate field", (Throwable)ex);
            }
        }
        field.setDefaultFieldValue((Object)this.txtDefaultvalue.getText());
        field.setMaxValue((Object)this.txtMaxValue.getText());
        field.setMinValue((Object)this.txtMinValue.getText());
        methodName = this.str(this.cboAvailableValuesMethod.getSelectedItem());
        if (!StringUtils.isEmpty((CharSequence)methodName)) {
            try {
                method = ToolsLocator.getDynObjectManager().getDynMethod(methodName);
                field2.setAvailableValues(method);
            }
            catch (DynMethodException ex) {
                logger.warn("Cant create calculate field", (Throwable)ex);
            }
        }
        this.tags.fetch(field2.getTags());
        field.setAvailableValues(this.availableValues);
    }

    public class AvailableValuesTableModel
    implements TableModel {
        private final String[] header = new String[]{"Label", "Value"};

        @Override
        public int getRowCount() {
            if (DynFieldControler.this.availableValues == null) {
                return 0;
            }
            return DynFieldControler.this.availableValues.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (DynFieldControler.this.availableValues == null) {
                return null;
            }
            DynObjectValueItem pair = (DynObjectValueItem)DynFieldControler.this.availableValues.get(rowIndex);
            if (columnIndex == 0) {
                return pair.getLabel();
            }
            return pair.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

