/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.binding.OsModel;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Pack
implements Serializable {
    private static final long serialVersionUID = -7841139470853935196L;
    private final String name;
    private String langPackId;
    private boolean loose;
    private final boolean uninstall;
    private final Set<String> installGroups = new HashSet<String>();
    private String excludeGroup = "";
    private String group;
    private final String description;
    private List<OsModel> osConstraints;
    private String condition;
    private List<String> dependencies;
    private List<String> dependants;
    private final Map<String, String> onSelectPacks;
    private final Map<String, String> onDeselectPacks;
    private final boolean required;
    private long size;
    private long fileSize;
    private boolean preselected;
    private String parent;
    private final List<String> children = new ArrayList<String>();
    private String imageId;
    private final List<String> validators = new ArrayList<String>();
    private boolean hidden;
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String langPackId, String description, List<OsModel> osConstraints, List<String> dependencies, boolean required, boolean preselected, boolean loose, String excludeGroup, boolean uninstall, long size) {
        this.name = name;
        this.langPackId = langPackId;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.preselected = preselected;
        this.loose = loose;
        this.excludeGroup = excludeGroup;
        this.uninstall = uninstall;
        this.size = size;
        this.onSelectPacks = new HashMap<String, String>();
        this.onDeselectPacks = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public void setLangPackId(String langPackId) {
        this.langPackId = langPackId;
    }

    public String getLangPackId() {
        return this.langPackId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOsConstraints(List<OsModel> platforms) {
        this.osConstraints = platforms;
    }

    public List<OsModel> getOsConstraints() {
        return this.osConstraints;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependencies() {
        return this.dependencies != null;
    }

    public void addDependency(String name) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(name);
    }

    public void setDependants(List<String> dependants) {
        this.dependants = dependants;
    }

    public List<String> getDependants() {
        return this.dependants;
    }

    public void addDependant(String name) {
        if (this.dependants == null) {
            this.dependants = new ArrayList<String>();
        }
        this.dependants.add(name);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setPreselected(boolean preselected) {
        this.preselected = preselected;
    }

    public boolean isPreselected() {
        return this.preselected;
    }

    public void setLoose(boolean loose) {
        this.loose = loose;
    }

    public boolean isLoose() {
        return this.loose;
    }

    public void setExcludeGroup(String group) {
        this.excludeGroup = group;
    }

    public String getExcludeGroup() {
        return this.excludeGroup;
    }

    public boolean isUninstall() {
        return this.uninstall;
    }

    public Set<String> getInstallGroups() {
        return this.installGroups;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setFileSize(long size) {
        this.fileSize = size;
    }

    public void addFileSize(long add) {
        this.fileSize += add;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void addChild(String child) {
        this.children.add(child);
    }

    public List<String> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public void addValidator(String validatorClassName) {
        this.validators.add(validatorClassName);
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return formatter.format(value) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return formatter.format(value) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return formatter.format(value) + " GB";
    }

    public void setOnSelect(String names, String condition) {
        for (String name : names.split(",")) {
            this.onSelectPacks.put(name, condition);
        }
    }

    public Map<String, String> getOnSelect() {
        return this.onSelectPacks;
    }

    public void setOnDeselect(String names, String condition) {
        for (String name : names.split(",")) {
            this.onDeselectPacks.put(name, condition);
        }
    }

    public Map<String, String> getOnDeselect() {
        return this.onDeselectPacks;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof Pack && this.name.equals(((Pack)obj).getName());
    }
}

