/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.fit.cssbox.io.DocumentSource;
import org.fit.net.DataURLHandler;

public class DefaultDocumentSource
extends DocumentSource {
    private static String USER_AGENT = "Mozilla/5.0 (compatible; BoxBrowserTest/4.x; Linux) CSSBox/4.x (like Gecko)";
    private URLConnection con;
    private InputStream is;

    public DefaultDocumentSource(URL url) throws IOException {
        super(url);
        this.con = this.createConnection(url);
        this.is = null;
    }

    public DefaultDocumentSource(String urlstring) throws IOException {
        super(null, urlstring);
        URL url = DataURLHandler.createURL(null, (String)urlstring);
        this.con = this.createConnection(url);
        this.is = null;
    }

    public DefaultDocumentSource(URL base, String urlstring) throws IOException {
        super(base, urlstring);
        URL url = DataURLHandler.createURL((URL)base, (String)urlstring);
        this.con = this.createConnection(url);
        this.is = null;
    }

    protected URLConnection createConnection(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setRequestProperty("User-Agent", USER_AGENT);
        return con;
    }

    @Override
    public URL getURL() {
        return this.con.getURL();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = this.con.getInputStream();
        }
        return this.is;
    }

    @Override
    public String getContentType() {
        return this.con.getHeaderField("Content-Type");
    }

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public static void setUserAgent(String userAgent) {
        USER_AGENT = userAgent;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }
}

