/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.actioninfo.impl;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.plugins.ExclusiveUIExtension;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.ExtensionHelper;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.ui.mdiFrame.KeyMapping;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionInfo
extends AbstractAction
implements ActionInfo {
    private static final long serialVersionUID = 1620939552263334110L;
    private static Logger logger = LoggerFactory.getLogger(DefaultActionInfo.class);
    private Class<? extends IExtension> extensionClass;
    private IExtension extension;
    private String name;
    private String text;
    private String command;
    private String iconName;
    private String accelerator;
    private long position;
    private String tip;
    private List<ActionInfo> redirections;
    private boolean active;
    private Boolean previousEnabled = null;
    private SimpleIdentityManager identityManager;

    DefaultActionInfo(IExtension extension, String name, String text, String command, String icon, String accelerator, long position, String tip) {
        this.extensionClass = extension.getClass();
        this.extension = extension;
        this.name = name;
        this.text = this.emptyToNull(text);
        this.command = this.emptyToNull(command);
        this.iconName = this.emptyToNull(icon);
        this.accelerator = this.emptyToNull(accelerator);
        this.position = position;
        this.tip = this.emptyToNull(tip);
        this.redirections = null;
        this.active = true;
        this.fixIcon();
    }

    DefaultActionInfo(Class<? extends IExtension> extensionClass, String name, String text, String command, String icon, String accelerator, long position, String tip) {
        this.extensionClass = extensionClass;
        this.name = name;
        this.text = this.emptyToNull(text);
        this.command = this.emptyToNull(command);
        this.iconName = this.emptyToNull(icon);
        this.accelerator = this.emptyToNull(accelerator);
        this.position = position;
        this.tip = this.emptyToNull(tip);
        this.redirections = null;
        this.active = true;
        this.fixIcon();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultActionInfo other = (DefaultActionInfo)super.clone();
        if (other.redirections != null) {
            other.redirections = new ArrayList<ActionInfo>();
            other.redirections.addAll(this.redirections);
        }
        return other;
    }

    private void fixIcon() {
        if (this.iconName != null && (this.iconName.contains("/") || this.iconName.contains("."))) {
            String name = FilenameUtils.getBaseName((String)this.iconName);
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            URL resource = null;
            try {
                resource = this.extensionClass.getClassLoader().getResource(this.iconName);
            }
            catch (Exception e) {
                return;
            }
            if (resource == null) {
                return;
            }
            iconTheme.registerDefault(this.getPluginName(), "broken", name, null, resource);
            logger.info("Plugin " + this.getPluginName() + " contains icons out of icon theme (" + this.iconName + ")");
            this.iconName = name;
        }
    }

    private String emptyToNull(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().length() < 0 ? null : s;
    }

    @Override
    public Collection<ActionInfo> getRedirections() {
        if (this.redirections == null) {
            this.redirections = new ArrayList<ActionInfo>();
        }
        return this.redirections;
    }

    public void merge(ActionInfo other) {
        if (this.extensionClass == null) {
            this.extensionClass = other.getExtension().getClass();
            this.extension = other.getExtension();
        }
        if (this.text == null) {
            this.text = other.getLabel();
        }
        if (this.command == null) {
            this.command = other.getCommand();
        }
        if (this.iconName == null) {
            this.iconName = other.getIconName();
        }
        if (this.accelerator == null) {
            this.accelerator = other.getAccelerator();
        }
        if (this.position < 1L) {
            this.position = other.getPosition();
        }
        if (this.tip == null) {
            this.tip = other.getTooltip();
        }
    }

    @Override
    public PluginServices getPlugin() {
        if (this.extension instanceof Extension) {
            return ((Extension)this.extension).getPlugin();
        }
        PluginServices plugin = PluginsLocator.getManager().getPlugin(this.extensionClass);
        return plugin;
    }

    @Override
    public String getPluginName() {
        if (this.getPlugin() == null) {
            return null;
        }
        return this.getPlugin().getPluginName();
    }

    @Override
    public IExtension getExtension() {
        if (this.extension == null) {
            this.extension = PluginsLocator.getManager().getExtension(this.extensionClass);
        }
        return this.extension;
    }

    @Override
    public String getExtensionName() {
        if (this.extensionClass == null) {
            return null;
        }
        return this.extensionClass.getName();
    }

    private SimpleIdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = ToolsLocator.getIdentityManager();
        }
        return this.identityManager;
    }

    private SimpleIdentity getCurrentUser() {
        return this.getIdentityManager().getCurrentIdentity();
    }

    @Override
    public boolean isVisible() {
        if (!this.getCurrentUser().isAuthorized(this.getName())) {
            return false;
        }
        if (!this.isActive()) {
            logger.info("isVisible(), action {} not active", (Object)this.getName());
            return false;
        }
        ActionInfo redirection = this.getRedirection();
        if (redirection != null) {
            return redirection.isVisible();
        }
        ExclusiveUIExtension eui = PluginsLocator.getManager().getExclusiveUIExtension();
        if (eui == null) {
            return ExtensionHelper.isVisible(this.getExtension(), this.command);
        }
        return eui.isVisible(this.getExtension());
    }

    @Override
    public boolean isEnabled() {
        boolean value;
        if (this.getActionInfoManager().isAllDisabled()) {
            return false;
        }
        if (!this.getCurrentUser().isAuthorized(this.getName())) {
            return false;
        }
        if (!this.isActive()) {
            logger.info("isEnabled(), action {} not active", (Object)this.getName());
            value = false;
        } else {
            ExclusiveUIExtension eui;
            ActionInfo redirection = this.getRedirection();
            value = redirection != null ? true : ((eui = PluginsLocator.getManager().getExclusiveUIExtension()) == null ? ExtensionHelper.isEnabled(this.getExtension(), this.command) : eui.isEnabled(this.getExtension()));
        }
        if (this.previousEnabled == null || this.previousEnabled != value) {
            this.setEnabled(value);
        }
        return value;
    }

    private ActionInfo getRedirection() {
        if (this.redirections == null) {
            return null;
        }
        for (int n = this.redirections.size() - 1; n >= 0; --n) {
            ActionInfo redirection = this.redirections.get(n);
            if (!redirection.isEnabled()) continue;
            return redirection;
        }
        return null;
    }

    @Override
    public void execute() {
        if (!this.getCurrentUser().isAuthorized(this.getName())) {
            logger.warn("Current user '" + this.getCurrentUser().getID() + "' not authorized to execute this action '" + this.getName() + "'.");
            return;
        }
        ActionInfo redirection = this.getRedirection();
        if (redirection != null) {
            logger.info("{}.execute('{}') redirected", (Object)(this.getPluginName() + ":" + this.getExtensionName()), (Object)this.getCommand());
            redirection.execute();
            return;
        }
        logger.info("{}.execute('{}')", (Object)(this.getPluginName() + ":" + this.getExtensionName()), (Object)this.getCommand());
        this.getExtension().execute(this.command);
    }

    @Override
    public void execute(Object[] args) {
        if (!this.getCurrentUser().isAuthorized(this.getName())) {
            logger.warn("Current user '" + this.getCurrentUser().getID() + "' not authorized to execute this action '" + this.getName() + "'.");
            return;
        }
        ActionInfo redirection = this.getRedirection();
        if (redirection != null) {
            logger.info("{}.execute('{}', args) redirected", (Object)(this.getPluginName() + ":" + this.getExtensionName()), (Object)this.getCommand());
            redirection.execute(args);
            return;
        }
        logger.info("{}.execute('{}', Object[] args)", (Object)(this.getPluginName() + ":" + this.getExtensionName()), (Object)this.getCommand());
        ExtensionHelper.execute(this.getExtension(), this.command, args);
    }

    @Override
    public void execute(Object arg) {
        if (arg instanceof Object[]) {
            this.execute((Object[])arg);
            return;
        }
        this.execute(new Object[]{arg});
    }

    @Override
    public void execute(Map args) {
        if (!this.getCurrentUser().isAuthorized(this.getName())) {
            logger.warn("Current user '" + this.getCurrentUser().getID() + "' not authorized to execute this action '" + this.getName() + "'.");
            return;
        }
        logger.info("{}.execute('{}', Map args)", (Object)(this.getPluginName() + ":" + this.getExtensionName()), (Object)this.getCommand());
        ExtensionHelper.execute(this.getExtension(), this.command, new Object[]{args});
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (FutureUtils.use((String)"ADD_EVENT_MODIFIERS_IN_ACTION_EXECUTE")) {
            this.execute(new Object[]{"--awtmodifiers=", arg0.getModifiers()});
        } else {
            this.execute();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public ImageIcon getIcon() {
        IconTheme iconTheme = PluginServices.getIconTheme();
        return iconTheme.get(this.iconName);
    }

    @Override
    public String getAccelerator() {
        return this.accelerator;
    }

    @Override
    public KeyStroke getKeyStroke() {
        if (this.emptyToNull(this.accelerator) == null) {
            return null;
        }
        return KeyMapping.getKeyStroke(this.accelerator);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public String getTooltip() {
        return this.tip;
    }

    @Override
    public Object getValue(String key) {
        if ("ActionCommandKey".equalsIgnoreCase(key)) {
            return this.command;
        }
        if ("LongDescription".equalsIgnoreCase(key)) {
            return this.tip;
        }
        if ("Name".equalsIgnoreCase(key)) {
            return this.name;
        }
        if ("SmallIcon".equalsIgnoreCase(key)) {
            return this.getIcon();
        }
        if ("ActionCommandKey".equalsIgnoreCase(key)) {
            return this.command;
        }
        if ("AcceleratorKey".equalsIgnoreCase(key)) {
            return this.getKeyStroke();
        }
        if ("SwingLargeIconKey".equalsIgnoreCase(key)) {
            return this.getIcon();
        }
        if ("ICON_NAME".equalsIgnoreCase(key)) {
            return this.iconName;
        }
        if ("ShortDescription".equalsIgnoreCase(key)) {
            return this.getLabel();
        }
        if ("TOOLTIP".equalsIgnoreCase(key)) {
            return this.getTooltip();
        }
        if ("POSITION".equalsIgnoreCase(key)) {
            return this.position;
        }
        if ("REDIRECTIONS".equalsIgnoreCase(key)) {
            return this.redirections;
        }
        if ("REDIRECTION".equalsIgnoreCase(key)) {
            return this.getRedirection();
        }
        if ("EXTENSION".equalsIgnoreCase(key)) {
            return this.getExtension();
        }
        if ("EXTENSION_NAME".equalsIgnoreCase(key)) {
            return this.getExtensionName();
        }
        if ("PLUGIN".equalsIgnoreCase(key)) {
            return this.getPlugin();
        }
        if ("PLUGIN_NAME".equalsIgnoreCase(key)) {
            return this.getPluginName();
        }
        if ("VISIBLE".equalsIgnoreCase(key)) {
            return this.isVisible();
        }
        if ("ACTIVE".equalsIgnoreCase(key)) {
            return this.active;
        }
        if ("ACCELERATOR".equalsIgnoreCase(key)) {
            return this.accelerator;
        }
        return super.getValue(key);
    }

    @Override
    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
        if ("ACTIVE".equalsIgnoreCase(key)) {
            this.setActive(this.active);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ActionInfo {");
        buffer.append("name='").append(this.name).append("', ");
        buffer.append("active='").append(this.active).append("', ");
        buffer.append("label='").append(this.text).append("', ");
        buffer.append("tooltip='").append(this.tip).append("', ");
        buffer.append("actionCommand='").append(this.command).append("', ");
        buffer.append("position='").append(this.position).append("', ");
        buffer.append("icon='").append(this.iconName).append("', ");
        buffer.append("extension='").append(this.getExtensionName()).append("', ");
        if (this.redirections != null) {
            buffer.append("redirection=(");
            for (ActionInfo redirection : this.redirections) {
                buffer.append(redirection.getName());
                buffer.append(" ");
            }
            buffer.append("), ");
        } else {
            buffer.append("redirections=( ), ");
        }
        buffer.append("accelerator='").append(this.accelerator);
        buffer.append("' }");
        return buffer.toString();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    private ActionInfoManager getActionInfoManager() {
        return PluginsLocator.getActionInfoManager();
    }
}

