/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiManager;

import org.apache.log4j.Logger;
import org.gvsig.andami.messages.Messages;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.plugins.config.generate.SkinExtension;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.NoSkinExtensionException;

public class MDIManagerFactory {
    private static SkinExtension skinExtension = null;
    private static PluginClassLoader loader = null;
    private static MDIManager mdiManager = null;
    private static Logger logger = Logger.getLogger((String)MDIManagerFactory.class.getName());

    public static void setSkinExtension(SkinExtension extension, PluginClassLoader loader) {
        MDIManagerFactory.loader = loader;
        skinExtension = extension;
    }

    public static MDIManager getManager() {
        return MDIManagerFactory.createManager();
    }

    public static MDIManager createManager() {
        if (mdiManager != null) {
            return mdiManager;
        }
        if (skinExtension == null) {
            throw new NoSkinExtensionException(Messages.getString("MDIManagerFactory.No_skin_extension_in_the_plugins"));
        }
        try {
            mdiManager = (MDIManager)loader.loadClass(skinExtension.getClassName()).newInstance();
            return mdiManager;
        }
        catch (InstantiationException e) {
            logger.error((Object)Messages.getString("Launcher.Error_instanciando_la_extension"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)Messages.getString("Launcher.Error_instanciando_la_extension"), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)Messages.getString("Launcher.No_se_encontro_la_clase_de_la_extension"), (Throwable)e);
        }
        return null;
    }

    public static SkinExtension getSkinExtension() {
        return skinExtension;
    }
}

