/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.InstanceUtils;
import org.gvsig.expressionevaluator.impl.SimpleScript;
import org.gvsig.expressionevaluator.impl.function.programming.CreateFnFunction;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.visitor.FilteredVisitable;
import org.gvsig.tools.visitor.Visitor;

public class DefaultCodeBuilder
implements CodeBuilder {
    protected ExpressionEvaluatorManager manager;

    public DefaultCodeBuilder(ExpressionEvaluatorManager manager) {
        this.manager = manager;
    }

    public CodeBuilder clone() throws CloneNotSupportedException {
        DefaultCodeBuilder other = (DefaultCodeBuilder)super.clone();
        return other;
    }

    public Code.Constant constant(Object value) {
        return new BaseConstant(this.manager, value);
    }

    public Code.Identifier identifier(String name) {
        return new BaseIdentifier(name);
    }

    public BaseCodes args() {
        return new BaseCodes();
    }

    public Code.Callable tuple() {
        BaseCodes args = this.args();
        return this.function("TUPLE", args);
    }

    public Code.Callable tuple(Codes args) {
        if (args == null) {
            args = this.args();
        }
        return this.function("TUPLE", args);
    }

    public Code.Callable tuple(Code ... items) {
        BaseCodes args = this.args();
        if (items != null) {
            for (Code item : items) {
                args.add(item);
            }
        }
        return this.function("TUPLE", args);
    }

    public Code.Callable function(String name, int type, Codes args) {
        return new BaseCaller(name, type, args);
    }

    public Code.Callable function(String name, Codes args) {
        return this.function(name, 0, args);
    }

    public Code method(Code instance, String methodname, Codes methodargs) {
        BaseMethod m = new BaseMethod(instance, methodname, methodargs);
        return m;
    }

    public Code.Callable operator(String name, Code arg1) {
        BaseCodes args = this.args();
        args.add(arg1);
        return this.function(name, 2, args);
    }

    public Code.Callable operator(String name, Code arg1, Code arg2) {
        BaseCodes args = this.args();
        args.add(arg1);
        args.add(arg2);
        return this.function(name, 1, args);
    }

    public Code not(Code op1) {
        return this.operator("NOT", op1);
    }

    public Code negate(Code op1) {
        return this.operator("NEGATE", op1);
    }

    public Code concat(Code op1, Code op2) {
        return this.operator("||", op1, op2);
    }

    public Code let(String identifier, Code value) {
        BaseCodes args = this.args();
        args.add((Code)this.constant(identifier));
        args.add(value);
        return this.function("LET", 0, args);
    }

    public Code add(Code op1, Code op2) {
        return this.operator("+", op1, op2);
    }

    public Code subst(Code op1, Code op2) {
        return this.operator("-", op1, op2);
    }

    public Code mult(Code op1, Code op2) {
        return this.operator("*", op1, op2);
    }

    public Code div(Code op1, Code op2) {
        return this.operator("/", op1, op2);
    }

    public Code mod(Code op1, Code op2) {
        BaseCodes args = this.args();
        args.add(op1);
        args.add(op2);
        return this.function("MOD", args);
    }

    public Code or(Code op1, Code op2) {
        return this.operator("OR", op1, op2);
    }

    public Code and(Code op1, Code op2) {
        return this.operator("AND", op1, op2);
    }

    public Code like(Code op1, Code op2) {
        return this.operator("LIKE", op1, op2);
    }

    public Code ilike(Code op1, Code op2) {
        return this.operator("ILIKE", op1, op2);
    }

    public Code regexp(Code op1, Code op2) {
        return this.operator("~", op1, op2);
    }

    public Code lt(Code op1, Code op2) {
        return this.operator("<", op1, op2);
    }

    public Code gt(Code op1, Code op2) {
        return this.operator(">", op1, op2);
    }

    public Code le(Code op1, Code op2) {
        return this.operator("<=", op1, op2);
    }

    public Code ge(Code op1, Code op2) {
        return this.operator(">=", op1, op2);
    }

    public Code eq(Code op1, Code op2) {
        return this.operator("=", op1, op2);
    }

    public Code ne(Code op1, Code op2) {
        return this.operator("<>", op1, op2);
    }

    public Code is(Code op1, Code op2) {
        return this.operator("IS", op1, op2);
    }

    public Code getattr(Code obj, String attrname) {
        BaseCodes args = this.args();
        args.add(obj);
        args.add((Code)this.constant(attrname));
        return this.function("GETATTR", args);
    }

    public Code getitem(Code obj, Code index) {
        BaseCodes args = this.args();
        args.add(obj);
        args.add(index);
        return this.function("GETITEM", args);
    }

    public Code dict(Map<String, Code> map) {
        BaseCodes args = this.args();
        for (Map.Entry<String, Code> entry : map.entrySet()) {
            String key = entry.getKey();
            Code value = entry.getValue();
            args.add((Code)this.constant(key));
            args.add(value);
        }
        return this.function("DICT", args);
    }

    public Code $HostExpression(Code obj, String mode_specifier) {
        BaseCodes args = this.args();
        args.add(obj);
        args.add((Code)this.constant(mode_specifier));
        return this.function("$HOSTEXPRESSION", args);
    }

    public Code $HostExpression(Code obj) {
        BaseCodes args = this.args();
        args.add(obj);
        return this.function("$HOSTEXPRESSION", args);
    }

    public Code.Callable block(Code ... codes) {
        BaseCodes args = this.args();
        if (codes != null) {
            for (Code code : codes) {
                args.add(code);
            }
        }
        return this.function("BLOCK", args);
    }

    public Code in(Code value1, Code value2) {
        BaseCodes args = this.args();
        args.add(value1);
        args.add(value2);
        return this.function("IN", args);
    }

    public Code between(Code value1, Code value2, Code value3) {
        BaseCodes args = this.args();
        args.add(value1);
        args.add(value2);
        args.add(value3);
        return this.function("BETWEEN", args);
    }

    public static class BaseMethod
    extends BaseCode
    implements Code.Method {
        private Code instance;
        private final String methodname;
        private Codes args;

        public BaseMethod(Code instance, String methodname, Codes args) {
            this.instance = instance;
            this.methodname = methodname;
            this.args = args;
        }

        @Override
        public void accept(Visitor visitor, Predicate<FilteredVisitable> exclude) throws BaseException {
            if (exclude != null && exclude.test((FilteredVisitable)this)) {
                return;
            }
            super.accept(visitor, exclude);
            if (this.instance != null) {
                this.instance.accept(visitor, exclude);
            }
            if (this.args != null) {
                this.args.accept(visitor, exclude);
            }
        }

        @Override
        public Code clone() throws CloneNotSupportedException {
            BaseMethod x = (BaseMethod)super.clone();
            x.args = this.args != null ? this.args.clone() : null;
            return x;
        }

        @Override
        public int code() {
            return 3;
        }

        @Override
        public void replace(Code target, Code replacement) {
            if (target == this.instance) {
                this.instance = replacement;
            }
            this.args.replace(target, replacement);
        }

        public String methodname() {
            return this.methodname;
        }

        public Code instance() {
            return this.instance;
        }

        public Codes parameters() {
            return this.args;
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            Object theInstance = interpreter.run(this.instance);
            if (theInstance instanceof SimpleScript) {
                try {
                    return ((SimpleScript)theInstance).invokeFunction(this.methodname, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (theInstance instanceof DynObject) {
                DynObject dynobj = (DynObject)theInstance;
                try {
                    return dynobj.invokeDynMethod(this.methodname, args);
                }
                catch (DynMethodNotSupportedException dynMethodNotSupportedException) {
                    // empty catch block
                }
            }
            if (theInstance instanceof GetItemByKey) {
                try {
                    Object method = ((GetItemByKey)theInstance).get((Object)this.methodname);
                    if (method instanceof CreateFnFunction.UserFunction) {
                        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
                        MutableSymbolTable localSymbolTable = manager.createSymbolTable();
                        localSymbolTable.setVar("self", theInstance);
                        return ((CreateFnFunction.UserFunction)((Object)method)).call(interpreter, localSymbolTable, args);
                    }
                    if (method instanceof Function) {
                        return ((Function)method).call(interpreter, args);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return InstanceUtils.callmethod(theInstance, this.methodname, args);
        }

        public String toString() {
            return this.toString((Formatter<Code>)EMPTY_FORMATTER);
        }

        @Override
        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            ExpressionBuilder.Method m = builder.method(this.instance.toValue(builder), this.methodname, new ExpressionBuilder.Value[0]);
            if (this.parameters() != null) {
                for (Code parameter : this.parameters()) {
                    m.parameter(parameter.toValue(builder));
                }
            }
            m.copyPropertiesFrom((PropertiesSupport)builder);
            return m;
        }

        public String toString(Formatter<Code> formatter) {
            if (formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.instance.toString(formatter));
            builder.append(".");
            builder.append(this.methodname());
            builder.append("(");
            if (this.parameters() != null) {
                builder.append(this.parameters().toString(formatter));
            }
            builder.append(")");
            return builder.toString();
        }

        public String name() {
            return this.methodname();
        }

        public Function function() {
            return null;
        }

        public Function function(Function function) {
            return null;
        }

        public int type() {
            return 3;
        }
    }

    public class BaseCaller
    extends BaseCode
    implements Code.Callable,
    RecursionControlSupport {
        private final String name;
        private Codes args;
        private Function function;
        private final int type;
        private RecursionSupport recursionSupport;

        public BaseCaller(String name, int type, Codes args) {
            this.name = name;
            this.args = args;
            this.type = type;
            this.function = null;
            this.recursionSupport = new RecursionSupport();
        }

        @Override
        public Code clone() throws CloneNotSupportedException {
            BaseCaller x = (BaseCaller)super.clone();
            x.recursionSupport = (RecursionSupport)this.recursionSupport.clone();
            if (this.args != null) {
                x.args = this.args.clone();
            }
            return x;
        }

        @Override
        public int code() {
            return 2;
        }

        @Override
        public void replace(Code target, Code replacement) {
            this.args.replace(target, replacement);
        }

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return this.function.call(interpreter, args);
        }

        public String name() {
            return this.name;
        }

        public Function function() {
            return this.function;
        }

        public Function function(Function function) {
            this.function = function;
            return this.function;
        }

        public Codes parameters() {
            return this.args;
        }

        public int type() {
            return this.type;
        }

        @Override
        public void accept(Visitor visitor, Predicate<FilteredVisitable> exclude) throws BaseException {
            if (exclude != null && exclude.test((FilteredVisitable)this)) {
                return;
            }
            super.accept(visitor, exclude);
            if (this.args != null) {
                this.args.accept(visitor, exclude);
            }
        }

        @Override
        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            ExpressionBuilder.Value value;
            switch (this.type) {
                case 2: {
                    value = builder.function("NEGATE".equalsIgnoreCase(this.name()) ? "-" : this.name(), new ExpressionBuilder.Value[]{((Code)this.parameters().get(0)).toValue(builder)});
                    break;
                }
                case 1: {
                    value = builder.binaryOperator(this.name(), ((Code)this.parameters().get(0)).toValue(builder), ((Code)this.parameters().get(1)).toValue(builder));
                    break;
                }
                default: {
                    if (this.function == null) {
                        ExpressionBuilder.Function f = builder.function(this.name(), new ExpressionBuilder.Value[0]);
                        if (this.parameters() != null) {
                            for (Code parameter : this.parameters()) {
                                if (parameter == null) {
                                    f.parameter(null);
                                    continue;
                                }
                                f.parameter(parameter.toValue(builder));
                            }
                        }
                        value = f;
                        break;
                    }
                    value = this.function.toValue(builder, this.parameters());
                }
            }
            value.copyPropertiesFrom((PropertiesSupport)builder);
            return value;
        }

        public String toString() {
            return this.toString((Formatter<Code>)EMPTY_FORMATTER);
        }

        public String toString(Formatter<Code> formatter) {
            if (formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            switch (this.type) {
                case 2: {
                    if ("NEGATE".equalsIgnoreCase(this.name())) {
                        builder.append("-");
                    } else {
                        builder.append(this.name());
                    }
                    builder.append("(");
                    builder.append(((Code)this.parameters().get(0)).toString(formatter));
                    builder.append(")");
                    break;
                }
                case 1: {
                    builder.append("(");
                    Code code = (Code)this.parameters().get(0);
                    if (code == null) {
                        builder.append("?NULL?");
                    } else {
                        builder.append(code.toString(formatter));
                    }
                    builder.append(" ");
                    builder.append(this.name());
                    builder.append(" ");
                    code = (Code)this.parameters().get(1);
                    if (code == null) {
                        builder.append("?NULL?");
                    } else {
                        builder.append(code.toString(formatter));
                    }
                    builder.append(")");
                    break;
                }
                default: {
                    String s = null;
                    if (this.function() != null) {
                        s = this.function().toString(this.args, formatter);
                    }
                    if (s == null) {
                        builder.append(this.name());
                        builder.append("(");
                        if (this.parameters() != null) {
                            builder.append(this.parameters().toString(formatter));
                        }
                        builder.append(")");
                        break;
                    }
                    builder.append(s);
                }
            }
            return builder.toString();
        }

        @Override
        public boolean enterCode(int max) {
            return this.recursionSupport.enterCode(max);
        }

        @Override
        public void exitCode() {
            this.recursionSupport.exitCode();
        }

        @Override
        public void resetRecursionState() {
            this.recursionSupport.resetRecursionState();
        }
    }

    public static class BaseCodes
    implements Codes,
    MutableCodes {
        private List<Code> codes = new ArrayList<Code>();

        public Codes clone() throws CloneNotSupportedException {
            BaseCodes x = (BaseCodes)super.clone();
            x.codes = new ArrayList<Code>();
            for (int i = 0; i < this.codes.size(); ++i) {
                Code code = this.codes.get(i);
                if (code != null) {
                    x.add(code.clone());
                    continue;
                }
                x.add(null);
            }
            return x;
        }

        public int code() {
            return 4;
        }

        public int size() {
            if (this.codes == null) {
                return 0;
            }
            return this.codes.size();
        }

        public void add(Code arg) {
            this.codes.add(arg);
        }

        public void set(int pos, Code arg) {
            this.codes.set(pos, arg);
        }

        public void insert(int pos, Code arg) {
            this.codes.add(pos, arg);
        }

        public Iterator<Code> iterator() {
            Iterator<Code> it = this.codes.iterator();
            return it;
        }

        public Code get(int n) {
            return this.codes.get(n);
        }

        public boolean isEmpty() {
            return this.codes.isEmpty();
        }

        public List<Code> toList() {
            return Collections.unmodifiableList(this.codes);
        }

        public void accept(Visitor visitor) throws BaseException {
            this.accept(visitor, null);
        }

        public void accept(Visitor visitor, Predicate<FilteredVisitable> exclude) throws BaseException {
            if (this.codes != null) {
                for (Code arg : this.codes) {
                    if (arg == null) continue;
                    arg.accept(visitor, exclude);
                }
            }
        }

        public String toString() {
            return this.toString((Formatter<Code>)EMPTY_FORMATTER);
        }

        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            throw new UnsupportedOperationException();
        }

        public ExpressionBuilder.Value toValue() {
            throw new UnsupportedOperationException();
        }

        public String toString(Formatter<Code> formatter) {
            if (formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.codes != null) {
                StringBuilder builder = new StringBuilder();
                boolean skipcoma = true;
                for (Code arg : this.codes) {
                    if (arg == null) continue;
                    if (skipcoma) {
                        skipcoma = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(arg.toString(formatter));
                }
                return builder.toString();
            }
            return "";
        }

        public void link(SymbolTable symbolTable) {
            this.link(symbolTable, true);
        }

        public void link(SymbolTable symbolTable, boolean force) {
            for (Code arg : this.codes) {
                arg.link(symbolTable, force);
            }
        }

        public void link() {
            SymbolTable symbolTable = ExpressionEvaluatorLocator.getExpressionEvaluatorManager().getInmutableSymbolTable();
            this.link(symbolTable);
        }

        public void replace(Code target, Code replacement) {
            for (int i = 0; i < this.codes.size(); ++i) {
                Code code = this.codes.get(i);
                if (code == null) continue;
                if (code == target) {
                    this.codes.set(i, replacement);
                    continue;
                }
                code.replace(target, replacement);
            }
        }
    }

    public static class BaseIdentifier
    extends BaseCode
    implements Code.Identifier,
    RecursionControlSupport {
        private final String name;
        private final RecursionSupport recursionSupport;

        public BaseIdentifier(String name) {
            this.name = name;
            this.recursionSupport = new RecursionSupport();
        }

        @Override
        public Code clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public int code() {
            return 1;
        }

        public String name() {
            return this.name;
        }

        @Override
        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            ExpressionBuilder.Variable v = builder.variable(this.name);
            v.copyPropertiesFrom((PropertiesSupport)builder);
            return v;
        }

        public String toString() {
            return this.toString((Formatter<Code>)EMPTY_FORMATTER);
        }

        public String toString(Formatter<Code> formatter) {
            if (formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("\"");
            builder.append(this.name());
            builder.append("\"");
            return builder.toString();
        }

        @Override
        public boolean enterCode(int max) {
            return this.recursionSupport.enterCode(max);
        }

        @Override
        public void exitCode() {
            this.recursionSupport.exitCode();
        }

        @Override
        public void resetRecursionState() {
            this.recursionSupport.resetRecursionState();
        }
    }

    private static class RecursionSupport
    implements RecursionControlSupport,
    Cloneable {
        private int counter = 0;

        public RecursionControlSupport clone() throws CloneNotSupportedException {
            RecursionControlSupport x = (RecursionControlSupport)super.clone();
            return x;
        }

        @Override
        public boolean enterCode(int max) {
            ++this.counter;
            return this.counter < max;
        }

        @Override
        public void exitCode() {
            --this.counter;
        }

        @Override
        public void resetRecursionState() {
            this.counter = 0;
        }
    }

    public static interface RecursionControlSupport {
        public boolean enterCode(int var1);

        public void exitCode();

        public void resetRecursionState();
    }

    static class BaseConstant
    extends BaseCode
    implements Code.Constant {
        private Object value;
        private final ExpressionEvaluatorManager manager;

        public BaseConstant(ExpressionEvaluatorManager manager, Object value) {
            this.manager = manager;
            this.value = value;
        }

        @Override
        public Code clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public int code() {
            return 0;
        }

        public Object value() {
            return this.value;
        }

        public void value(Object v) {
            this.value = v;
        }

        @Override
        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            ExpressionBuilder.Constant v = builder.constant(this.value);
            v.copyPropertiesFrom((PropertiesSupport)builder);
            return v;
        }

        public String toString() {
            return this.toString((Formatter<Code>)EMPTY_FORMATTER);
        }

        public String toString(Formatter<Code> formatter) {
            if (formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            Object v = this.value();
            return this.manager.getReprMethod(v).repr(v);
        }
    }

    public static abstract class BaseCode
    implements Code {
        public int code() {
            return -1;
        }

        public Code clone() throws CloneNotSupportedException {
            BaseCode x = (BaseCode)super.clone();
            return x;
        }

        public void accept(Visitor visitor) throws BaseException {
            this.accept(visitor, null);
        }

        public void accept(Visitor visitor, Predicate<FilteredVisitable> exclude) throws BaseException {
            if (exclude == null || !exclude.test((FilteredVisitable)this)) {
                visitor.visit((Object)this);
            }
        }

        public ExpressionBuilder.Value toValue(ExpressionBuilder builder) {
            return null;
        }

        public ExpressionBuilder.Value toValue() {
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            return this.toValue(builder);
        }

        public void link(SymbolTable symbolTable) {
            this.link(symbolTable, true);
        }

        public void link(SymbolTable symbolTable, boolean force) {
            if (this.code() == 2) {
                Function fn;
                Code.Callable caller = (Code.Callable)this;
                if ((force || caller.function() == null) && (fn = symbolTable.function(caller.name())) != null) {
                    caller.function(fn);
                }
                if (caller.parameters() != null) {
                    for (Code arg : caller.parameters()) {
                        if (arg == null) continue;
                        arg.link(symbolTable, force);
                    }
                }
            }
        }

        public void link() {
            SymbolTable symbolTable = ExpressionEvaluatorLocator.getExpressionEvaluatorManager().getInmutableSymbolTable();
            this.link(symbolTable);
        }

        public void replace(Code target, Code replacement) {
        }
    }
}

