/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class DateAddFunction
extends AbstractFunction {
    public DateAddFunction() {
        super("Date", "DATEADD", Range.is((Comparable)Integer.valueOf(3)), "Adds a time/date interval to a date and then returns the date", "DATEADD({{interval}}, number, date)", new String[]{"interval - a string with the value year,month,day,hour,minute,second or millisecond.", "number - a number in the unit specified with interval parameter", "date - a Date"}, "Date");
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        String interval = this.getStr(args, 0);
        long number = this.getLong(args, 1);
        LocalDateTime date = this.getLocalDateTime(args, 2);
        switch (interval.toLowerCase()) {
            case "millisecond": 
            case "ms": {
                date = date.plus(number, ChronoUnit.MILLIS);
                break;
            }
            case "second": 
            case "ss": 
            case "s": {
                date = date.plus(number, ChronoUnit.SECONDS);
                break;
            }
            case "minute": 
            case "mi": 
            case "n": {
                date = date.plus(number, ChronoUnit.MINUTES);
                break;
            }
            case "hour": 
            case "hh": {
                date = date.plus(number, ChronoUnit.HOURS);
                break;
            }
            case "day": 
            case "dy": 
            case "y": {
                date = date.plus(number, ChronoUnit.DAYS);
                break;
            }
            case "month": 
            case "mm": 
            case "m": {
                date = date.plus(number, ChronoUnit.MONTHS);
                break;
            }
            case "year": 
            case "yyyy": 
            case "yy": {
                date = date.plus(number, ChronoUnit.YEARS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported interval '" + interval + "'.");
            }
        }
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }
}

