/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.grammars;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Grammar;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.Statement;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultStatement;
import org.gvsig.expressionevaluator.spi.AbstractGrammarFactory;

public class BasicGrammarFactory
extends AbstractGrammarFactory {
    private Grammar grammar;

    public BasicGrammarFactory() {
        super("Basic", true);
    }

    public Grammar create(Object ... parameters) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        if (this.grammar == null) {
            Grammar theGrammar = manager.createGrammar(this.getName());
            theGrammar.addStatement(this.createArrayStatement(theGrammar));
            theGrammar.addStatement(this.createBlockStatement(theGrammar));
            theGrammar.addStatement(this.createCallStatement(theGrammar));
            theGrammar.addStatement(this.createCaseStatement(theGrammar));
            theGrammar.addStatement(this.createCastStatement(theGrammar));
            theGrammar.addStatement(this.createDateStatement(theGrammar));
            theGrammar.addStatement(this.createDictStatement(theGrammar));
            theGrammar.addStatement(this.createExtractStatement(theGrammar));
            theGrammar.addStatement(this.createForeachStatement(theGrammar));
            theGrammar.addStatement(this.createFunctionStatement(theGrammar));
            theGrammar.addStatement(this.createIfStatement(theGrammar));
            theGrammar.addStatement(this.createLambdaStatement(theGrammar));
            theGrammar.addStatement(this.createLet1Statement(theGrammar));
            theGrammar.addStatement(this.createLet2Statement(theGrammar));
            theGrammar.addStatement(this.createSetattr1Statement(theGrammar));
            theGrammar.addStatement(this.createSetattr2Statement(theGrammar));
            theGrammar.addStatement(this.createVarStatement(theGrammar));
            theGrammar.addStatement(this.createListStatement(theGrammar));
            theGrammar.addStatement(this.createMatchStatement(theGrammar));
            theGrammar.addStatement(this.createPassStatement(theGrammar));
            theGrammar.addStatement(this.createReturnStatement(theGrammar));
            theGrammar.addStatement(this.createTimeStatement(theGrammar));
            theGrammar.addStatement(this.createTimestampStatement(theGrammar));
            theGrammar.addStatement(this.createWhileStatement(theGrammar));
            theGrammar.addStatement(this.create$ConstantStatement(theGrammar));
            theGrammar.addStatement(this.createBreakStatement(theGrammar));
            theGrammar.addStatement(this.createImportStatement(theGrammar));
            this.grammar = theGrammar;
        }
        return this.grammar;
    }

    private Statement createBlockStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("BEGIN");
        theGrammar.addReservedWord("EXCEPT");
        theGrammar.addReservedWord("END");
        Statement stmt = theGrammar.createStatement("BLOCK");
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"DECLARE"}).addRuleOnTrue(stmt.require_expressions(";", new String[]{"BEGIN"}).capture_as(new String[]{"DECLARE"})));
        stmt.addRule(stmt.require_any_token(new String[]{"BEGIN"}));
        stmt.addRule(stmt.require_expressions(";").capture_as(new String[]{"VALUES"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"EXCEPT"}).addRuleOnTrue(stmt.require_expressions(";").capture_as(new String[]{"EXCEPT"})));
        stmt.addRule(stmt.require_any_token(new String[]{"END"}));
        stmt.builder((Statement.StatementBuilder)new BeginStatementBuilder("VALUES", "EXCEPT", "DECLARE"));
        return stmt;
    }

    private Statement create$ConstantStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("$Constant");
        stmt.addRule(stmt.require_any_token(new String[]{"<%"}));
        stmt.addRule(stmt.require_any_token(new String[]{"="}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"VALUE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"%>"}));
        stmt.code("$HOSTEXPRESSION", stmt.args_names(new String[]{"VALUE"}));
        return stmt;
    }

    private Statement createIfStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("IF");
        theGrammar.addReservedWord("THEN");
        theGrammar.addReservedWord("ELSE");
        theGrammar.addReservedWord("END");
        Statement stmt = theGrammar.createStatement("IF");
        stmt.addRule(stmt.require_any_token(new String[]{"IF"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"CONDITION"}));
        stmt.addRule(stmt.require_any_token(new String[]{"THEN", ":"}));
        stmt.addRule(stmt.require_expressions(";").capture_as(new String[]{"ONTRUE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"ELSE"}).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{":"})).addRuleOnTrue(stmt.require_expressions(";").capture_as(new String[]{"ONFALSE"})));
        stmt.addRule(stmt.require_any_token(new String[]{"END"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"IF"}));
        stmt.code("IF", stmt.args_names(new String[]{"CONDITION", "ONTRUE", "ONFALSE"}));
        return stmt;
    }

    private Statement createWhileStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("WHILE");
        theGrammar.addReservedWord("BEGIN");
        theGrammar.addReservedWord("END");
        theGrammar.addReservedWord("LOOP");
        Statement stmt = theGrammar.createStatement("WHILE");
        stmt.addRule(stmt.require_any_token(new String[]{"WHILE"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"CONDITION"}));
        stmt.addRule(stmt.require_any_token(new String[]{"BEGIN", ":", "LOOP"}));
        stmt.addRule(stmt.require_expressions(";").capture_as(new String[]{"BODY"}));
        stmt.addRule(stmt.require_any_token(new String[]{"END"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHILE", "LOOP"}));
        stmt.code("WHILE", stmt.args_names(new String[]{"CONDITION", "BODY"}));
        return stmt;
    }

    private Statement createForeachStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("FOR");
        theGrammar.addReservedWord("IN");
        theGrammar.addReservedWord("END");
        theGrammar.addReservedWord("LOOP");
        Statement stmt = theGrammar.createStatement("FOREACH");
        stmt.addRule(stmt.require_any_token(new String[]{"FOR", "FOREACH"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"VAR"}));
        stmt.addRule(stmt.require_any_token(new String[]{"IN"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"ITERABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"LOOP"}));
        stmt.addRule(stmt.require_expressions(";").capture_as(new String[]{"BODY"}));
        stmt.addRule(stmt.require_any_token(new String[]{"END"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"LOOP"}));
        stmt.code("FOREACH", stmt.args_names(new String[]{"VAR", "ITERABLE", "BODY"}));
        return stmt;
    }

    private Statement createCaseStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CASE");
        theGrammar.addReservedWord("WHEN");
        theGrammar.addReservedWord("THEN");
        theGrammar.addReservedWord("ELSE");
        theGrammar.addReservedWord("END");
        Statement stmt = theGrammar.createStatement("CASE");
        stmt.addRule(stmt.require_any_token(new String[]{"CASE"}));
        stmt.addRule((Statement.Rule)stmt.repeat_until_any_tokens(new String[]{"END", "ELSE"}).addRule(stmt.require_any_token(new String[]{"WHEN"})).addRule(stmt.require_expression().capture_as(new String[]{"CONDITION#"})).addRule(stmt.require_any_token(new String[]{"THEN", ":"})).addRule(stmt.require_expressions(";").capture_as(new String[]{"ONTRUE#"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"ELSE"}).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{":"})).addRuleOnTrue(stmt.require_expressions(";").capture_as(new String[]{"ELSE"})));
        stmt.addRule(stmt.require_any_token(new String[]{"END"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"CASE"}));
        stmt.code("CASE", stmt.args_names(new String[]{"CONDITION#", "ONTRUE#", "ELSE"}));
        return stmt;
    }

    private Statement createFunctionStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CREATE");
        theGrammar.addReservedWord("FUNCTION");
        theGrammar.addReservedWord("PROCEDURE");
        theGrammar.addReservedWord("AS");
        theGrammar.addReservedWord("IS");
        theGrammar.addReservedWord("BEGIN");
        theGrammar.addReservedWord("END");
        theGrammar.addReservedWord("$$");
        Statement stmt = theGrammar.createStatement("USERFUNCTION");
        stmt.addRule(stmt.require_any_token(new String[]{"CREATE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"OR"}).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"REPLACE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"FUNCTION", "PROCEDURE"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"FUNCTION_NAME"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}));
        stmt.addRule((Statement.Rule)stmt.optional_identifiers(",").capture_as(new String[]{"PARAMETERS"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{")"}));
        stmt.addRule(stmt.require_any_token(new String[]{"AS", "IS"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"$$"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"DECLARE"}).addRuleOnTrue(stmt.require_expressions(";", new String[]{"BEGIN"}).capture_as(new String[]{"DECLARE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"BEGIN"}).addRuleOnTrue(stmt.require_expressions(";").capture_as(new String[]{"BODY"})).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"EXCEPT"}).addRuleOnTrue(stmt.require_expressions(";").capture_as(new String[]{"EXCEPT"}))).addRuleOnTrue(stmt.require_any_token(new String[]{"END"})).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"$$"})).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"FUNCTION", "PROCEDURE"})).addRuleOnFalse((Statement.Rule)stmt.optional_literal_string().capture_as(new String[]{"SCRIPT_PATH"}).addRuleOnTrue(stmt.require_any_token(new String[]{","})).addRuleOnTrue(stmt.require_literal_string().capture_as(new String[]{"SCRIPT_FUNCTION"})).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"LANGUAGE"}).addRuleOnTrue(stmt.require_literal_string().capture_as(new String[]{"LANGUAGE"})))));
        stmt.code("CREATE_FUNCTION", stmt.fixed_args_names(new String[]{"FUNCTION_NAME", "PARAMETERS", "BODY", "SCRIPT_PATH", "SCRIPT_FUNCTION", "LANGUAGE", "EXCEPT", "DECLARE"}));
        return stmt;
    }

    private Statement createLambdaStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("LAMBDA");
        Statement stmt = theGrammar.createStatement("LAMBDA");
        stmt.addRule(stmt.require_any_token(new String[]{"LAMBDA"}));
        stmt.addRule((Statement.Rule)stmt.optional_identifiers(",").capture_as(new String[]{"PARAMETERS"}));
        stmt.addRule(stmt.require_any_token(new String[]{":"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"BODY"}));
        stmt.code("CREATE_FUNCTION", stmt.fixed_args_names(new String[]{"PARAMETERS", "BODY"}));
        return stmt;
    }

    private Statement createReturnStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("RETURN");
        stmt.addRule(stmt.require_any_token(new String[]{"RETURN"}));
        stmt.addRule((Statement.Rule)stmt.optional_expression().capture_as(new String[]{"VALUES"}));
        stmt.code("RETURN", stmt.args_expand(new String[]{"VALUES"}));
        return stmt;
    }

    private Statement createBreakStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("BREAK");
        stmt.addRule(stmt.require_any_token(new String[]{"BREAK"}));
        stmt.code("BREAK", stmt.args_expand(new String[0]));
        return stmt;
    }

    private Statement createVarStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("VAR");
        stmt.addRule(stmt.require_any_token(new String[]{"VAR"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NAME"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"DEFAULT"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"VALUE"})).addRuleOnFalse(stmt.set_expression("VALUE", null)));
        stmt.code("VAR", (Statement.ArgsBuilder)new VarArgsBuilder("NAME", "VALUE"));
        return stmt;
    }

    private Statement createLet1Statement(Grammar theGrammar) {
        theGrammar.addReservedWord("SET");
        theGrammar.addReservedWord("TO");
        Statement stmt = theGrammar.createStatement("LET");
        stmt.addRule(stmt.require_any_token(new String[]{"LET", "SET"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NAME"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"=", "TO"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"VALUE"}));
        stmt.code("LET", stmt.args_names(new String[]{"NAME", "VALUE"}));
        return stmt;
    }

    private Statement createLet2Statement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("LET2");
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NAME"}));
        stmt.addRule(stmt.require_any_token(new String[]{":="}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"VALUE"}));
        stmt.code("LET", stmt.args_names(new String[]{"NAME", "VALUE"}));
        return stmt;
    }

    private Statement createSetattr1Statement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("SETATTR");
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NAME"}));
        stmt.addRule(stmt.require_any_token(new String[]{"["}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"ATTRNAME"}));
        stmt.addRule(stmt.require_any_token(new String[]{"]"}));
        stmt.addRule(stmt.require_any_token(new String[]{":="}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"VALUE"}));
        stmt.code("SETATTR", stmt.args_names(new String[]{"NAME", "ATTRNAME", "VALUE"}));
        return stmt;
    }

    private Statement createSetattr2Statement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("SETATTR");
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NAME"}));
        stmt.addRule(stmt.require_any_token(new String[]{"."}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"ATTRNAME"}));
        stmt.addRule(stmt.require_any_token(new String[]{":="}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"VALUE"}));
        stmt.code("SETATTR", stmt.args_names(new String[]{"NAME", "ATTRNAME", "VALUE"}));
        return stmt;
    }

    private Statement createArrayStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("ARRAY");
        Statement stmt = theGrammar.createStatement("ARRAY");
        stmt.addRule(stmt.require_any_token(new String[]{"ARRAY"}));
        stmt.addRule(stmt.require_any_token(new String[]{"["}));
        stmt.addRule(stmt.require_expressions(",").capture_as(new String[]{"VALUES"}));
        stmt.addRule(stmt.require_any_token(new String[]{"]"}));
        stmt.code("LIST", stmt.args_expand(new String[]{"VALUES"}));
        return stmt;
    }

    private Statement createCastStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CAST");
        theGrammar.addReservedWord("AS");
        Statement stmt = theGrammar.createStatement("CAST");
        stmt.addRule(stmt.require_any_token(new String[]{"CAST"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expression(false).capture_as(new String[]{"VALUE"})).addRuleOnTrue(stmt.require_any_token(new String[]{"AS"})).addRuleOnTrue(stmt.require_identifier().capture_as(new String[]{"TYPE"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_expression(false).capture_as(new String[]{"VALUE"})).addRuleOnFalse(stmt.require_any_token(new String[]{"AS"})).addRuleOnFalse(stmt.require_identifier().capture_as(new String[]{"TYPE"})));
        stmt.code("CAST", stmt.args_names(new String[]{"VALUE", "TYPE"}));
        return stmt;
    }

    private Statement createMatchStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("MATCH");
        Statement stmt = theGrammar.createStatement("MATCH");
        stmt.addRule(stmt.require_any_token(new String[]{"MATCH"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"VALUE"})).addRuleOnTrue(stmt.require_any_token(new String[]{","})).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"PATTERN"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_expression().capture_as(new String[]{"VALUE"})).addRuleOnFalse((Statement.Rule)stmt.optional_any_token(new String[]{","})).addRuleOnFalse(stmt.require_expression().capture_as(new String[]{"PATTERN"})));
        stmt.code("~", stmt.args_names(new String[]{"VALUE", "PATTERN"}));
        return stmt;
    }

    private Statement createDateStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("DATE");
        stmt.addRule(stmt.require_any_token(new String[]{"DATE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"EXP"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_literal_string().capture_as(new String[]{"EXP"})));
        stmt.code("DATE", stmt.args_names(new String[]{"EXP"}));
        return stmt;
    }

    private Statement createTimeStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("TIME");
        stmt.addRule(stmt.require_any_token(new String[]{"TIME"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"EXP"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_literal_string().capture_as(new String[]{"EXP"})));
        stmt.code("TIME", stmt.args_names(new String[]{"EXP"}));
        return stmt;
    }

    private Statement createImportStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("IMPORT");
        stmt.addRule(stmt.require_any_token(new String[]{"IMPORT"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"NAME"}));
        stmt.code("IMPORT", stmt.args_names(new String[]{"NAME"}));
        return stmt;
    }

    private Statement createTimestampStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("TIMESTAMP");
        stmt.addRule(stmt.require_any_token(new String[]{"TIMESTAMP"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"EXP"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_literal_string().capture_as(new String[]{"EXP"})));
        stmt.code("TIMESTAMP", stmt.args_names(new String[]{"EXP"}));
        return stmt;
    }

    private Statement createExtractStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("EXTRACT");
        stmt.addRule(stmt.require_any_token(new String[]{"EXTRACT"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_any_token(new String[]{"CENTURY", "DAY", "DECADE", "DOW", "DOY", "HOUR", "ISODOW", "ISOYEAR", "MICROSECONDS", "MILLENNIUM", "MILLUSECONDS", "MINUTE", "MONTH", "QUARTER", "SECOND", "WEEK", "YEAR"}).capture_as(new String[]{"FIELD"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"EXP"}));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.code("EXTRACT", stmt.args_names(new String[]{"FIELD", "EXP"}));
        return stmt;
    }

    private Statement createDictStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("DICT");
        stmt.addRule(stmt.require_any_token(new String[]{"{"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"}"}).addRuleOnFalse((Statement.Rule)stmt.repeat().addRule((Statement.Rule)stmt.optional_literal_string().capture_as(new String[]{"NAME#"}).addRuleOnFalse(stmt.require_identifier().capture_as(new String[]{"NAME#"}))).addRule(stmt.require_any_token(new String[]{":", "=>"})).addRule(stmt.require_expression().capture_as(new String[]{"VALUE#"})).addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnFalse(stmt.break_loop()))).addRuleOnFalse(stmt.require_any_token(new String[]{"}"})));
        stmt.code("DICT", (Statement.ArgsBuilder)new DictArgsBuilder("NAME#", "VALUE#"));
        return stmt;
    }

    private Statement createListStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("LIST");
        stmt.addRule(stmt.require_any_token(new String[]{"["}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"]"}).addRuleOnFalse((Statement.Rule)stmt.repeat().addRule(stmt.require_expression().capture_as(new String[]{"VALUE#"})).addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnFalse(stmt.break_loop()))).addRuleOnFalse(stmt.require_any_token(new String[]{"]"})));
        stmt.code("LIST", stmt.args_names(new String[]{"VALUE#"}));
        return stmt;
    }

    private Statement createPassStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("PASS");
        stmt.addRule(stmt.require_any_token(new String[]{"PASS"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expressions(",").capture_as(new String[]{"ARGS#"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})));
        stmt.code("PASS", stmt.args_names(new String[]{"ARGS#"}));
        return stmt;
    }

    private Statement createCallStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CALL");
        Statement stmt = theGrammar.createStatement("CALL");
        stmt.addRule(stmt.require_any_token(new String[]{"CALL"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"CALLABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expressions(",").capture_as(new String[]{"ARGS#"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})));
        stmt.code("CALL", stmt.args_names(new String[]{"CALLABLE", "ARGS#"}));
        return stmt;
    }

    public static class VarArgsBuilder
    implements Statement.ArgsBuilder {
        protected final String varName;
        protected final String valueName;

        public VarArgsBuilder(String varName, String valueName) {
            this.varName = varName;
            this.valueName = valueName;
        }

        public String toString() {
            return "var_args(" + this.varName + "," + this.valueName + ")";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            MutableCodes args = context.getCodeBuilder().args();
            args.add((Code)context.getCodeBuilder().identifier((String)((Code.Constant)context.getCode(this.varName)).value()));
            args.add(context.getCode(this.valueName));
            return args;
        }
    }

    private class BeginStatementBuilder
    extends DefaultStatement.StatementBuilderBase {
        private final String blockID;
        private final String exceptID;
        private final String declareID;

        public BeginStatementBuilder(String blockID, String exceptID, String declareID) {
            super("BLOCK", new DefaultStatement.ArgsBuilderFromNames(blockID));
            this.blockID = blockID;
            this.exceptID = exceptID;
            this.declareID = declareID;
        }

        @Override
        public Code build(Statement.StatementContext context) {
            Code.Callable code = (Code.Callable)super.build(context);
            Code exceptCode = context.getCode(this.exceptID);
            Code declareCode = context.getCode(this.declareID);
            if (exceptCode == null && declareCode == null) {
                return code;
            }
            DefaultCodeBuilder.BaseCodes args = (DefaultCodeBuilder.BaseCodes)code.parameters();
            args.add(exceptCode);
            args.add(declareCode);
            code = context.getCodeBuilder().function("BLOCK_EXCEPT", (Codes)args);
            return code;
        }
    }

    public static class DictArgsBuilder
    implements Statement.ArgsBuilder {
        protected final String keyName;
        protected final String valueName;

        public DictArgsBuilder(String keyName, String valueName) {
            this.keyName = keyName;
            this.valueName = valueName;
        }

        public String toString() {
            return "dict_args(" + this.keyName + "," + this.valueName + ")";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            MutableCodes args = context.getCodeBuilder().args();
            if (this.keyName.contains("#")) {
                int n = 1;
                while (true) {
                    String keyNameX = StringUtils.replace((String)this.keyName, (String)"#", (String)String.valueOf(n).trim(), (int)1);
                    String valueNameX = StringUtils.replace((String)this.valueName, (String)"#", (String)String.valueOf(n).trim(), (int)1);
                    Code keyCodeX = context.getCode(keyNameX);
                    if (keyCodeX != null) {
                        Code valueCodeX = context.getCode(valueNameX);
                        args.add(keyCodeX);
                        args.add(valueCodeX);
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                args.add((Code)context.getCodeBuilder().constant((Object)this.keyName));
                args.add(context.getCode(this.valueName));
            }
            return args;
        }
    }
}

