/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.propertypage.impl;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesPageManager
implements PropertiesPageManager {
    public static final String ACCESS_PAGE_AUTHORIZATION = "propertypage-access";
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertiesPageManager.class);
    private final Map<String, Map<String, PropertiesPageFactory>> groups = new HashMap<String, Map<String, PropertiesPageFactory>>();

    private String getFactoryName(PropertiesPageFactory factory) {
        String factoryName = factory.getClass().getName();
        try {
            factoryName = factory.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return factoryName;
    }

    public void registerFactory(PropertiesPageFactory factory) {
        logger.info("Register PropertisPageFactory " + factory.getClass().getName() + " , groupID=" + factory.getGroupID() + " (" + factory.toString() + ").");
        Map<String, PropertiesPageFactory> group = this.getFactories(factory.getGroupID());
        group.put(this.getFactoryName(factory), factory);
    }

    private Map<String, PropertiesPageFactory> getFactories(String groupID) {
        logger.info("get propeties page factories for groupID '" + groupID + "'");
        Map<String, PropertiesPageFactory> group = this.groups.get(groupID);
        if (group == null) {
            group = new HashMap<String, PropertiesPageFactory>();
            this.groups.put(groupID, group);
        }
        return group;
    }

    public List<PropertiesPage> getPages(String groupID, Object container, Object data) {
        logger.info("get propeties page for groupID '" + groupID + "', and object '" + (data == null ? "null" : data.toString()) + "'.");
        ArrayList<PropertiesPage> pages = new ArrayList<PropertiesPage>();
        SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
        SimpleIdentity currentUser = identityManager.getCurrentIdentity();
        if (!currentUser.isAuthorized(ACCESS_PAGE_AUTHORIZATION, null, groupID)) {
            return pages;
        }
        Collection<PropertiesPageFactory> factories = this.getFactories(groupID).values();
        String authorizationId = "propertypage-access-" + groupID;
        for (PropertiesPageFactory factory : factories) {
            String factoryName = this.getFactoryName(factory);
            try {
                PropertiesPage page;
                if (!factory.isVisible(data) || !currentUser.isAuthorized(authorizationId, (Object)(page = this.createPage(factory, container, data)), page.getTitle())) continue;
                pages.add(page);
            }
            catch (Throwable ex) {
                logger.warn("Can't get properties page from factory '" + factoryName + "'.", ex);
            }
        }
        Collections.sort(pages, new Comparator<PropertiesPage>(){

            @Override
            public int compare(PropertiesPage f1, PropertiesPage f2) {
                int n = f2.getPriority() - f1.getPriority();
                if (n != 0) {
                    return n;
                }
                return StringUtils.compareIgnoreCase((String)f1.getTitle(), (String)f2.getTitle());
            }
        });
        return pages;
    }

    private PropertiesPage createPage(PropertiesPageFactory factory, Object container, Object data) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            PropertiesPage page = factory.create(container, data);
            return page;
        }
        catch (AbstractMethodError abstractMethodError) {
            Method method = factory.getClass().getMethod("create", Object.class);
            PropertiesPage page = (PropertiesPage)method.invoke((Object)factory, data);
            return page;
        }
    }

    public ActionEvent createSetPageEnableEvent(PropertiesPage source, Invocable filter, boolean enabled) {
        return new DefaultSetPageEnabledEvent((Object)source, filter, enabled);
    }

    public ActionEvent createSetPageEnableEvent(PropertiesPage source, final Class filterClass, boolean enabled) {
        return new DefaultSetPageEnabledEvent((Object)source, new Invocable(){

            public Object call(Object ... propertiesPages) {
                return filterClass.isInstance(propertiesPages[0]);
            }
        }, enabled);
    }

    private static class DefaultSetPageEnabledEvent
    extends ActionEvent {
        private Invocable filter;
        private boolean enabled;

        public DefaultSetPageEnabledEvent(Object source, Invocable filter, boolean enabled) {
            super(source, -889323519, "SetPageEnabled");
            this.filter = filter;
            this.enabled = enabled;
        }

        public Invocable getFilter() {
            return this.filter;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

