/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.wizard;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.gui.beans.wizard.panel.NotContinueWizardException;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProgressWizardPage
extends DefaultProgressPanel
implements OptionPanel {
    private static final long serialVersionUID = -7064334977678611609L;
    private static final Logger logger = LoggerFactory.getLogger(DownloadProgressWizardPage.class);
    private final InstallWizardPanel_ext wizardPanel;

    public DownloadProgressWizardPage(InstallWizardPanel_ext wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.wizardPanel.getTranslation("_download_progress");
    }

    public void lastPanel() {
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
    }

    public void nextPanel() throws NotContinueWizardException {
    }

    public void updatePanel() {
        if (this.wizardPanel.getDirection() == 0) {
            this.wizardPanel.skip();
            return;
        }
        boolean AreTherePackagesToDownload = false;
        this.wizardPanel.setNextButtonEnabled(false);
        this.wizardPanel.setBackButtonEnabled(false);
        this.wizardPanel.setFinishButtonEnabled(false);
        InstallPackageService service = this.wizardPanel.getInstallerExecutionService();
        service.getPackageCount();
        List<PackageInfo> packagesToInstall = this.wizardPanel.getPackagesToInstall();
        for (PackageInfo packageToInstall : packagesToInstall) {
            if (packageToInstall.getDownloadURL() == null) continue;
            AreTherePackagesToDownload = true;
            break;
        }
        if (!AreTherePackagesToDownload) {
            this.wizardPanel.skip();
        }
        UpdatePanel task = new UpdatePanel(this);
        this.wizardPanel.addCancellableTask((CancellableTask)task);
        this.bind(task.getTaskStatus());
        task.setDaemon(true);
        task.start();
    }

    private String getText(String key) {
        return this.wizardPanel.getTranslation(key);
    }

    private static synchronized void showNotDownloaded(List<String> names) {
        int sz = names.size();
        String list_str = "";
        for (int i = 0; i < sz; ++i) {
            list_str = list_str + "\n - " + names.get(i);
        }
        list_str = Messages.getText((String)"_These_packages_not_downloaded") + ":\n" + list_str + "\n";
        ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(list_str, Messages.getText((String)"_Warning"), 2);
    }

    private static class UpdatePanel
    extends AbstractMonitorableTask {
        private final DownloadProgressWizardPage panel;

        public UpdatePanel(DownloadProgressWizardPage panel) {
            super(panel.getText("_downloading_files"));
            this.panel = panel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            SimpleTaskStatus taskStatus = (SimpleTaskStatus)this.getTaskStatus();
            final ArrayList<String> not_downloaded = new ArrayList<String>();
            try {
                List<PackageInfo> packagesToInstall = this.panel.wizardPanel.getPackagesToInstall();
                InstallPackageService installerService = this.panel.wizardPanel.getInstallerExecutionService();
                taskStatus.setRangeOfValues(0L, (long)packagesToInstall.size());
                for (int i = 0; i < packagesToInstall.size(); ++i) {
                    taskStatus.setCurValue((long)i);
                    PackageInfo packageInfo = packagesToInstall.get(i);
                    taskStatus.message(packageInfo.getName());
                    if (packageInfo.getDownloadURL() != null) {
                        try {
                            installerService.downloadPackage(packageInfo, taskStatus);
                        }
                        catch (Exception e) {
                            not_downloaded.add(packageInfo.getName());
                            logger.info("Can't download package '" + packageInfo.getName() + "'.", (Throwable)e);
                        }
                    }
                    if (not_downloaded.size() > 0) break;
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (not_downloaded.isEmpty()) {
                            panel.wizardPanel.setNextButtonEnabled(true);
                            panel.wizardPanel.doAction(1);
                        } else {
                            panel.wizardPanel.setNextButtonEnabled(false);
                        }
                        panel.wizardPanel.setBackButtonEnabled(true);
                    }
                });
            }
            catch (Exception ex) {
                logger.warn("Problems downloading packages.", (Throwable)ex);
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(this.panel.getText("_Cant_download_packages"), this.panel.getText("_Warning"), 2);
            }
            finally {
                if (not_downloaded.isEmpty()) {
                    taskStatus.message(this.panel.getText("_finished"));
                } else {
                    taskStatus.message(this.panel.getText("_finished_Some_files_not_downloaded"));
                    DownloadProgressWizardPage.showNotDownloaded(not_downloaded);
                }
                taskStatus.terminate();
                taskStatus.remove();
            }
        }
    }
}

