/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.StringTokenizer;
import org.gvsig.installer.lib.impl.utils.MD5BinaryFileUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download
extends AbstractMonitorableTask {
    private static final Logger LOG = LoggerFactory.getLogger(Download.class);
    private static final int FILE_SIZE_ESTIMATED_MINIMUM = 10000;
    private static final double FILE_SIZE_ESTIMATED_RATIO = 0.85;
    private boolean selfCreatedTaskStatus = true;

    public Download(SimpleTaskStatus taskStatus) {
        this();
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        manager.remove(this.getTaskStatus());
        this.taskStatus = taskStatus;
        this.selfCreatedTaskStatus = false;
    }

    public Download() {
        super("Downloading...");
    }

    public File downloadFile(URL url, String defaultFileName) throws IOException {
        String urlStr;
        URL downloadURL = url;
        if (defaultFileName != null && (urlStr = url.toString()).endsWith("/")) {
            urlStr = urlStr.concat(defaultFileName);
            downloadURL = new URL(urlStr);
        }
        URLConnection connection = downloadURL.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(20000);
        String fileName = this.getFileName(connection);
        Date date = new Date(connection.getLastModified());
        LOG.info("Downloading file {} from URL {}, with last modified date: {}", new Object[]{fileName, downloadURL, date});
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        File localFile = foldersManager.getUniqueTemporaryFile(new String[]{fileName});
        BufferedInputStream bis = new BufferedInputStream(connection.getInputStream());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(localFile));
        int expected_size = connection.getContentLength();
        this.taskStatus.setRangeOfValues(0L, (long)expected_size);
        byte[] data = new byte[1024];
        int count = 0;
        long totalCount = 0L;
        while ((count = bis.read(data, 0, 1024)) >= 0) {
            bos.write(data, 0, count);
            this.taskStatus.setCurValue(totalCount += (long)count);
            if (!this.taskStatus.isCancellationRequested()) continue;
        }
        try {
            bis.close();
            bos.flush();
            bos.close();
        }
        catch (Exception ex) {
            LOG.info("Error while closing download streams: " + ex.getMessage());
        }
        if (this.selfCreatedTaskStatus) {
            this.taskStatus.terminate();
            this.taskStatus.remove();
        }
        if (this.taskStatus.isCancellationRequested()) {
            return null;
        }
        String md5_ = MD5BinaryFileUtils.getMD5InRemoteFile(downloadURL);
        if (md5_ != null) {
            String local_md5 = null;
            try {
                local_md5 = MD5BinaryFileUtils.getMD5Checksum(localFile);
            }
            catch (Exception e) {
                throw new IOException("Unable to get MD5 for file: " + downloadURL.toString());
            }
            if (local_md5.compareTo(md5_) != 0) {
                throw new IOException("MD5 does not match for file: " + downloadURL.toString());
            }
        } else if (!Download.acceptableFileSize(localFile, expected_size)) {
            throw new IOException("Bad download file size (" + localFile.length() + " / " + expected_size + ")");
        }
        return localFile;
    }

    private String getFileName(URLConnection urlConnection) throws IOException {
        String fileName = null;
        String contentDisposition = urlConnection.getHeaderField("content-disposition");
        if (contentDisposition != null) {
            fileName = this.extractFileNameFromContentDisposition(contentDisposition);
        }
        if (fileName == null) {
            StringTokenizer st = new StringTokenizer(urlConnection.getURL().getFile(), "/");
            while (st.hasMoreTokens()) {
                fileName = st.nextToken();
            }
        }
        return fileName;
    }

    private String extractFileNameFromContentDisposition(String contentDisposition) {
        String[] attributes;
        for (String a : attributes = contentDisposition.split(";")) {
            if (!a.toLowerCase().contains("filename")) continue;
            return a.substring(a.indexOf(34) + 1, a.lastIndexOf(34));
        }
        return null;
    }

    public static boolean acceptableFileSize(File f, int estimated_size) {
        if (f == null) {
            return false;
        }
        if (estimated_size == -1) {
            return true;
        }
        if (estimated_size < 10000) {
            return true;
        }
        return (double)f.length() > 0.85 * (double)estimated_size;
    }
}

