/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaButtonUI;
import ch.randelshofer.quaqua.QuaquaColorWellBorder;
import ch.randelshofer.quaqua.QuaquaToolBarButtonStateBorder;
import ch.randelshofer.quaqua.QuaquaToolBarTabButtonBorder;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.border.AnimatedBorder;
import ch.randelshofer.quaqua.border.ButtonStateBorder;
import ch.randelshofer.quaqua.border.CompositeVisualMarginBorder;
import ch.randelshofer.quaqua.border.FocusBorder;
import ch.randelshofer.quaqua.border.OverlayBorder;
import ch.randelshofer.quaqua.border.PressedCueBorder;
import ch.randelshofer.quaqua.border.VisualMarginBorder;
import ch.randelshofer.quaqua.osx.OSXAquaPainter;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class QuaquaButtonBorder
implements Border,
PressedCueBorder,
UIResource {
    private static Border regularPushButtonBorder;
    private static Border smallPushButtonBorder;
    private static Border squareBorder;
    private static Border placardBorder;
    private static Border colorWellBorder;
    private static Border bevelBorder;
    private static Border toolBarBorder;
    private static Border toolBarRolloverBorder;
    private static Border toolBarTabBorder;
    private static Border toggleWestBorder;
    private static Border toggleEastBorder;
    private static Border toggleCenterBorder;
    private static Border toggleBorder;
    private static Border helpBorder;
    private static Border tableHeaderBorder;
    private String defaultStyle;

    public QuaquaButtonBorder(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public Border getActualBorder(Component c) {
        String segpos;
        Border b = null;
        String style = this.getStyle(c);
        JComponent jc = c instanceof JComponent ? (JComponent)c : null;
        String string = segpos = jc == null ? "only" : (String)jc.getClientProperty("JButton.segmentPosition");
        if ("toggleEast".equals(style)) {
            segpos = "first";
        } else if ("toggleCenter".equals(style)) {
            segpos = "middle";
        } else if ("toggleWest".equals(style)) {
            segpos = "last";
        }
        if (segpos == null || !"first".equals(segpos) && !"middle".equals(segpos) && "last".equals(segpos)) {
            segpos = "only";
        }
        if ("text".equals(style) || "push".equals(style)) {
            switch (QuaquaUtilities.getSizeVariant(c)) {
                case SMALL: 
                case MINI: {
                    b = this.getSmallPushButtonBorder();
                    break;
                }
                default: {
                    b = this.getRegularPushButtonBorder();
                    break;
                }
            }
        } else if ("toolBar".equals(style)) {
            if (toolBarBorder == null) {
                toolBarBorder = new CompositeVisualMarginBorder(new CompoundBorder(new EmptyBorder(-1, -1, -1, -2), new QuaquaToolBarButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), new Insets(4, 6, 4, 6), true, false)), 0, 0, 0, 0);
            }
            b = toolBarBorder;
        } else if ("toolBarRollover".equals(style)) {
            if (toolBarRolloverBorder == null) {
                toolBarRolloverBorder = new CompositeVisualMarginBorder(new CompoundBorder(new EmptyBorder(-1, -1, -1, -2), new QuaquaToolBarButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), new Insets(4, 6, 4, 6), true, true)), 0, 0, 0, 0);
            }
            b = toolBarRolloverBorder;
        } else if ("toolBarTab".equals(style)) {
            if (toolBarTabBorder == null) {
                toolBarTabBorder = new QuaquaToolBarTabButtonBorder();
            }
            b = toolBarTabBorder;
        } else if ("square".equals(style) || "toolbar".equals(style)) {
            b = this.getSquareBorder();
        } else if ("gradient".equals(style)) {
            b = this.getPlacardBorder();
        } else if ("tableHeader".equals(style)) {
            b = this.getTableHeaderBorder();
        } else if ("colorWell".equals(style)) {
            if (colorWellBorder == null) {
                colorWellBorder = new CompositeVisualMarginBorder(new OverlayBorder(new QuaquaColorWellBorder(), new CompoundBorder(new EmptyBorder(-2, -2, -2, -2), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true)))), 0, 0, 0, 0);
            }
            b = colorWellBorder;
        } else if ("icon".equals(style) || "bevel".equals(style)) {
            if (bevelBorder == null) {
                Insets borderInsets = new Insets(4, 3, 3, 3);
                FocusBorder focusBorder = new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/RoundedBevel.focusRing.png")), new Insets(10, 9, 10, 8), borderInsets, true));
                bevelBorder = new CompositeVisualMarginBorder(new CompoundBorder(new EmptyBorder(-3, -2, -2, -2), new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/RoundedBevel.borders.png")), 10, true, new Insets(10, 9, 10, 8), borderInsets, true), new CompoundBorder(new EmptyBorder(0, -1, 0, -1), focusBorder))), 0, 0, 0, 0);
            }
            b = bevelBorder;
        } else if ("only".equals(segpos) && ("toggle".equals(style) || "segmented".equals(style) || "segmentedRoundRect".equals(style) || "segmentedCapsule".equals(style) || style.contains("segmentedTextured"))) {
            if (toggleBorder == null) {
                Insets borderInsets = new Insets(3, 5, 3, 5);
                toggleBorder = new CompositeVisualMarginBorder(new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.focusRing.png")), new Insets(8, 10, 15, 10), borderInsets, false))), 2, 2, 2, 2);
            }
            b = toggleBorder;
        } else if ("first".equals(segpos) || "toggleEast".equals(style)) {
            if (toggleEastBorder == null) {
                Insets borderInsets = new Insets(3, 1, 3, 5);
                toggleEastBorder = new CompositeVisualMarginBorder(new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.east.borders.png")), 10, true, new Insets(8, 1, 15, 10), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.east.focusRing.png")), new Insets(8, 4, 15, 10), borderInsets, false))), 2, 0, 2, 2, false, true, false, false);
            }
            b = toggleEastBorder;
        } else if ("middle".equals(segpos) || "toggleCenter".equals(style)) {
            if (toggleCenterBorder == null) {
                Insets borderInsets = new Insets(3, 1, 3, 1);
                toggleCenterBorder = new CompositeVisualMarginBorder(new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.center.borders.png")), 10, true, new Insets(8, 0, 15, 1), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.center.focusRing.png")), new Insets(8, 4, 15, 4), borderInsets, false))), 2, 0, 2, 0, false, true, false, true);
            }
            b = toggleCenterBorder;
        } else if ("last".equals(segpos) || "toggleWest".equals(style)) {
            if (toggleWestBorder == null) {
                Insets borderInsets = new Insets(3, 5, 3, 1);
                toggleWestBorder = new CompositeVisualMarginBorder(new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.west.borders.png")), 10, true, new Insets(8, 10, 15, 1), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.west.focusRing.png")), new Insets(8, 10, 15, 4), borderInsets, false))), 2, 2, 2, 0, false, false, false, true);
            }
            b = toggleWestBorder;
        } else if ("help".equals(style)) {
            if (helpBorder == null) {
                helpBorder = new VisualMarginBorder(2, 3, 2, 3);
            }
            b = helpBorder;
        } else if (c.getParent() instanceof JToolBar) {
            b = this.getSquareBorder();
        } else {
            switch (QuaquaUtilities.getSizeVariant(c)) {
                case SMALL: 
                case MINI: {
                    b = this.getSmallPushButtonBorder();
                    break;
                }
                default: {
                    b = this.getRegularPushButtonBorder();
                }
            }
        }
        if (b == null) {
            throw new InternalError(style);
        }
        return b;
    }

    private Border getRegularPushButtonBorder() {
        if (regularPushButtonBorder == null) {
            Insets borderInsets = new Insets(1, 5, 1, 5);
            BufferedImage[] imageFrames = Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.default.png")), 12, true);
            Border[] borderFrames = new Border[12];
            for (int i = 0; i < 12; ++i) {
                borderFrames[i] = QuaquaBorderFactory.create((Image)imageFrames[i], new Insets(11, 13, 13, 13), borderInsets, true);
            }
            ButtonStateBorder buttonStateBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.borders.png")), 10, true), new Insets(11, 13, 13, 13), borderInsets, true);
            buttonStateBorder.setBorder(10, new AnimatedBorder(borderFrames, 100L));
            regularPushButtonBorder = new CompositeVisualMarginBorder(new OverlayBorder(buttonStateBorder, new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.focusRing.png")), new Insets(12, 13, 12, 13), borderInsets, false))), 2, 4, 2, 4);
        }
        return regularPushButtonBorder;
    }

    private Border getSquareBorder() {
        if (squareBorder == null) {
            squareBorder = new CompositeVisualMarginBorder(new OverlayBorder(QuaquaBorderFactory.createSquareButtonBorder(), new CompoundBorder(new EmptyBorder(-2, -2, -2, -2), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true)))), 0, 0, 0, 0){

                @Override
                protected Insets getVisualMargin(Component c, Insets insets) {
                    String s = QuaquaButtonBorder.this.getStyle(c);
                    insets = super.getVisualMargin(c, new InsetsUIResource(0, 0, 0, 0));
                    if (insets instanceof UIResource) {
                        switch (QuaquaButtonBorder.this.getSegmentPosition(c)) {
                            case first: {
                                insets.right = -1;
                                break;
                            }
                            case middle: {
                                insets.left = 0;
                                insets.right = -1;
                                break;
                            }
                            case last: {
                                insets.left = 0;
                            }
                        }
                    }
                    return insets;
                }
            };
        }
        return squareBorder;
    }

    private Border getPlacardBorder() {
        if (placardBorder == null) {
            placardBorder = new CompositeVisualMarginBorder(new OverlayBorder(new CompoundBorder(new EmptyBorder(-1, 0, -1, 0), QuaquaBorderFactory.createPlacardButtonBorder()), new CompoundBorder(new EmptyBorder(-1, -1, -1, -1), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true)))), 0, 0, 0, 0){

                @Override
                protected Insets getVisualMargin(Component c, Insets insets) {
                    String ts;
                    String s = QuaquaButtonBorder.this.getStyle(c);
                    insets = super.getVisualMargin(c, new InsetsUIResource(0, 0, 0, 0));
                    if (insets instanceof UIResource && "gradient".equals(s) && c.getParent() instanceof JToolBar && (ts = (String)((JToolBar)c.getParent()).getClientProperty("Quaqua.ToolBar.style")) != null && ("placard".equals(ts) || "gradient".equals(ts))) {
                        InsetsUtil.clear(insets);
                    }
                    if (insets instanceof UIResource) {
                        switch (QuaquaButtonBorder.this.getSegmentPosition(c)) {
                            case first: {
                                insets.right = -1;
                                break;
                            }
                            case middle: {
                                insets.left = 0;
                                insets.right = -1;
                                break;
                            }
                            case last: {
                                insets.left = 0;
                            }
                        }
                    }
                    return insets;
                }
            };
        }
        return placardBorder;
    }

    private Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new CompositeVisualMarginBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/TableHeader.borders.png")), 4, true, new Insets(7, 1, 8, 1), new Insets(1, 2, 1, 2), true), 0, 0, 0, 0);
        }
        return tableHeaderBorder;
    }

    private Border getSmallPushButtonBorder() {
        if (smallPushButtonBorder == null) {
            Insets borderInsets = new Insets(3, 8, 3, 8);
            BufferedImage[] imageFrames = Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.default.png")), 12, true);
            Border[] borderFrames = new Border[12];
            for (int i = 0; i < 12; ++i) {
                borderFrames[i] = QuaquaBorderFactory.create((Image)imageFrames[i], new Insets(9, 13, 12, 13), borderInsets, true);
            }
            ButtonStateBorder buttonStateBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.borders.png")), 10, true), new Insets(9, 13, 12, 13), borderInsets, true);
            buttonStateBorder.setBorder(10, new AnimatedBorder(borderFrames, 100L));
            smallPushButtonBorder = new CompositeVisualMarginBorder(new CompoundBorder(new EmptyBorder(-2, -3, -2, -3), new OverlayBorder(buttonStateBorder, new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.focusRing.png")), new Insets(9, 14, 12, 14), borderInsets, false)))), 0, 0, 0, 0);
        }
        return smallPushButtonBorder;
    }

    public Insets getDefaultMargin(JComponent c) {
        boolean isSmall;
        Insets margin = null;
        String style = this.getStyle(c);
        QuaquaUtilities.SizeVariant sizeVariant = QuaquaUtilities.getSizeVariant(c);
        boolean bl = isSmall = sizeVariant == QuaquaUtilities.SizeVariant.SMALL || sizeVariant == QuaquaUtilities.SizeVariant.MINI;
        margin = "text".equals(style) || "push".equals(style) ? (isSmall ? new Insets(1, 3, 1, 3) : new Insets(1, 6, 2, 6)) : ("toolBar".equals(style) ? new Insets(0, 0, 0, 0) : ("toolBarRollover".equals(style) ? new Insets(0, 0, 0, 0) : ("toolBarTab".equals(style) ? new Insets(0, 0, 0, 0) : ("square".equals(style) ? (isSmall ? new Insets(3, 6, 3, 6) : new Insets(3, 6, 3, 6)) : ("gradient".equals(style) ? (isSmall ? new Insets(2, 6, 2, 6) : new Insets(2, 6, 2, 6)) : ("colorWell".equals(style) ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : ("icon".equals(style) || "bevel".equals(style) ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : ("toggle".equals(style) ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : ("toggleEast".equals(style) ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : ("toggleCenter".equals(style) ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : ("toggleWest".equals(style) ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : ("help".equals(style) ? new Insets(0, 0, 0, 0) : (c.getParent() instanceof JToolBar ? new Insets(0, 0, 0, 0) : (isSmall ? new Insets(1, 4, 1, 4) : new Insets(1, 8, 2, 8)))))))))))))));
        return margin;
    }

    public boolean isFixedHeight(JComponent c) {
        String style = this.getStyle(c).toLowerCase();
        return "text".equals(style) || "push".equals(style) || style.startsWith("toggle");
    }

    protected String getStyle(Component c) {
        return QuaquaButtonUI.getStyle(c, this.defaultStyle);
    }

    @Override
    public boolean hasPressedCue(JComponent c) {
        boolean bl;
        Border b = this.getActualBorder(c);
        if (b instanceof PressedCueBorder) {
            bl = ((PressedCueBorder)b).hasPressedCue(c);
        }
        bl = b != toolBarBorder;
        return bl;
    }

    public Insets getVisualMargin(Component c) {
        return ((VisualMargin)this.getActualBorder(c)).getVisualMargin(c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        JComponent jc;
        Insets insets;
        if (c instanceof JComponent && (insets = (Insets)(jc = (JComponent)c).getClientProperty("Quaqua.Border.insets")) != null) {
            return (Insets)insets.clone();
        }
        boolean isBorderPainted = true;
        if (c instanceof AbstractButton) {
            isBorderPainted = ((AbstractButton)c).isBorderPainted();
        }
        insets = !isBorderPainted ? (Insets)UIManager.getInsets("Component.visualMargin").clone() : this.getActualBorder((JComponent)c).getBorderInsets(c);
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Insets margin = b.getMargin();
            if ((margin == null || margin instanceof UIResource) && isBorderPainted) {
                margin = this.getDefaultMargin((JComponent)c);
            }
            if (margin != null) {
                InsetsUtil.addTo(margin, insets);
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.getActualBorder((JComponent)c).paintBorder(c, g, x, y, width, height);
    }

    private OSXAquaPainter.SegmentPosition getSegmentPosition(Component c) {
        String s = null;
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            s = (String)jc.getClientProperty("Quaqua.Button.style");
            if (s != null) {
                if ("toggleWest".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.first;
                }
                if ("toggleCenter".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.middle;
                }
                if ("toggleEast".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.last;
                }
            }
            if ((s = (String)jc.getClientProperty("JButton.segmentPosition")) != null) {
                if ("first".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.first;
                }
                if ("middle".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.middle;
                }
                if ("last".equals(s)) {
                    return OSXAquaPainter.SegmentPosition.last;
                }
            }
        }
        return OSXAquaPainter.SegmentPosition.only;
    }
}

