/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther;

import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class QuaquaPantherSeparatorUI
extends BasicSeparatorUI
implements VisuallyLayoutable {
    public static ComponentUI createUI(JComponent c) {
        return new QuaquaPantherSeparatorUI();
    }

    @Override
    protected void installDefaults(JSeparator s) {
        super.installDefaults(s);
        LookAndFeel.installBorder(s, "Separator.border");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        if (c.getParent() instanceof JPopupMenu) {
            Color highlightColor = UIManager.getColor("Separator.highlight");
            Color shadowColor = UIManager.getColor("Separator.shadow");
            if (((JSeparator)c).getOrientation() == 1) {
                g.setColor(highlightColor);
                g.drawLine(s.width / 2 - 1, 1, s.width / 2 - 1, s.height - 2);
                g.setColor(shadowColor);
                g.drawLine(s.width / 2, 1, s.width / 2, s.height - 2);
            } else {
                g.setColor(highlightColor);
                g.drawLine(1, s.height / 2 - 1, s.width - 2, s.height / 2 - 1);
                g.setColor(shadowColor);
                g.drawLine(1, s.height / 2, s.width - 2, s.height / 2);
            }
        } else {
            Insets insets = c.getInsets();
            Color highlightColor = UIManager.getColor("Separator.foreground");
            Color shadowColor = UIManager.getColor("Separator.background");
            if (((JSeparator)c).getOrientation() == 1) {
                g.setColor(highlightColor);
                g.drawLine(insets.left, insets.top, insets.left, s.height - insets.bottom - 1);
                g.setColor(shadowColor);
                g.drawLine(insets.left + 1, insets.top, insets.left + 1, s.height - insets.bottom - 1);
            } else {
                g.setColor(highlightColor);
                g.drawLine(insets.left, insets.top, s.width - insets.right - 1, insets.top);
                g.setColor(shadowColor);
                g.drawLine(insets.left, insets.top + 1, s.width - insets.right - 1, insets.top + 1);
            }
        }
        Debug.paint(g, c, this);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JPopupMenu) {
            if (((JSeparator)c).getOrientation() == 1) {
                return new Dimension(12, 0);
            }
            return new Dimension(0, 12);
        }
        Insets insets = c.getInsets();
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2 + insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, 2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        if (((JSeparator)c).getOrientation() == 1) {
            d.height = Integer.MAX_VALUE;
        } else {
            d.width = Integer.MAX_VALUE;
        }
        return d;
    }

    public Insets getVisualMargin(JSeparator tc) {
        Insets margin = (Insets)tc.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : margin;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return -1;
    }

    @Override
    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JSeparator b = (JSeparator)c;
        InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
        return bounds;
    }
}

