/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import com.sardak.antform.util.CSVReader;
import com.sardak.antform.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckGroupBox
extends JPanel {
    private List buttons = new ArrayList();
    private String separator;
    private String escapeSequence;

    private CheckGroupBox() {
    }

    public CheckGroupBox(String[] values, String separator, String escapeSequence, int columns) {
        this.separator = separator;
        this.escapeSequence = escapeSequence;
        this.setLayout(new GridLayout(0, columns));
        for (int i = 0; i < values.length; ++i) {
            JCheckBox button = new JCheckBox(values[i]);
            this.add(button);
            this.buttons.add(button);
        }
    }

    public Font getFont() {
        Font font = null;
        if (this.buttons != null && this.buttons.size() > 0) {
            font = ((Component)this.buttons.get(0)).getFont();
        }
        return font;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JCheckBox button = (JCheckBox)iter.next();
                button.setFont(font);
            }
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JCheckBox button = (JCheckBox)iter.next();
                button.setBackground(bg);
            }
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JCheckBox button = (JCheckBox)iter.next();
                button.setForeground(fg);
            }
        }
    }

    public void setValue(String value) {
        CSVReader reader = new CSVReader(this.separator, this.escapeSequence);
        List valueList = value == null ? new ArrayList() : reader.digest(value, true);
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            JCheckBox checkBox = (JCheckBox)iterator.next();
            checkBox.setSelected(valueList.contains(checkBox.getText()));
        }
    }

    public String getValue() {
        String local = "";
        if (this.buttons != null) {
            int counter = -1;
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                ++counter;
                JCheckBox button = (JCheckBox)iter.next();
                String text = button.getText();
                if (!button.isSelected()) continue;
                if (local.length() > 0) {
                    local = local + this.separator;
                }
                text = StringUtil.searchReplace(text, this.escapeSequence, this.escapeSequence + this.escapeSequence);
                text = StringUtil.searchReplace(text, this.separator, this.escapeSequence + this.separator);
                local = local + text;
            }
        }
        return local;
    }

    public int getSelectedIndex() {
        int local = -1;
        if (this.buttons != null) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                JCheckBox button = (JCheckBox)this.buttons.get(i);
                if (!button.isSelected()) continue;
                local = i;
            }
        }
        return local;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.buttons != null) {
            Iterator iter = this.buttons.iterator();
            while (iter.hasNext()) {
                JCheckBox button = (JCheckBox)iter.next();
                button.setEnabled(enabled);
            }
        }
    }
}

