/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynobject;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItemByKeyWithSizeAndGetKeys;
import org.gvsig.tools.util.GetItemWithSize;
import org.gvsig.tools.util.LabeledValue;

public class DynObjectUtils {
    private DynObjectUtils() {
    }

    private static Pair<String, String> findLabelAndValueNames(Collection<String> col) {
        Iterator<String> it;
        String labelname = null;
        String valuename = null;
        for (String theName : new String[]{"$label", "name", "label", "key", "description"}) {
            if (col.contains(theName)) {
                labelname = theName;
                break;
            }
            if (!col.contains(theName.toUpperCase())) continue;
            labelname = theName.toLowerCase();
            break;
        }
        for (String theName : new String[]{"$value", "value", "id", "code"}) {
            if (col.contains(theName)) {
                valuename = theName;
                break;
            }
            if (!col.contains(theName.toUpperCase())) continue;
            valuename = theName.toLowerCase();
            break;
        }
        if (valuename == null) {
            if (labelname == null) {
                it = col.iterator();
                switch (col.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        valuename = labelname = it.next();
                        break;
                    }
                    default: {
                        labelname = it.next();
                        valuename = it.next();
                        break;
                    }
                }
            } else {
                it = col.iterator();
                switch (col.size()) {
                    case 0: 
                    case 1: {
                        valuename = labelname;
                        break;
                    }
                    default: {
                        String s1 = it.next();
                        String s2 = it.next();
                        if (StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)labelname)) {
                            valuename = s2;
                            break;
                        }
                        valuename = s1;
                        break;
                    }
                }
            }
        } else if (labelname == null) {
            it = col.iterator();
            switch (col.size()) {
                case 0: 
                case 1: {
                    labelname = valuename;
                    break;
                }
                default: {
                    String s1 = it.next();
                    String s2 = it.next();
                    labelname = StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)valuename) ? s2 : s1;
                }
            }
        }
        return new ImmutablePair((Object)labelname, valuename);
    }

    public static DynObjectValueItem[] getAvailableValuesFrom(GetItemWithSize values) {
        if (values.size() == 0) {
            return new DynObjectValueItem[0];
        }
        DynObjectValueItem[] r = null;
        Object firstelement = values.get(0);
        if (firstelement instanceof LabeledValue) {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                LabeledValue v = (LabeledValue)values.get(i);
                r[i] = new DynObjectValueItem(v.getValue(), Objects.toString(v.getLabel(), Objects.toString(v.getValue(), String.valueOf(i))));
            }
        } else if (firstelement instanceof DynObjectValueItem) {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                LabeledValue v = (LabeledValue)values.get(i);
                r[i] = new DynObjectValueItem(v.getValue(), v.getLabel());
            }
        } else if (firstelement instanceof Pair) {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Pair v = (Pair)values.get(i);
                r[i] = new DynObjectValueItem(v.getValue(), Objects.toString(v.getKey(), Objects.toString(v.getValue(), String.valueOf(i))));
            }
        } else if (firstelement instanceof JsonObject) {
            JsonObject v = (JsonObject)firstelement;
            Pair<String, String> names = DynObjectUtils.findLabelAndValueNames(v.keySet());
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                v = (JsonObject)values.get(i);
                String theLabel = names.getKey() == null ? v.toString() : v.getString((String)names.getKey());
                Object theValue = names.getValue() == null ? v.getString((String)names.getValue()) : v;
                r[i] = new DynObjectValueItem(theValue, theLabel);
            }
        } else if (firstelement instanceof Map) {
            Map v = (Map)firstelement;
            Pair<String, String> names = DynObjectUtils.findLabelAndValueNames(v.keySet());
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                v = (Map)values.get(i);
                String theLabel = names.getKey() == null ? Objects.toString(v) : Objects.toString(v.get(names.getKey()));
                Map theValue = names.getValue() == null ? v : v.get(names.getValue());
                r[i] = new DynObjectValueItem(theValue, theLabel);
            }
        } else if (firstelement instanceof GetItemByKeyWithSizeAndGetKeys) {
            GetItemByKeyWithSizeAndGetKeys v = (GetItemByKeyWithSizeAndGetKeys)firstelement;
            Pair<String, String> names = DynObjectUtils.findLabelAndValueNames(v.getKeys());
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                v = (GetItemByKeyWithSizeAndGetKeys)values.get(i);
                String theLabel = names.getKey() == null ? Objects.toString(v) : Objects.toString(v.get(names.getKey()));
                GetItemByKeyWithSizeAndGetKeys theValue = names.getValue() == null ? v : v.get(names.getValue());
                r[i] = new DynObjectValueItem(theValue, theLabel);
            }
        } else if (firstelement instanceof Collection) {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Object v = values.get(i);
                Iterator it = ((Collection)v).iterator();
                String theLabel = null;
                Object theValue = null;
                if (it.hasNext()) {
                    theLabel = Objects.toString(it.next(), "NULL");
                    if (it.hasNext()) {
                        theValue = it.next();
                    }
                }
                r[i] = new DynObjectValueItem(theValue, theLabel);
            }
        } else if (firstelement instanceof Object[]) {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                Object[] v = (Object[])values.get(i);
                String theLabel = null;
                Object theValue = null;
                switch (v.length) {
                    case 1: {
                        theLabel = Objects.toString(v[0]);
                        theValue = v[0];
                        break;
                    }
                    case 2: {
                        theLabel = Objects.toString(v[0]);
                        theValue = v[1];
                    }
                }
                r[i] = new DynObjectValueItem(theValue, theLabel);
            }
        } else {
            r = new DynObjectValueItem[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                r[i] = new DynObjectValueItem(values.get(i), Objects.toString(values.get(i), "NULL"));
            }
        }
        return r;
    }

    public static DynObjectValueItem[] getAvailableValuesFrom(DynObjectValueItem[] values) {
        return values;
    }

    public static DynObjectValueItem[] getAvailableValuesFrom(final List values) {
        return DynObjectUtils.getAvailableValuesFrom(new GetItemWithSize(){

            @Override
            public Object get(int i) {
                return values.get(i);
            }

            @Override
            public int size() {
                return values.size();
            }
        });
    }

    public static DynObjectValueItem[] getAvailableValuesFrom(final Object[] values) {
        return DynObjectUtils.getAvailableValuesFrom(new GetItemWithSize(){

            @Override
            public Object get(int i) {
                return values[i];
            }

            @Override
            public int size() {
                return values.length;
            }
        });
    }

    public static DynObjectValueItem[] getAvailableValuesFrom(Object values) {
        if (values instanceof DynObjectValueItem[]) {
            return DynObjectUtils.getAvailableValuesFrom((DynObjectValueItem[])values);
        }
        if (values instanceof Object[]) {
            return DynObjectUtils.getAvailableValuesFrom((Object[])values);
        }
        if (values instanceof List) {
            return DynObjectUtils.getAvailableValuesFrom((List)values);
        }
        if (values instanceof GetItemWithSize) {
            return DynObjectUtils.getAvailableValuesFrom((GetItemWithSize)values);
        }
        return null;
    }
}

