/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.undo.command.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.command.Command;
import org.gvsig.tools.undo.command.UndoRedoCommandStack;
import org.gvsig.tools.undo.command.impl.AbstractCommand;
import org.gvsig.tools.undo.command.impl.CompoundCommand;
import org.gvsig.tools.undo.command.impl.DefaultCommandNotification;

public class DefaultUndoRedoCommandStack
implements UndoRedoCommandStack {
    private Stack undos = new Stack();
    private Stack redos = new Stack();
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable(this);
    private boolean complex = false;
    private CompoundCommand collection = null;

    @Override
    public void add(Command command) {
        if (this.complex) {
            this.collection.add(command);
        } else {
            this.undos.add(command);
            this.redos.clear();
            this.delegateObservable.notifyObservers(new DefaultCommandNotification(command, "add_Command"));
        }
    }

    @Override
    public void undo() throws UndoException {
        AbstractCommand command = (AbstractCommand)this.undos.pop();
        command.undo();
        this.redos.add(command);
        this.delegateObservable.notifyObservers(new DefaultCommandNotification(command, "undo_Command"));
    }

    @Override
    public void redo() throws RedoException {
        AbstractCommand command = (AbstractCommand)this.redos.pop();
        command.redo();
        this.undos.add(command);
        this.delegateObservable.notifyObservers(new DefaultCommandNotification(command, "redo_Command"));
    }

    @Override
    public void redo(int commands) throws RedoException {
        for (int i = 0; i < commands; ++i) {
            this.redo();
        }
    }

    @Override
    public void undo(int commands) throws UndoException {
        for (int i = 0; i < commands; ++i) {
            this.undo();
        }
    }

    @Override
    public boolean canUndo() {
        return !this.undos.isEmpty();
    }

    @Override
    public boolean canRedo() {
        return !this.redos.isEmpty();
    }

    @Override
    public List getUndoInfos() {
        Stack clonedUndos = (Stack)this.undos.clone();
        ArrayList commands = new ArrayList();
        while (!clonedUndos.isEmpty()) {
            commands.add(clonedUndos.pop());
        }
        return commands;
    }

    @Override
    public List getRedoInfos() {
        Stack clonedRedos = (Stack)this.redos.clone();
        ArrayList commands = new ArrayList();
        while (!clonedRedos.isEmpty()) {
            commands.add(clonedRedos.pop());
        }
        return commands;
    }

    @Override
    public int size() {
        return this.undos.size() + this.redos.size();
    }

    @Override
    public void clear() {
        this.redos.clear();
        this.undos.clear();
    }

    @Override
    public Command getNextUndoCommand() {
        return (Command)this.undos.peek();
    }

    @Override
    public Command getNextRedoCommand() {
        return (Command)this.redos.peek();
    }

    @Override
    public void addObserver(Observer o) {
        this.delegateObservable.addObserver(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        this.delegateObservable.deleteObserver(o);
    }

    @Override
    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    @Override
    public void endComplex() {
        if (this.collection.isEmpty()) {
            this.complex = false;
            return;
        }
        this.complex = false;
        this.undos.add(this.collection);
        this.redos.clear();
        this.delegateObservable.notifyObservers(new DefaultCommandNotification(this.collection, "add_Command"));
    }

    @Override
    public void startComplex(String description) {
        this.collection = new CompoundCommand(description);
        this.complex = true;
    }

    @Override
    public boolean inComplex() {
        return this.complex;
    }
}

