/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class FolderPickerControllerImpl
extends AbstractPickerController<File>
implements FolderPickerController {
    private final JButton btnFolder;
    private final JTextComponent txtFolder;
    private final File initialPath;
    private final String fileChooserID;
    private final String dialogTitle;
    private File value;
    private FileFilter filter;

    public static void selfRegister() {
    }

    public FolderPickerControllerImpl(JTextComponent txtFolder, JButton btnFolder, String dialogTitle) {
        this(txtFolder, btnFolder, dialogTitle, null, null, true);
    }

    public FolderPickerControllerImpl(JTextComponent txtFolder, JButton btnFolder) {
        this(txtFolder, btnFolder, null, null, null, true);
    }

    public FolderPickerControllerImpl(JTextComponent txtFolder, JButton btnFolder, String dialogTitle, String fileChooserID, File initialPath, boolean seticon) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.value = null;
        this.txtFolder = txtFolder;
        this.btnFolder = btnFolder;
        this.fileChooserID = fileChooserID;
        this.initialPath = initialPath;
        this.txtFolder.setEditable(false);
        this.dialogTitle = dialogTitle == null ? i18n.getTranslation("_Select_file") : dialogTitle;
        this.txtFolder.setEditable(false);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnFolder, (String)"_Folder_picker", (String)"picker-folder", e -> this.doSelectFile(), null);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public File get() {
        return this.value;
    }

    public void set(File value) {
        this.value = value;
        this.txtFolder.setText(value.toString());
    }

    public void setEnabled(boolean enabled) {
        this.btnFolder.setEnabled(enabled);
        this.txtFolder.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.btnFolder.isEnabled();
    }

    private void doSelectFile() {
        FoldersManager folderManager;
        if (!this.isEditable()) {
            return;
        }
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        Object[] f = dialogs.showChooserDialog(this.dialogTitle, 0, 1, true, (folderManager = ToolsLocator.getFoldersManager()).getLastPath(this.fileChooserID, this.initialPath), this.filter, true);
        if (ArrayUtils.isEmpty((Object[])f)) {
            return;
        }
        this.set((File)f[0]);
        this.fireChangeEvent();
    }

    public void coerceAndSet(Object value) {
        this.set((File)this.coerce(14, value, null));
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }
}

