/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.webbrowsersimple;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.bookmarksandhistory.impl.BaseHistory;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.JWebBrowser;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.DefaultChangeListenerHelper;
import org.gvsig.tools.swing.impl.webbrowsersimple.JWebBrowserSimplelView;

public class JWebBrowserSimple
implements JWebBrowser {
    private final JWebBrowserSimplelView panel;
    private final History<String> history = new BaseHistory(15);
    private final Highlighter.HighlightPainter highlightPainter = new MyHighlightPainter(Color.blue.brighter());
    private final ChangeListenerHelper changeListenerHelper = new DefaultChangeListenerHelper();
    private final JEditorPane browser;
    private int historyPosition = 0;

    public JWebBrowserSimple() {
        this.panel = new JWebBrowserSimplelView();
        this.browser = this.panel.txtBrowser;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        this.browser.setEditable(false);
        this.browser.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.location(hyperlinkEvent.getURL());
            }
        });
        this.panel.btnPrevious.setIcon(theme.get("webbrowser-go-backward"));
        this.panel.btnNext.setIcon(theme.get("webbrowser-go-forward"));
        this.panel.btnRefresh.setIcon(theme.get("webbrowser-refresh"));
        this.panel.btnConfig.setIcon(theme.get("webbrowser-config"));
        this.panel.btnSearchPrevious.setIcon(theme.get("webbrowser-search-backward"));
        this.panel.btnSearchNext.setIcon(theme.get("webbrowser-search-forward"));
        this.panel.imgSearch.setIcon((Icon)theme.get("webbrowser-search"));
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.panel.txtURL);
        toolsSwingManager.addClearButton((JTextComponent)this.panel.txtURL);
        this.panel.txtURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    JWebBrowserSimple.this.location(((JWebBrowserSimple)JWebBrowserSimple.this).panel.txtURL.getText());
                }
            }
        });
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.panel.txtSearch);
        toolsSwingManager.addClearButton((JTextComponent)this.panel.txtSearch);
        this.panel.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                JTextField jtext = ((JWebBrowserSimple)JWebBrowserSimple.this).panel.txtSearch;
                if (event.getKeyChar() == '\u001b') {
                    jtext.setText("");
                    JWebBrowserSimple.this.find("", true);
                } else if (event.getKeyChar() == '\n') {
                    JWebBrowserSimple.this.find(jtext.getText(), true);
                }
            }
        });
        this.panel.btnSearchPrevious.addActionListener(e -> this.find(this.panel.txtSearch.getText(), false));
        this.panel.btnSearchNext.addActionListener(e -> this.find(this.panel.txtSearch.getText(), true));
        this.panel.btnPrevious.addActionListener(e -> this.backward());
        this.panel.btnNext.addActionListener(e -> this.forward());
        this.panel.btnRefresh.addActionListener(e -> this.refresh());
        this.browser.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("page")) {
                this.changeListenerHelper.fireEvent();
            }
        });
        this.panel.setPreferredSize(new Dimension(600, 500));
    }

    public String location(String url) {
        try {
            return this.location(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String location(URL url) {
        this.historyPosition = 0;
        this.history.add((Object)url.toString());
        this.go(url);
        return url.toString();
    }

    private void go(URL url) {
        this.panel.txtURL.setText(url.toString());
        HTMLEditorKit kit = new HTMLEditorKit();
        this.browser.setEditorKit(kit);
        this.removeHighlights(this.browser);
        try {
            this.browser.setPage(url);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setContent(String content, String contentType) {
        this.historyPosition = 0;
        EditorKit kit = this.browser.getEditorKitForContentType(contentType);
        this.browser.setEditorKit(kit);
        this.removeHighlights(this.browser);
        this.browser.setText(content);
    }

    public String title() {
        String text;
        String title = "Untitled";
        Pattern p = Pattern.compile("<title>(?<title>.*)</title>");
        Matcher m = p.matcher(text = this.browser.getText());
        if (m != null && m.find()) {
            title = m.group("title");
        }
        return title;
    }

    public String location() {
        if (this.history.size() < 1) {
            return null;
        }
        return (String)this.history.get(0);
    }

    public void refresh() {
        try {
            if (this.history.size() < 1) {
                return;
            }
            String location = (String)this.history.get(0);
            this.go(new URL(location));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void forward() {
        try {
            if (this.history.size() < 1 || this.historyPosition <= 0) {
                return;
            }
            String location = (String)this.history.get(this.historyPosition--);
            this.go(new URL(location));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void backward() {
        try {
            if (this.history.size() < 1 || this.historyPosition >= this.history.size()) {
                return;
            }
            String location = (String)this.history.get(this.historyPosition++);
            this.go(new URL(location));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void find(String text, boolean backwards) {
        try {
            this.highlight(this.browser, text);
            int pos = this.browser.getCaretPosition();
            Rectangle r = null;
            Highlighter highlighter = this.browser.getHighlighter();
            for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
                if (!(highlight.getPainter() instanceof MyHighlightPainter) || pos >= highlight.getStartOffset()) continue;
                r = this.browser.modelToView(highlight.getStartOffset());
                pos = highlight.getEndOffset();
                break;
            }
            if (r != null) {
                this.browser.setCaretPosition(pos);
                this.browser.scrollRectToVisible(r);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public JComponent asJComponent() {
        return this.panel;
    }

    public void removeHighlights(JTextComponent textComp) {
        Highlighter highlighter = textComp.getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            if (!(highlight.getPainter() instanceof MyHighlightPainter)) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    public void highlight(JTextComponent textComp, String pattern) {
        this.removeHighlights(textComp);
        try {
            Highlighter highlighter = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            while ((pos = text.toUpperCase().indexOf(pattern.toUpperCase(), pos)) >= 0) {
                highlighter.addHighlight(pos, pos + pattern.length(), this.highlightPainter);
                pos += pattern.length();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    private class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

