/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.ConsolePrefs;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.util.WordUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.Terminal;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.console.completer.FileNameCompleter;
import jline.internal.Log;

public class Console {
    private static final Logger logger = Logger.getLogger(Console.class.getName());
    private java.io.Console console;
    private ConsoleReader consoleReader;
    private FileNameCompleter fileNameCompleter;
    private final InstallData installData;

    public Console(InstallData installData, ConsolePrefs prefs) {
        this.installData = installData;
        Log.setOutput(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
        if (prefs.enableConsoleReader) {
            this.initConsoleReader();
        }
        if (this.consoleReader == null) {
            this.console = System.console();
        }
    }

    private void initConsoleReader() {
        try {
            this.consoleReader = new ConsoleReader("IzPack", new FileInputStream(FileDescriptor.in), System.out, null);
            this.consoleReader.setHandleUserInterrupt(true);
            Terminal terminal = this.consoleReader.getTerminal();
            if (terminal == null || terminal instanceof UnsupportedTerminal) {
                this.consoleReader.shutdown();
                throw new Throwable("Terminal not initialized");
            }
            this.fileNameCompleter = new FileNameCompleter();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Cannot initialize the console reader. Falling back to default console.", t);
        }
    }

    public int read() throws IOException {
        int c = -1;
        if (this.consoleReader != null) {
            c = this.consoleReader.readCharacter();
        } else if (this.console != null) {
            c = this.console.reader().read();
        }
        return c;
    }

    public String readLine() throws IOException {
        if (this.consoleReader != null) {
            try {
                return this.consoleReader.readLine();
            }
            catch (jline.console.UserInterruptException e) {
                throw new UserInterruptException(this.installData.getMessages().get("ConsoleInstaller.aborted.PressedCTRL-C", new Object[0]), e);
            }
        }
        return this.readLineDefaultInput();
    }

    public void flush() throws IOException {
        if (this.consoleReader != null) {
            this.consoleReader.flush();
        } else if (this.console != null) {
            this.console.flush();
        }
        System.out.flush();
    }

    private List<CharSequence> getLines(String text) {
        LinkedList<CharSequence> lines = new LinkedList<CharSequence>();
        StringTokenizer line = new StringTokenizer(text, "\n");
        while (line.hasMoreTokens()) {
            String token = line.nextToken();
            lines.add(token);
        }
        return lines;
    }

    public void printMultiLine(String text, boolean wrap, boolean paging) throws IOException {
        if (wrap) {
            int width = 80;
            boolean wrapLineFull = true;
            if (this.consoleReader != null) {
                Terminal terminal = this.consoleReader.getTerminal();
                width = terminal.getWidth();
                wrapLineFull = terminal.hasWeirdWrap();
            }
            text = WordUtil.wordWrap(text, width, wrapLineFull);
        }
        if (paging) {
            this.paging(text);
        } else {
            this.println(text);
        }
    }

    public void printFilledLine(char c) {
        int width = 80;
        boolean wrapLineFull = true;
        if (this.consoleReader != null) {
            Terminal terminal = this.consoleReader.getTerminal();
            width = terminal.getWidth();
            wrapLineFull = terminal.hasWeirdWrap();
        }
        this.print(c, width);
        if (wrapLineFull) {
            this.println();
        }
    }

    public void printMessageBox(String title, String message) {
        int termWidth = 80;
        boolean wrapLineFull = true;
        if (this.consoleReader != null) {
            Terminal terminal = this.consoleReader.getTerminal();
            termWidth = terminal.getWidth();
        }
        if (title != null && title.length() > termWidth) {
            title = WordUtil.wordWrap(title, termWidth, wrapLineFull);
        }
        if (message != null && message.length() > termWidth) {
            message = WordUtil.wordWrap(message, termWidth, wrapLineFull);
        }
        int len = title != null ? Math.max(title.length(), message.length()) : message.length();
        int width = Math.min(termWidth, len);
        this.print('-', width);
        this.println();
        if (title != null) {
            this.println(title);
            this.println();
        }
        this.println(message);
        this.print('-', width);
        this.println();
    }

    private void paging(String text) throws IOException {
        int height = this.consoleReader != null ? this.consoleReader.getTerminal().getHeight() : 23;
        int showLines = height - 2;
        int line = 0;
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        while (tokens.hasMoreTokens()) {
            int c;
            String token = tokens.nextToken();
            this.println(token);
            if (++line < showLines || !tokens.hasMoreTokens()) continue;
            if (this.consoleReader != null) {
                this.println("--" + this.installData.getMessages().get("ConsoleInstaller.pagingMore", new Object[0]) + "--");
                this.flush();
            }
            if ((c = this.read()) == 13 || c == 10) {
                showLines = 1;
            } else if (c != 113) {
                showLines = height - 2;
            }
            if (c == 113) break;
            line = 0;
        }
    }

    private void print(char c, int num) {
        if (num == 1) {
            this.print(String.valueOf(c));
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.print(String.copyValueOf(chars));
        }
    }

    public void print(String message) {
        if (this.console != null) {
            this.console.printf("%s", message);
            this.console.flush();
        } else {
            System.out.print(message);
        }
    }

    public void println() {
        if (this.console != null) {
            this.console.printf("\n", new Object[0]);
        } else {
            System.out.println();
        }
    }

    public void println(String message) {
        if (this.console != null) {
            this.console.printf("%s\n", message);
        } else {
            System.out.println(message);
        }
    }

    public int prompt(String prompt, int min, int max, int eof) {
        return this.prompt(prompt, min, max, min - 1, eof);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int prompt(String prompt, int min, int max, int defaultValue, int eof) {
        int result = min - 1;
        try {
            do {
                this.println(prompt);
                String value = this.readLine();
                if (value == null) return eof;
                if ((value = value.trim()).isEmpty() && defaultValue >= min) {
                    return defaultValue;
                }
                try {
                    result = Integer.valueOf(value);
                }
                catch (NumberFormatException ignore) {}
            } while (result < min || result > max);
            return result;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return eof;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String promptLocation(String prompt, String defaultValue) {
        String result;
        if (this.consoleReader == null) return this.prompt(prompt, defaultValue);
        this.consoleReader.addCompleter(this.fileNameCompleter);
        this.println(prompt);
        try {
            result = this.consoleReader.readLine();
            if (result == null) return result;
            if ((result = result.trim()).startsWith("~")) {
                result = result.replace("~", System.getProperty("user.home"));
            }
            if (result.endsWith(File.separator) && result.length() > 1) {
                result = result.substring(0, result.length() - 1);
            }
            if (!result.isEmpty()) return result;
            result = defaultValue;
            return result;
        }
        catch (jline.console.UserInterruptException e) {
            throw new UserInterruptException(this.installData.getMessages().get("ConsoleInstaller.aborted.PressedCTRL-C", new Object[0]), e);
        }
        catch (IOException e) {
            result = null;
            logger.log(Level.WARNING, e.getMessage(), e);
            return result;
        }
        finally {
            this.consoleReader.removeCompleter(this.fileNameCompleter);
        }
    }

    public String promptPassword(String prompt, String defaultValue) {
        if (this.consoleReader == null) {
            try {
                char[] passwd = this.readPasswordDefaultInput(defaultValue, "%s\n", prompt);
                return new String(passwd);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        String result = "";
        String backspace = "\b \b";
        String echoCharacter = "*";
        StringBuilder stringBuilder = new StringBuilder();
        this.println(prompt);
        boolean submitted = false;
        try {
            block8: while (!submitted) {
                int ch = this.consoleReader.readCharacter();
                switch (ch) {
                    case -1: 
                    case 10: 
                    case 13: {
                        this.println("");
                        result = stringBuilder.toString();
                        submitted = true;
                        continue block8;
                    }
                    case 8: 
                    case 127: {
                        if (stringBuilder.length() <= 0) continue block8;
                        this.print(backspace);
                        stringBuilder.setLength(stringBuilder.length() - 1);
                        continue block8;
                    }
                }
                this.print(echoCharacter);
                stringBuilder.append((char)ch);
            }
        }
        catch (IOException e) {
            result = null;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (result != null && result.isEmpty()) {
            result = defaultValue;
        }
        return result;
    }

    public String prompt(String prompt, String defaultValue) {
        String result;
        try {
            this.println(prompt);
            result = this.readLine();
            if (result != null && result.isEmpty()) {
                result = defaultValue;
            }
        }
        catch (IOException e) {
            result = null;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return result;
    }

    public String prompt(String prompt, String[] values) {
        return this.prompt(prompt, values, "");
    }

    public String prompt(String prompt, String[] values, String defaultValue) {
        String input;
        while ((input = this.prompt(prompt, defaultValue)) != null) {
            for (String value : values) {
                if (!value.equalsIgnoreCase(input)) continue;
                return value;
            }
        }
        return null;
    }

    private String readLineDefaultInput() {
        String result = null;
        if (this.console != null) {
            result = this.console.readLine();
        }
        return result;
    }

    private char[] readPasswordDefaultInput(String defaultValue, String format, Object ... args) throws IOException {
        char[] result;
        if (this.console != null) {
            result = this.console.readPassword(format, args);
            if (result.length == 0) {
                result = defaultValue != null ? defaultValue.toCharArray() : null;
            }
        } else {
            String line = this.readLine();
            result = line != null ? line.toCharArray() : null;
        }
        return result;
    }
}

