/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Compiler;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultOptimizer;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.packageutils.impl.DefaultVersion;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.script.ScriptManager;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpression
implements Expression,
LabeledValue<Expression> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpression.class);
    private static final Version VERSION_2_6_0_1 = ToolsLocator.getPackageManager().createVersion("2.6.0-1");
    public static final String COMPATIBILITY_SELECT_ID = "SELECT";
    public static final String COMPATIBILITY_SELECT_OPTIONAL_SEMICOLON_AT_END = "OPTIONAL_SEMICOLON_AT_END";
    private String phrase = null;
    private Code code = null;
    private Interpreter interpreter;
    private boolean hasNotBeenOptimized = true;
    private SymbolTable mySymbolTable = null;
    private WeakReference<SymbolTable> lastSymbolTable = null;
    private boolean useBracketsForIdentifiers = false;
    protected ExpressionEvaluatorManager manager;

    public DefaultExpression() {
        this(ExpressionEvaluatorLocator.getExpressionEvaluatorManager());
    }

    public DefaultExpression(ExpressionEvaluatorManager manager) {
        this.manager = manager;
    }

    public String getLabel() {
        return StringUtils.abbreviate((String)StringUtils.normalizeSpace((String)this.getPhrase()), (int)35);
    }

    public Expression getValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Expression)) {
            return false;
        }
        String this_s = this.toJSON();
        String other_s = ((Expression)obj).toJSON();
        return this_s.equals(other_s);
    }

    public int hashCode() {
        String this_s = this.toJSON();
        return Objects.hashCode(this_s);
    }

    public SymbolTable getSymbolTable() {
        if (this.mySymbolTable == null) {
            this.mySymbolTable = ExpressionUtils.createSymbolTable();
        }
        return this.mySymbolTable;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public boolean isPhraseEmpty() {
        return StringUtils.isBlank((CharSequence)this.phrase);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.phrase);
    }

    public Expression setPhrase(String phrase) {
        this.phrase = phrase;
        this.code = null;
        this.hasNotBeenOptimized = true;
        return this;
    }

    public void clear() {
        this.phrase = null;
        this.code = null;
        this.interpreter = null;
        this.hasNotBeenOptimized = true;
    }

    public Code getCode() {
        if (this.code == null) {
            Compiler compiler = this.manager.createCompiler();
            compiler.getLexicalAnalyzer().setUseBracketsForIdentifiers(this.useBracketsForIdentifiers);
            this.code = compiler.compileExpression(this.phrase);
        }
        return this.code;
    }

    public void setSQLCompatible(boolean sqlCompatible) {
        this.getInterpreter().setSQLCompatible(sqlCompatible);
    }

    public boolean isSQLCompatible() {
        return this.getInterpreter().isSQLCompatible();
    }

    private Interpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = this.manager.createInterpreter();
        }
        return this.interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(SymbolTable symbolTable) {
        if (this.interpreter == null) {
            this.interpreter = this.manager.createInterpreter();
        }
        boolean added = false;
        if (symbolTable != null) {
            added = this.getSymbolTable().addSymbolTable(symbolTable);
            if (this.lastSymbolTable == null) {
                this.lastSymbolTable = new WeakReference<SymbolTable>(symbolTable);
            } else if (this.lastSymbolTable.get() != symbolTable) {
                this.link(this.getSymbolTable());
                this.hasNotBeenOptimized = true;
            }
        }
        try {
            Object x;
            Code code_exp;
            this.interpreter.setSymbolTable(this.getSymbolTable());
            if (this.hasNotBeenOptimized) {
                try {
                    Optimizer optimizer = this.manager.createOptimizer();
                    optimizer.setSymbolTable(this.getSymbolTable());
                    this.code = optimizer.optimize(this.getCode());
                }
                catch (Throwable optimizer) {
                    // empty catch block
                }
                this.hasNotBeenOptimized = false;
            }
            if (this.manager.hasHostExpressions(code_exp = this.getCode())) {
                code_exp = this.manager.resolveHostExpressions(code_exp, this.interpreter);
            }
            Object object = x = this.interpreter.run(code_exp);
            return object;
        }
        finally {
            if (added) {
                this.getSymbolTable().removeSymbolTable(symbolTable);
            }
        }
    }

    public void link(SymbolTable symbolTable) {
        if (this.interpreter == null) {
            this.interpreter = this.manager.createInterpreter();
        }
        this.lastSymbolTable = new WeakReference<SymbolTable>(symbolTable);
        this.interpreter.setSymbolTable(symbolTable);
        if (this.hasNotBeenOptimized) {
            DefaultOptimizer optimizer = new DefaultOptimizer(this.manager, symbolTable);
            this.code = optimizer.optimize(this.getCode());
            this.hasNotBeenOptimized = false;
        }
        this.interpreter.link(this.getCode());
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("version", (Persistent)VERSION_2_6_0_1);
        state.set("phrase", this.phrase);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        ScriptManager scriptManager = ToolsLocator.getScriptManager();
        this.clear();
        Version version = (Version)state.get("version");
        this.phrase = state.getString("phrase");
        this.fixCompatibility(version);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("Expression") == null) {
            DynStruct definition = manager.addDefinition(DefaultExpression.class, "Expression", "Expression persistence definition", null, null);
            definition.addDynFieldString("phrase").setMandatory(false);
            definition.addDynFieldObject("version").setClassOfValue(DefaultVersion.class).setMandatory(false);
        }
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("phrase", this.phrase);
        builder.add("version", VERSION_2_6_0_1.toString());
        return builder;
    }

    public void fromJson(JsonObject values) {
        this.clear();
        if (values.containsKey((Object)"phrase")) {
            this.phrase = values.getString("phrase");
        }
        String version_s = values.getString("version", null);
        Version version = ToolsLocator.getPackageManager().createVersion(version_s);
        this.fixCompatibility(version);
    }

    @Deprecated
    public String toJSON() {
        return this.toJson().toString();
    }

    @Deprecated
    public void fromJSON(String json) {
        this.fromJson(Json.createObject((String)json));
    }

    public Expression clone() throws CloneNotSupportedException {
        Expression other = (Expression)super.clone();
        other.fromJson(this.toJson());
        return other;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("phrase", (Object)this.phrase);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public void setUseBracketsForIdentifiers(boolean useBracketsForIdentifiers) {
        this.useBracketsForIdentifiers = useBracketsForIdentifiers;
    }

    public boolean getUseBracketsForIdentifiers() {
        return this.useBracketsForIdentifiers;
    }

    public Evaluator toEvaluator() {
        ExpressionEvaluator evaluator = this.manager.createExpressionEvaluator((Expression)this);
        return evaluator;
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    private void fixCompatibility(Version version) {
        if (version == null || version.compareTo((Object)VERSION_2_6_0_1) < 0) {
            try {
                if (StringUtils.isNotBlank((CharSequence)this.phrase)) {
                    ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
                    Compiler compiler = expressionManager.createCompiler();
                    compiler.addCompatibility(COMPATIBILITY_SELECT_ID, COMPATIBILITY_SELECT_OPTIONAL_SEMICOLON_AT_END);
                    Code code = compiler.compileExpressionQuietly(this.phrase);
                    if (code != null) {
                        code.link();
                        this.phrase = code.toString((Formatter)new Code.EmptyFormatter(true, 4));
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Can't check select compatibility in select (" + this.phrase + ")", t);
            }
        }
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultExpression.class;
        }

        public Object toObject(JsonObject json) {
            DefaultExpression o = new DefaultExpression();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }
}

